/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.classifications.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationMappingStore {
    private static final Logger log = LoggerFactory.getLogger(ClassificationMappingStore.class);
    private List<TypeDef> typeDefs = new ArrayList<TypeDef>();
    private Map<String, ClassificationMapping> omrsGuidToMapping = new HashMap<String, ClassificationMapping>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();

    public boolean addMapping(TypeDef omrsTypeDef, Class mappingClass) {
        ClassificationMapping mapping = this.getClassificationMapper(mappingClass);
        if (mapping != null) {
            this.typeDefs.add(omrsTypeDef);
            String guid = omrsTypeDef.getGUID();
            this.omrsGuidToMapping.put(guid, mapping);
            this.omrsNameToGuid.put(omrsTypeDef.getName(), guid);
        }
        return mapping != null;
    }

    public List<TypeDef> getTypeDefs() {
        return this.typeDefs;
    }

    public ClassificationMapping getMappingByOmrsTypeGUID(String guid) {
        if (this.omrsGuidToMapping.containsKey(guid)) {
            return this.omrsGuidToMapping.get(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)guid);
        return null;
    }

    public ClassificationMapping getMappingByOmrsTypeName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getMappingByOmrsTypeGUID(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)name);
        return null;
    }

    private ClassificationMapping getClassificationMapper(Class mappingClass) {
        ClassificationMapping classificationMapper = null;
        try {
            Method getInstance = mappingClass.getMethod("getInstance", new Class[0]);
            classificationMapper = (ClassificationMapping)getInstance.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to find or instantiate ClassificationMapping class: {}", (Object)mappingClass, (Object)e);
        }
        return classificationMapper;
    }
}

