/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.EntityMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMappingStore {
    private static final Logger log = LoggerFactory.getLogger(EntityMappingStore.class);
    private List<TypeDef> typeDefs = new ArrayList<TypeDef>();
    private Map<String, EntityMapping> omrsGuidToMapping = new HashMap<String, EntityMapping>();
    private Map<String, List<String>> igcAssetTypeToOmrsGuids = new HashMap<String, List<String>>();
    private Map<String, String> igcAssetDisplayNameToOmrsGuid = new HashMap<String, String>();
    private Map<String, String> igcAssetTypeAndPrefixToOmrsGuid = new HashMap<String, String>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();

    public List<TypeDef> getTypeDefs() {
        return this.typeDefs;
    }

    public boolean addMapping(TypeDef omrsTypeDef, Class mappingClass, IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String userId) {
        EntityMapping mapping = this.getEntityMapper(mappingClass, igcomrsRepositoryConnector, userId);
        if (mapping != null) {
            this.typeDefs.add(omrsTypeDef);
            String guid = omrsTypeDef.getGUID();
            this.omrsGuidToMapping.put(guid, mapping);
            this.omrsNameToGuid.put(omrsTypeDef.getName(), guid);
            String igcAssetType = mapping.getIgcAssetType();
            this.addIgcAssetTypeToGuid(igcAssetType, guid);
            this.igcAssetDisplayNameToOmrsGuid.put(mapping.getIgcAssetTypeDisplayName(), guid);
            String prefix = "";
            if (mapping.getIgcRidPrefix() != null) {
                prefix = mapping.getIgcRidPrefix();
            }
            this.igcAssetTypeAndPrefixToOmrsGuid.put(prefix + igcAssetType, guid);
            for (String otherType : mapping.getOtherIGCAssetTypes()) {
                this.addIgcAssetTypeToGuid(otherType, guid);
            }
            IGCRestClient igcRestClient = igcomrsRepositoryConnector.getIGCRestClient();
            igcRestClient.registerPOJO(mapping.getIgcPOJO());
            List<Class> otherPOJOs = mapping.getOtherIGCPOJOs();
            if (otherPOJOs != null && !otherPOJOs.isEmpty()) {
                for (Class pojo : mapping.getOtherIGCPOJOs()) {
                    igcRestClient.registerPOJO(pojo);
                }
            }
        }
        return mapping != null;
    }

    private void addIgcAssetTypeToGuid(String igcAssetType, String guid) {
        if (!this.igcAssetTypeToOmrsGuids.containsKey(igcAssetType)) {
            this.igcAssetTypeToOmrsGuids.put(igcAssetType, new ArrayList());
        }
        this.igcAssetTypeToOmrsGuids.get(igcAssetType).add(guid);
    }

    public EntityMapping getMappingByOmrsTypeGUID(String guid) {
        if (this.omrsGuidToMapping.containsKey(guid)) {
            return this.omrsGuidToMapping.get(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)guid);
        return null;
    }

    public List<EntityMapping> getMappingsByIgcAssetType(String assetType) {
        String simpleType = Reference.getAssetTypeForSearch((String)assetType);
        if (this.igcAssetTypeToOmrsGuids.containsKey(simpleType)) {
            List<String> guids = this.igcAssetTypeToOmrsGuids.get(simpleType);
            ArrayList<EntityMapping> mappings = new ArrayList<EntityMapping>();
            for (String guid : guids) {
                mappings.add(this.getMappingByOmrsTypeGUID(guid));
            }
            return mappings;
        }
        log.warn("Unable to find mapping for IGC type: {}", (Object)simpleType);
        return null;
    }

    public EntityMapping getMappingByIgcAssetDisplayName(String assetDisplayName) {
        if (this.igcAssetDisplayNameToOmrsGuid.containsKey(assetDisplayName)) {
            String guid = this.igcAssetDisplayNameToOmrsGuid.get(assetDisplayName);
            return this.getMappingByOmrsTypeGUID(guid);
        }
        log.warn("Unable to find mapping for IGC asset display name: {}", (Object)assetDisplayName);
        return null;
    }

    public EntityMapping getMappingByIgcAssetTypeAndPrefix(String assetType, String prefix) {
        String simpleType = Reference.getAssetTypeForSearch((String)assetType);
        String key = (prefix == null ? "" : prefix) + simpleType;
        if (this.igcAssetTypeAndPrefixToOmrsGuid.containsKey(key)) {
            String guid = this.igcAssetTypeAndPrefixToOmrsGuid.get(key);
            return this.getMappingByOmrsTypeGUID(guid);
        }
        log.warn("Unable to find mapping for IGC asset type with prefix: {}", (Object)key);
        return null;
    }

    public EntityMapping getMappingByOmrsTypeName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getMappingByOmrsTypeGUID(guid);
        }
        log.warn("Unable to find mapping for OMRS type: {}", (Object)name);
        return null;
    }

    public List<EntityMapping> getAllMappings() {
        return new ArrayList<EntityMapping>(this.omrsGuidToMapping.values());
    }

    public EntityMapping getDefaultEntityMapper(IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String userId) {
        EntityMapping referenceable = null;
        try {
            Class<?> mappingClass = Class.forName("org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.ReferenceableMapper");
            referenceable = this.getEntityMapper(mappingClass, igcomrsRepositoryConnector, userId);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find default ReferenceableMapper class: org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.mapping.entities.ReferenceableMapper", (Throwable)e);
        }
        return referenceable;
    }

    private EntityMapping getEntityMapper(Class mappingClass, IGCOMRSRepositoryConnector igcomrsRepositoryConnector, String userId) {
        EntityMapping entityMapper = null;
        try {
            Constructor constructor = mappingClass.getConstructor(IGCOMRSRepositoryConnector.class, String.class);
            entityMapper = (EntityMapping)constructor.newInstance(new Object[]{igcomrsRepositoryConnector, userId});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to find or instantiate EntityMapping class: {}", (Object)mappingClass, (Object)e);
        }
        return entityMapper;
    }
}

