/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.repositoryconnector.stores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefStore {
    private static final Logger log = LoggerFactory.getLogger(TypeDefStore.class);
    private Map<String, TypeDef> omrsGuidToTypeDef = new HashMap<String, TypeDef>();
    private Map<String, String> omrsNameToGuid = new HashMap<String, String>();
    private Map<String, Map<String, TypeDefAttribute>> omrsGuidToAttributeMap = new HashMap<String, Map<String, TypeDefAttribute>>();
    private Map<String, TypeDef> unimplementedTypeDefs = new HashMap<String, TypeDef>();

    public void addTypeDef(TypeDef typeDef) {
        String guid = typeDef.getGUID();
        this.omrsGuidToTypeDef.put(guid, typeDef);
        this.omrsNameToGuid.put(typeDef.getName(), guid);
        this.addAttributes(typeDef.getPropertiesDefinition(), guid);
    }

    public void addUnimplementedTypeDef(TypeDef typeDef) {
        String guid = typeDef.getGUID();
        this.unimplementedTypeDefs.put(guid, typeDef);
        this.addAttributes(typeDef.getPropertiesDefinition(), guid);
    }

    private void addAttributes(List<TypeDefAttribute> attributes, String guid) {
        if (!this.omrsGuidToAttributeMap.containsKey(guid)) {
            this.omrsGuidToAttributeMap.put(guid, new HashMap());
        }
        if (attributes != null) {
            for (TypeDefAttribute attribute : attributes) {
                this.omrsGuidToAttributeMap.get(guid).put(attribute.getAttributeName(), attribute);
            }
        }
    }

    public TypeDef getUnimplementedTypeDefByGUID(String guid) {
        if (this.unimplementedTypeDefs.containsKey(guid)) {
            return this.unimplementedTypeDefs.get(guid);
        }
        log.warn("Unable to find unimplemented OMRS TypeDef: {}", (Object)guid);
        return null;
    }

    public TypeDef getTypeDefByGUID(String guid) {
        return this.getTypeDefByGUID(guid, true);
    }

    private TypeDef getTypeDefByGUID(String guid, boolean warnIfNotFound) {
        if (this.omrsGuidToTypeDef.containsKey(guid)) {
            return this.omrsGuidToTypeDef.get(guid);
        }
        if (warnIfNotFound) {
            log.warn("Unable to find OMRS TypeDef by GUID: {}", (Object)guid);
        }
        return null;
    }

    public TypeDef getTypeDefByName(String name) {
        return this.getTypeDefByName(name, true);
    }

    private TypeDef getTypeDefByName(String name, boolean warnIfNotFound) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getTypeDefByGUID(guid, warnIfNotFound);
        }
        if (warnIfNotFound) {
            log.warn("Unable to find OMRS TypeDef by Name: {}", (Object)name);
        }
        return null;
    }

    private Map<String, TypeDefAttribute> getTypeDefAttributesByGUID(String guid) {
        if (this.omrsGuidToAttributeMap.containsKey(guid)) {
            return this.omrsGuidToAttributeMap.get(guid);
        }
        log.warn("Unable to find attributes for OMRS TypeDef by GUID: {}", (Object)guid);
        return null;
    }

    public Map<String, TypeDefAttribute> getAllTypeDefAttributesForGUID(String guid) {
        Map<String, TypeDefAttribute> all = this.getTypeDefAttributesByGUID(guid);
        if (all != null) {
            TypeDefLink superType;
            TypeDef typeDef = this.getTypeDefByGUID(guid, false);
            if (typeDef == null) {
                typeDef = this.getUnimplementedTypeDefByGUID(guid);
            }
            if ((superType = typeDef.getSuperType()) != null) {
                all.putAll(this.getAllTypeDefAttributesForGUID(superType.getGUID()));
            }
        }
        return all;
    }

    public Map<String, TypeDefAttribute> getAllTypeDefAttributesForName(String name) {
        if (this.omrsNameToGuid.containsKey(name)) {
            String guid = this.omrsNameToGuid.get(name);
            return this.getAllTypeDefAttributesForGUID(guid);
        }
        log.warn("Unable to find attributes for OMRS TypeDef by Name: {}", (Object)name);
        return null;
    }

    public List<TypeDef> getAllTypeDefs() {
        return new ArrayList<TypeDef>(this.omrsGuidToTypeDef.values());
    }
}

