/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.virtualdataconnector.igc.admin;

import java.util.Map;
import org.odpi.openmetadata.adminservices.OMAGServerAdminServices;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.properties.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.properties.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/servers/{serverName}"})
public class IGCRepositoryProxyAdminResource {
    private OMAGServerAdminServices adminAPI = new OMAGServerAdminServices();

    @RequestMapping(method={RequestMethod.GET}, path={"/server-origin"})
    public String getServerOrigin() {
        return "IGC Repository Proxy";
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/server-url-root"})
    public VoidResponse setServerURLRoot(@PathVariable String userId, @PathVariable String serverName, @RequestParam String url) {
        return this.adminAPI.setServerURLRoot(userId, serverName, url);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/server-type"})
    public VoidResponse setServerType(@PathVariable String userId, @PathVariable String serverName, @RequestParam String typeName) {
        return this.adminAPI.setServerType(userId, serverName, typeName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/organization-name"})
    public VoidResponse setOrganizationName(@PathVariable String userId, @PathVariable String serverName, @RequestParam String name) {
        return this.adminAPI.setOrganizationName(userId, serverName, name);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/server-user-id"})
    public VoidResponse setServerUserId(@PathVariable String userId, @PathVariable String serverName, @RequestParam String id) {
        return this.adminAPI.setServerUserId(userId, serverName, id);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/max-page-size"})
    public VoidResponse setMaxPageSize(@PathVariable String userId, @PathVariable String serverName, @RequestParam int limit) {
        return this.adminAPI.setMaxPageSize(userId, serverName, limit);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/event-bus"})
    public VoidResponse setEventBus(@PathVariable String userId, @PathVariable String serverName, @RequestParam(required=false) String connectorProvider, @RequestParam(required=false) String topicURLRoot, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setEventBus(userId, serverName, connectorProvider, topicURLRoot, additionalProperties);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/mode/repository-proxy/connection"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connection);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/mode/repository-proxy/details"})
    public VoidResponse setRepositoryProxyConnection(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setRepositoryProxyConnection(userId, serverName, connectorProvider, additionalProperties);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/event-mapper-connection"})
    public VoidResponse setLocalRepositoryEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.adminAPI.setLocalRepositoryEventMapper(userId, serverName, connection);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/event-mapper-details"})
    public VoidResponse setLocalRepositoryEventMapper(@PathVariable String userId, @PathVariable String serverName, @RequestParam String connectorProvider, @RequestParam String eventSource, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.setLocalRepositoryEventMapper(userId, serverName, connectorProvider, eventSource, additionalProperties);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/cohorts/{cohortName}"})
    public VoidResponse enableCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody(required=false) Map<String, Object> additionalProperties) {
        return this.adminAPI.enableCohortRegistration(userId, serverName, cohortName, additionalProperties);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/cohorts/{cohortName}"})
    public VoidResponse disableCohortRegistration(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName) {
        return this.adminAPI.disableCohortRegistration(userId, serverName, cohortName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/local-repository/configuration"})
    public VoidResponse setLocalRepositoryConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody LocalRepositoryConfig localRepositoryConfig) {
        return this.adminAPI.setLocalRepositoryConfig(userId, serverName, localRepositoryConfig);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/cohorts/{cohortName}/configuration"})
    public VoidResponse setCohortConfig(@PathVariable String userId, @PathVariable String serverName, @PathVariable String cohortName, @RequestBody CohortConfig cohortConfig) {
        return this.adminAPI.setCohortConfig(userId, serverName, cohortName, cohortConfig);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/configuration"})
    public OMAGServerConfigResponse getCurrentConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.getCurrentConfiguration(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instance"})
    public VoidResponse activateWithStoredConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.activateWithStoredConfig(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instance/configuration"})
    public VoidResponse activateWithSuppliedConfig(@PathVariable String userId, @PathVariable String serverName, @RequestParam OMAGServerConfig configuration) {
        return this.adminAPI.activateWithSuppliedConfig(userId, serverName, configuration);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/instance"})
    public VoidResponse deactivateTemporarily(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.deactivateTemporarily(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={""})
    public VoidResponse deactivatePermanently(@PathVariable String userId, @PathVariable String serverName) {
        return this.adminAPI.deactivatePermanently(userId, serverName);
    }
}

