/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.virtualdataconnector.igc.connectors.eventmapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.eventmapper.IGCOMRSRepositoryEventMapper;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.eventmapper.model.Constants;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.eventmapper.model.IGCKafkaEvent;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.IGCOMRSRepositoryConnector;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.model.Context;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.model.IGCColumn;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.model.IGCObject;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.model.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IGCOMRSRepositoryEventMapper
extends OMRSRepositoryEventMapperBase {
    private static final Logger log = LoggerFactory.getLogger(IGCOMRSRepositoryEventMapper.class);
    private IGCOMRSRepositoryConnector igcomrsRepositoryConnector;
    private String originatorServerName;
    private String metadataCollectionId;
    private String originatorServerType;
    private String sourceName;
    private String originatorOrganizationName;

    public void start() throws ConnectorCheckedException {
        super.start();
        this.igcomrsRepositoryConnector = (IGCOMRSRepositoryConnector)this.repositoryConnector;
        this.originatorServerName = this.localServerName;
        this.metadataCollectionId = this.igcomrsRepositoryConnector.getMetadataCollectionId();
        this.originatorServerType = "IGC";
        this.sourceName = "IGCOMRSRepositoryEventMapper";
        this.originatorOrganizationName = "ING";
        this.runConsumer();
    }

    public void runConsumer() {
        new Thread((Runnable)new ConsumerThread(this, null)).start();
    }

    private Consumer<Long, String> createConsumer() {
        Properties props = this.getProperties();
        KafkaConsumer consumer = new KafkaConsumer(props);
        String topicName = this.connectionBean.getEndpoint().getAddress().split("/")[1];
        consumer.subscribe(Collections.singletonList(topicName));
        return consumer;
    }

    private Properties getProperties() {
        Properties props = new Properties();
        String address = this.connectionBean.getEndpoint().getAddress().split("/")[0];
        props.put("bootstrap.servers", address);
        props.put("group.id", "kafka_IGC_Consumer");
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("value.deserializer", StringDeserializer.class.getName());
        return props;
    }

    private IGCKafkaEvent getIGCKafkaEvent(ObjectMapper mapper, ConsumerRecord<Long, String> event) throws IOException {
        String eventContent = (String)event.value();
        log.info("Consumer Record: {}", (Object)eventContent);
        return (IGCKafkaEvent)mapper.readValue(eventContent, IGCKafkaEvent.class);
    }

    private void processEvent(IGCKafkaEvent igcKafkaEvent) {
        if ("IMAM_SHARE_EVENT".equals(igcKafkaEvent.getEventType())) {
            this.processIMAM(igcKafkaEvent);
        } else {
            this.process(igcKafkaEvent);
        }
    }

    private void processIMAM(IGCKafkaEvent igcKafkaEvent) {
        log.info("Process IMAM started!");
        List createdRIDs = igcKafkaEvent.getDatacollectionRID();
        for (String id : createdRIDs) {
            this.createSchema(id);
        }
        log.info("Process IMAM ended!");
    }

    private void createSchema(String id) {
        IGCObject igcTable = this.igcomrsRepositoryConnector.genericIGCQuery(id);
        IGCObject igcEndpoint = this.igcomrsRepositoryConnector.genericIGCQuery(((Context)igcTable.getContext().get(0)).getId());
        IGCObject igcDatabase = this.igcomrsRepositoryConnector.genericIGCQuery(((Context)igcTable.getContext().get(1)).getId());
        IGCObject igcSchema = this.igcomrsRepositoryConnector.genericIGCQuery(((Context)igcTable.getContext().get(2)).getId());
        String tableQualifiedName = this.getQualifiedName(igcTable.getContext(), igcTable.getName());
        String tableTypeQualifiedName = this.getTypeQualifiedName(tableQualifiedName);
        String dbSchemaQualifiedName = this.getQualifiedName(igcSchema.getContext(), igcSchema.getName());
        String dbSchemaTypeQualifiedName = this.getTypeQualifiedName(dbSchemaQualifiedName);
        String databaseQualifiedName = this.getQualifiedName(igcDatabase.getContext(), igcDatabase.getName());
        String endpointQualifiedName = this.getQualifiedName(null, igcEndpoint.getName());
        this.createEntity(igcDatabase, false, "Database", databaseQualifiedName);
        this.createEntity(igcEndpoint, false, "Endpoint", endpointQualifiedName);
        this.createEntity(igcSchema, false, "DeployedDatabaseSchema", dbSchemaQualifiedName);
        this.createEntity(igcTable, false, "RelationalTable", tableQualifiedName);
        this.createEntity(igcSchema, true, "RelationalDBSchemaType", dbSchemaTypeQualifiedName);
        this.createEntity(igcTable, true, "RelationalTableType", tableTypeQualifiedName);
        String relationalDBSchemaTypeID = "RelationalDBSchemaType." + igcSchema.getId();
        String relationalTableTypeID = "RelationalTableType." + igcTable.getId();
        EntityProxy databaseProxy = this.newEntityProxy("Database", databaseQualifiedName, igcDatabase.getId());
        EntityProxy deployedDBSchemaProxy = this.newEntityProxy("DeployedDatabaseSchema", dbSchemaQualifiedName, igcSchema.getId());
        this.createRelationship("DataContentForDataSet", databaseProxy, deployedDBSchemaProxy);
        EntityProxy relationalDbSchemaTypeProxy = this.newEntityProxy("RelationalDBSchemaType", dbSchemaTypeQualifiedName, relationalDBSchemaTypeID);
        this.createRelationship("AssetSchemaType", deployedDBSchemaProxy, relationalDbSchemaTypeProxy);
        EntityProxy relationalTableProxy = this.newEntityProxy("RelationalTable", tableQualifiedName, igcTable.getId());
        this.createRelationship("AttributeForSchema", relationalDbSchemaTypeProxy, relationalTableProxy);
        EntityProxy relationalTableTypeProxy = this.newEntityProxy("RelationalTableType", tableTypeQualifiedName, relationalTableTypeID);
        this.createRelationship("SchemaAttributeType", relationalTableProxy, relationalTableTypeProxy);
        for (Item connection : igcDatabase.getDataConnections().getItems()) {
            IGCObject igcConnection = this.igcomrsRepositoryConnector.genericIGCQuery(connection.getId());
            IGCObject igcConnectorType = this.igcomrsRepositoryConnector.genericIGCQuery(igcConnection.getDataConnectors().getId());
            String connectionQualifiedName = this.getConnectionQualifiedName(igcConnection);
            this.createEntity(igcConnection, false, "Connection", connectionQualifiedName);
            String connectorTypeQualifiedName = this.getConnectorQualifiedName(igcConnectorType);
            this.createEntity(igcConnectorType, false, "ConnectorType", connectorTypeQualifiedName);
            EntityProxy connectionProxy = this.newEntityProxy("Connection", connectionQualifiedName, igcConnection.getId());
            EntityProxy connectorTypeProxy = this.newEntityProxy("ConnectorType", connectorTypeQualifiedName, igcConnectorType.getId());
            this.createRelationship("ConnectionConnectorType", connectionProxy, connectorTypeProxy);
            EntityProxy endpointProxy = this.newEntityProxy("Endpoint", endpointQualifiedName, igcEndpoint.getId());
            this.createRelationship("ConnectionEndpoint", endpointProxy, connectionProxy);
        }
        IGCObject databaseColumns = this.igcomrsRepositoryConnector.getDatabaseColumns(id, Constants.DEFAULT_PAGE_SIZE);
        for (Item column : databaseColumns.getDatabaseColumns().getItems()) {
            IGCColumn igcColumn = this.igcomrsRepositoryConnector.getIGCColumn(column.getId());
            String columnQualifiedName = this.getQualifiedName(igcColumn.getContext(), igcColumn.getName());
            this.createEntity(igcColumn, "RelationalColumn", false, columnQualifiedName);
            String columnTypeQualifiedName = this.getTypeQualifiedName(columnQualifiedName);
            this.createEntity(igcColumn, "RelationalColumnType", true, columnTypeQualifiedName);
            String relationalColumnTypeID = "RelationalColumnType." + igcColumn.getId();
            EntityProxy relationalColumnProxy = this.newEntityProxy("RelationalColumn", columnQualifiedName, igcColumn.getId());
            EntityProxy relationalColumnTypeProxy = this.newEntityProxy("RelationalColumnType", columnTypeQualifiedName, relationalColumnTypeID);
            this.createRelationship("SchemaAttributeType", relationalColumnProxy, relationalColumnTypeProxy);
            this.createRelationship("AttributeForSchema", relationalTableTypeProxy, relationalColumnProxy);
            if (igcColumn.getDefinedForeignKey() == null || igcColumn.getDefinedForeignKeyReferences() == null) continue;
            for (Item foreignKey : igcColumn.getDefinedForeignKeyReferences().getItems()) {
                String foreignKeyId = foreignKey.getId();
                IGCColumn foreignKeyRelationalColumn = this.igcomrsRepositoryConnector.getIGCColumn(foreignKeyId);
                String foreignKeyQualifiedName = this.getQualifiedName(foreignKeyRelationalColumn.getContext(), foreignKeyRelationalColumn.getName());
                EntityProxy foreignKeyProxy = this.newEntityProxy("RelationalColumn", foreignKeyQualifiedName, foreignKeyId);
                this.createRelationship("ForeignKey", relationalColumnProxy, foreignKeyProxy);
            }
        }
    }

    private void process(IGCKafkaEvent igcKafkaEvent) {
        try {
            IGCObject igcObject = this.igcomrsRepositoryConnector.genericIGCQuery(igcKafkaEvent.getAssetRID());
            log.info("Process Asset Type: {} id = {} action = {}", new Object[]{igcKafkaEvent.getAssetType(), igcObject.getId(), igcKafkaEvent.getAction()});
            switch (igcKafkaEvent.getAssetType()) {
                case "Database Column": {
                    if (igcKafkaEvent.getAction().equals("ASSIGNED_RELATIONSHIP") || igcKafkaEvent.getAction().equalsIgnoreCase("MODIFY") && igcObject.getAssignedToTerms() != null) {
                        String glossaryTermID = ((Item)igcObject.getAssignedToTerms().getItems().get(0)).getId();
                        IGCObject glossaryTerm = this.igcomrsRepositoryConnector.genericIGCQuery(glossaryTermID);
                        String glossaryTermName = this.getGlossaryTermName(glossaryTerm);
                        String columnQualifiedName = this.getQualifiedName(igcObject.getContext(), igcObject.getName());
                        EntityProxy relationalColumnProxy = this.newEntityProxy("RelationalColumn", columnQualifiedName, igcObject.getId());
                        EntityProxy glossaryTermProxy = this.newEntityProxy("GlossaryTerm", glossaryTermName, glossaryTermID);
                        this.createRelationship("SemanticAssignment", relationalColumnProxy, glossaryTermProxy);
                    }
                    break;
                }
                case "Term": {
                    if (igcKafkaEvent.getAction().equals("CREATE")) {
                        String glossaryCategoryName = this.getGlossaryCategoryName(igcObject);
                        String glossaryTermName = this.getGlossaryTermName(glossaryCategoryName, igcObject.getName());
                        this.createEntity(igcObject, false, "GlossaryTerm", glossaryTermName);
                        this.createEntity(igcObject, false, "GlossaryCategory", glossaryCategoryName);
                        EntityProxy glossaryCategoryProxy = this.newEntityProxy("GlossaryCategory", glossaryCategoryName, ((Context)igcObject.getContext().get(0)).getId());
                        EntityProxy glossaryTermProxy = this.newEntityProxy("GlossaryTerm", glossaryTermName, igcObject.getId());
                        this.createRelationship("TermCategorization", glossaryCategoryProxy, glossaryTermProxy);
                        break;
                    }
                    if (igcKafkaEvent.getAction().equals("MODIFY")) {
                        String glossaryCategoryName = this.getGlossaryCategoryName(igcObject);
                        String glossaryTermName = this.getGlossaryTermName(glossaryCategoryName, igcObject.getName());
                        this.updateGlossaryTerm(igcObject, glossaryTermName);
                    }
                    break;
                }
                case "Category": {
                    if (igcKafkaEvent.getAction().equals("CREATE")) {
                        String glossaryCategoryName = this.getGlossaryCategoryName(igcObject);
                        this.createEntity(igcObject, false, "GlossaryCategory", glossaryCategoryName);
                    }
                    break;
                }
                default: {
                    log.info("Unable to process the type: {}", (Object)igcKafkaEvent.getAction());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.info("Unable to process Asset: {}", (Object)e.getMessage());
        }
    }

    private void createRelationship(String relationshipType, EntityProxy entityProxyOne, EntityProxy entityProxyTwo) {
        Relationship relationship = this.getRelationship(relationshipType);
        if (entityProxyOne == null || entityProxyTwo == null) {
            return;
        }
        String entityProxyOneGUID = entityProxyOne.getGUID();
        String entityProxyOneType = entityProxyOne.getType().getTypeDefName();
        String entityProxyTwoGUID = entityProxyTwo.getGUID();
        String entityProxyTwoType = entityProxyTwo.getType().getTypeDefName();
        if (relationship == null) {
            log.info("Unable to create a new relationship: {} between: {} [{}] and {} [{}].", new Object[]{relationshipType, entityProxyOneGUID, entityProxyOneType, entityProxyTwoGUID, entityProxyTwoType});
            return;
        }
        this.setEndsOfRelationship(relationship, entityProxyOne, entityProxyTwo);
        this.sendNewRelationshipEvent(relationship);
        log.info("[New Relationship Event] Created {} between: {} [{}] and {} [{}].", new Object[]{relationshipType, entityProxyOneType, entityProxyOneType, entityProxyTwoGUID, entityProxyTwoType});
    }

    private void setEndsOfRelationship(Relationship relationship, EntityProxy entityProxyOne, EntityProxy entityProxyTwo) {
        if (entityProxyOne != null && entityProxyTwo != null) {
            relationship.setEntityOneProxy(entityProxyOne);
            relationship.setEntityTwoProxy(entityProxyTwo);
        }
    }

    private void sendNewRelationshipEvent(Relationship relationship) {
        this.repositoryEventProcessor.processNewRelationshipEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, this.originatorOrganizationName, relationship);
    }

    private void updateGlossaryTerm(IGCObject igcObject, String qualifiedName) {
        List classifications = this.createClassifications(igcObject, "Confidentiality");
        InstanceProperties instanceProperties = this.getEntityProperties("GlossaryTerm", igcObject, qualifiedName);
        EntityDetail entity = this.getEntityDetail(igcObject.getId(), "GlossaryTerm", false, igcObject.getCreatedBy(), instanceProperties, classifications);
        if (entity != null) {
            this.sendUpdateEntityEvent(entity);
        }
    }

    private void sendUpdateEntityEvent(EntityDetail entity) {
        this.repositoryEventProcessor.processUpdatedEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, this.originatorOrganizationName, null, entity);
        log.info("[Entity] update the entity with type = {}; guid = {}", (Object)entity.getType().getTypeDefName(), (Object)entity.getGUID());
    }

    private void createEntity(IGCColumn igcColumn, String typeName, boolean avoidDuplicate, String qualifiedName) {
        InstanceProperties instanceProperties = this.getEntityProperties(qualifiedName, igcColumn.getShortDescription(), igcColumn.getLongDescription(), igcColumn.getName());
        List classifications = new ArrayList();
        if (typeName.equals("RelationalColumn")) {
            Map relationalColumnInstanceProperties = this.getRelationalColumnInstanceProperties(igcColumn);
            this.combineInstanceProperties(relationalColumnInstanceProperties, instanceProperties);
            if (igcColumn.getDefinedPrimaryKey() != null) {
                classifications = this.getPrimaryKeyClassification();
            }
        }
        EntityDetail entityDetail = this.getEntityDetail(igcColumn.getId(), typeName, avoidDuplicate, igcColumn.getCreatedBy(), instanceProperties, classifications);
        this.sendNewEntityEvent(typeName, entityDetail);
    }

    private void createEntity(IGCObject igcObject, boolean avoidDuplicate, String typeName, String qualifiedName) {
        List classifications = new ArrayList();
        if ("GlossaryTerm".equals(typeName)) {
            classifications = this.createClassifications(igcObject, "Confidentiality");
        }
        InstanceProperties instanceProperties = this.getEntityProperties(typeName, igcObject, qualifiedName);
        EntityDetail entityDetail = this.getEntityDetail(igcObject.getId(), typeName, avoidDuplicate, igcObject.getCreatedBy(), instanceProperties, classifications);
        this.sendNewEntityEvent(typeName, entityDetail);
    }

    private void sendNewEntityEvent(String typeName, EntityDetail entityDetail) {
        if (entityDetail == null) {
            log.info("Unable to create an entity {}", (Object)typeName);
            return;
        }
        this.repositoryEventProcessor.processNewEntityEvent(this.sourceName, this.metadataCollectionId, this.originatorServerName, this.originatorServerType, this.originatorOrganizationName, entityDetail);
        log.info("[Entity] create new entity with type = {}; guid = {}", (Object)typeName, (Object)entityDetail.getGUID());
    }

    private Relationship getRelationship(String relationshipType) {
        try {
            return this.repositoryHelper.getNewRelationship(this.sourceName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, null, relationshipType, null);
        }
        catch (TypeErrorException e) {
            log.info("Unable to create Relationship [type = {}]: {}", (Object)relationshipType, (Object)e.getErrorMessage());
            return null;
        }
    }

    private EntityProxy newEntityProxy(String typeName, String qualifiedName, String entityGuid) {
        try {
            EntityProxy entityProxy = this.repositoryHelper.getNewEntityProxy(this.sourceName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, null, typeName, null, null);
            entityProxy.setGUID(entityGuid);
            entityProxy.setStatus(InstanceStatus.ACTIVE);
            entityProxy.setUniqueProperties(this.getMandatoryProperty(qualifiedName));
            return entityProxy;
        }
        catch (TypeErrorException e) {
            log.info("Unable to create Entity Proxy [type = {}]: {}", (Object)typeName, (Object)e.getErrorMessage());
            return null;
        }
    }

    private EntityDetail getEntityDetail(String id, String typeName, boolean avoidDuplicate, String username, InstanceProperties instanceProperties, List<Classification> classifications) {
        try {
            EntityDetail entityDetail = this.repositoryHelper.getNewEntity(this.sourceName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, username, typeName, instanceProperties, classifications);
            entityDetail.setStatus(InstanceStatus.ACTIVE);
            if (avoidDuplicate) {
                entityDetail.setGUID(typeName + "." + id);
            } else {
                entityDetail.setGUID(id);
            }
            return entityDetail;
        }
        catch (TypeErrorException e) {
            log.info("Unable to create Entity [type = {}]: {}", (Object)typeName, (Object)e.getErrorMessage());
            return null;
        }
    }

    private List<Classification> getPrimaryKeyClassification() {
        ArrayList<Classification> classificationList = new ArrayList<Classification>(1);
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.sourceName, null, "PrimaryKey", "RelationalColumn", ClassificationOrigin.PROPAGATED, null, null);
            classificationList.add(classification);
        }
        catch (TypeErrorException e) {
            log.info("Unable to create Primary Key Classification: {}", (Object)e.getErrorMessage());
        }
        return classificationList;
    }

    private List<Classification> createClassifications(IGCObject igcObject, String classificationTypeName) {
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        if (igcObject.getRelatedTerms() != null && igcObject.getRelatedTerms().getItems() != null) {
            for (Item item : igcObject.getRelatedTerms().getItems()) {
                Classification classification = this.getClassification(classificationTypeName, item.getName());
                if (classification == null) continue;
                classifications.add(classification);
            }
        }
        return classifications;
    }

    private Classification getClassification(String classificationTypeName, String name) {
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.sourceName, null, classificationTypeName, "GlossaryTerm", ClassificationOrigin.PROPAGATED, null, null);
            InstanceProperties classificationProperties = this.getClassificationProperties(name);
            classification.setProperties(classificationProperties);
            return classification;
        }
        catch (TypeErrorException e) {
            log.info("Unable to create Classification [type = {}]: {}", (Object)classificationTypeName, (Object)e.getErrorMessage());
            return null;
        }
    }

    private InstanceProperties getMandatoryProperty(String qualifiedNameValue) {
        HashMap<String, PrimitivePropertyValue> properties = new HashMap<String, PrimitivePropertyValue>();
        PrimitivePropertyValue qualifiedName = this.getStringPropertyValue(qualifiedNameValue);
        properties.put("qualifiedName", qualifiedName);
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setInstanceProperties(properties);
        return instanceProperties;
    }

    private InstanceProperties getEntityProperties(String typeName, IGCObject igcObject, String qualifiedName) {
        InstanceProperties instanceProperties = this.getEntityProperties(qualifiedName, igcObject.getShortDescription(), igcObject.getLongDescription(), igcObject.getName());
        if ("GlossaryTerm".equals(typeName)) {
            Map glossaryTermInstanceProperties = this.getGlossaryTermInstanceProperties(igcObject);
            return this.combineInstanceProperties(glossaryTermInstanceProperties, instanceProperties);
        }
        return instanceProperties;
    }

    private InstanceProperties combineInstanceProperties(Map<String, InstancePropertyValue> newProperties, InstanceProperties instanceProperties) {
        Map instanceProperties1 = instanceProperties.getInstanceProperties();
        newProperties.putAll(instanceProperties1);
        instanceProperties.setInstanceProperties(newProperties);
        return instanceProperties;
    }

    private Map<String, InstancePropertyValue> getGlossaryTermInstanceProperties(IGCObject igcObject) {
        HashMap<String, InstancePropertyValue> properties = new HashMap<String, InstancePropertyValue>();
        PrimitivePropertyValue example = this.getStringPropertyValue(igcObject.getExample());
        properties.put("examples", (InstancePropertyValue)example);
        PrimitivePropertyValue abbreviation = this.getStringPropertyValue(igcObject.getAbbreviation());
        properties.put("abbreviation", (InstancePropertyValue)abbreviation);
        PrimitivePropertyValue usage = this.getStringPropertyValue(igcObject.getUsage());
        properties.put("usage", (InstancePropertyValue)usage);
        return properties;
    }

    private Map<String, InstancePropertyValue> getRelationalColumnInstanceProperties(IGCColumn igcObject) {
        HashMap<String, InstancePropertyValue> properties = new HashMap<String, InstancePropertyValue>();
        Boolean unique = igcObject.getUnique();
        Boolean nullable = igcObject.getAllowsNullValues();
        Boolean isPK = Boolean.FALSE;
        if (igcObject.getDefinedPrimaryKey() != null && igcObject.getDefinedPrimaryKey().getItems() != null) {
            unique = Boolean.TRUE;
            nullable = Boolean.FALSE;
            isPK = Boolean.TRUE;
        }
        PrimitivePropertyValue isUnique = this.getBooleanPropertyValue(unique);
        properties.put("isUnique", (InstancePropertyValue)isUnique);
        PrimitivePropertyValue isNullable = this.getBooleanPropertyValue(nullable);
        properties.put("isNullable", (InstancePropertyValue)isNullable);
        PrimitivePropertyValue isPrimaryKey = this.getBooleanPropertyValue(isPK);
        properties.put("isPrimaryKey", (InstancePropertyValue)isPrimaryKey);
        return properties;
    }

    private InstanceProperties getEntityProperties(String name, String shortDescription, String longDescription, String defaultName) {
        HashMap<String, PrimitivePropertyValue> properties = new HashMap<String, PrimitivePropertyValue>();
        PrimitivePropertyValue qualifiedName = this.getStringPropertyValue(name);
        properties.put("qualifiedName", qualifiedName);
        PrimitivePropertyValue displayName = this.getStringPropertyValue(defaultName);
        properties.put("displayName", displayName);
        PrimitivePropertyValue summary = this.getStringPropertyValue(shortDescription);
        properties.put("summary", summary);
        PrimitivePropertyValue description = this.getStringPropertyValue(longDescription);
        properties.put("description", description);
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setInstanceProperties(properties);
        return instanceProperties;
    }

    private InstanceProperties getClassificationProperties(String name) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        EnumPropertyValue classificationLevel = this.getEnumPropertyValue(name);
        properties.put("level", classificationLevel);
        PrimitivePropertyValue source = this.getStringPropertyValue(this.sourceName);
        properties.put("source", source);
        EnumPropertyValue status = this.getEnumPropertyValue("Imported");
        properties.put("status", status);
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setInstanceProperties(properties);
        return instanceProperties;
    }

    private PrimitivePropertyValue getStringPropertyValue(String value) {
        PrimitivePropertyValue propertyValue = new PrimitivePropertyValue();
        propertyValue.setPrimitiveValue((Object)value);
        propertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        return propertyValue;
    }

    private PrimitivePropertyValue getBooleanPropertyValue(Boolean value) {
        PrimitivePropertyValue propertyValue = new PrimitivePropertyValue();
        propertyValue.setPrimitiveValue((Object)value);
        propertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
        return propertyValue;
    }

    private EnumPropertyValue getEnumPropertyValue(String value) {
        EnumPropertyValue propertyValue = new EnumPropertyValue();
        propertyValue.setSymbolicName(value);
        return propertyValue;
    }

    private String getGlossaryCategoryName(IGCObject igcObject) {
        Map additionalProperties = igcObject.getAdditionalProperties();
        HashMap parentCategory = (HashMap)additionalProperties.get("parent_category");
        return (String)parentCategory.get("_name");
    }

    private String getGlossaryTermName(String glossaryCategoryName, String name) {
        return glossaryCategoryName + "." + name;
    }

    private String getGlossaryTermName(IGCObject igcObject) {
        return this.getGlossaryCategoryName(igcObject) + "." + igcObject.getName();
    }

    private String getConnectionQualifiedName(IGCObject igcObject) {
        Map additionalProperties = igcObject.getAdditionalProperties();
        String property = (String)additionalProperties.get("connection_string");
        return property + "." + "Connection";
    }

    private String getConnectorQualifiedName(IGCObject igcConnectorType) {
        return igcConnectorType.getName();
    }

    private String getQualifiedName(List<Context> contexts, String defaultName) {
        if (contexts == null || contexts.isEmpty()) {
            return defaultName;
        }
        StringBuilder contextName = new StringBuilder();
        for (Context context : contexts) {
            if (context.getType().equals("host")) {
                contextName.append(context.getName() + "." + "Connection" + ".");
                continue;
            }
            contextName.append(context.getName() + ".");
        }
        return contextName.toString() + defaultName;
    }

    private String getTypeQualifiedName(String typeName) {
        return typeName + "_type";
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ Consumer access$200(IGCOMRSRepositoryEventMapper x0) {
        return x0.createConsumer();
    }

    static /* synthetic */ IGCKafkaEvent access$300(IGCOMRSRepositoryEventMapper x0, ObjectMapper x1, ConsumerRecord x2) throws IOException {
        return x0.getIGCKafkaEvent(x1, x2);
    }

    static /* synthetic */ void access$400(IGCOMRSRepositoryEventMapper x0, IGCKafkaEvent x1) {
        x0.processEvent(x1);
    }
}

