/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.eventmapper.model.Constants;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.IGCOMRSMetadataCollection;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.model.IGCColumn;
import org.odpi.openmetadata.virtualdataconnector.igc.connectors.repositoryconnector.model.IGCObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class IGCOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    public IGCOMRSRepositoryConnector() {
        IGCOMRSRepositoryConnector.disableSslVerification();
    }

    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
        this.metadataCollection = new IGCOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId);
    }

    public void disconnect() {
        this.metadataCollection = new IGCOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, this.metadataCollectionId);
    }

    public OMRSMetadataCollection getMetadataCollection() {
        if (this.metadataCollection == null) {
            throw new NullPointerException("Local metadata collection id is not set up");
        }
        return this.metadataCollection;
    }

    public IGCObject genericIGCQuery(String igcRID) {
        String url = this.connectionBean.getAdditionalProperties().get("igcApiGet") + igcRID;
        return this.getIgcObject(url);
    }

    public IGCObject getDatabaseColumns(String igcRID, Integer pageSize) {
        if (pageSize == null) {
            pageSize = Constants.DEFAULT_PAGE_SIZE;
        }
        String url = this.connectionBean.getAdditionalProperties().get("igcApiGet") + igcRID + "/database_columns?begin=0&pageSize=" + pageSize;
        IGCObject igcObjectMapper = this.getIgcObject(url);
        Integer numTotal = igcObjectMapper.getDatabaseColumns().getPaging().getNumTotal();
        if (pageSize < numTotal) {
            url = this.connectionBean.getAdditionalProperties().get("igcApiGet") + igcRID + "/database_columns?begin=0&pageSize=" + numTotal;
            return this.getIgcObject(url);
        }
        return igcObjectMapper;
    }

    private IGCObject getIgcObject(String url) {
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        String resultBody = this.getHttpResult(url, entity);
        return (IGCObject)this.getIGCObjectMapper(resultBody, IGCObject.class);
    }

    public IGCColumn getIGCColumn(String igcRID) {
        String url = this.connectionBean.getAdditionalProperties().get("igcApiGet") + igcRID;
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHttpHeaders());
        String resultBody = this.getHttpResult(url, entity);
        return (IGCColumn)this.getIGCObjectMapper(resultBody, IGCColumn.class);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-cache");
        headers.set("Authorization", "Basic " + this.connectionBean.getAdditionalProperties().get("authorization"));
        headers.set("Proxy-Authorization", "Basic " + this.connectionBean.getAdditionalProperties().get("authorization"));
        headers.set("Content-Type", "application/json");
        return headers;
    }

    private String getHttpResult(String url, HttpEntity<String> entity) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
        return (String)result.getBody();
    }

    private Object getIGCObjectMapper(String resultBody, Class objectClass) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(resultBody, objectClass);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

