/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCVersionEnum;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Paging;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.update.IGCUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Base64Utils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class IGCRestClient {
    private static final Logger log = LoggerFactory.getLogger(IGCRestClient.class);
    private String authorization;
    private String baseURL;
    private Boolean workflowEnabled = false;
    private List<String> cookies = null;
    private boolean successfullyInitialised = false;
    private IGCVersionEnum igcVersion;
    private HashMap<String, Class> registeredPojosByType;
    private int defaultPageSize = 100;
    private ObjectMapper mapper;
    public static final String EP_TYPES = "/ibm/iis/igc-rest/v1/types";
    public static final String EP_ASSET = "/ibm/iis/igc-rest/v1/assets";
    public static final String EP_SEARCH = "/ibm/iis/igc-rest/v1/search";
    public static final String EP_LOGOUT = "/ibm/iis/igc-rest/v1/logout";
    public static final String EP_BUNDLES = "/ibm/iis/igc-rest/v1/bundles";
    public static final String EP_BUNDLE_ASSETS = "/ibm/iis/igc-rest/v1/bundles/assets";

    public IGCRestClient() {
        this(null, null);
    }

    public IGCRestClient(String baseURL, String authorization) {
        this.baseURL = baseURL;
        this.authorization = authorization;
        this.mapper = new ObjectMapper();
        this.mapper.enableDefaultTyping();
        this.registeredPojosByType = new HashMap();
        log.debug("Constructing IGCRestClient...");
        if (this.baseURL != null && this.authorization != null) {
            IGCSearch igcSearch = new IGCSearch("category");
            igcSearch.addType("term");
            igcSearch.addType("information_governance_policy");
            igcSearch.addType("information_governance_rule");
            igcSearch.setPageSize(1);
            igcSearch.setDevGlossary(true);
            JsonNode response = this.searchJson(igcSearch);
            if (response != null) {
                log.debug("Checking for workflow and registering version...");
                this.workflowEnabled = response.path("paging").path("numTotal").asInt(0) > 0;
                this.registerPOJO(Paging.class);
                this.igcVersion = IGCVersionEnum.values()[0];
                ArrayNode igcTypes = this.getTypes();
                for (JsonNode node : igcTypes) {
                    String assetType = node.path("_id").asText();
                    for (IGCVersionEnum aVersion : IGCVersionEnum.values()) {
                        if (!aVersion.isHigherThan(this.igcVersion) || !assetType.equals(aVersion.getTypeNameFirstAvailableInThisVersion())) continue;
                        this.igcVersion = aVersion;
                    }
                }
                log.info("Detected IGC version: {}", (Object)this.igcVersion.getVersionString());
                this.successfullyInitialised = true;
            } else {
                log.error("Unable to construct IGCRestClient.");
            }
        }
    }

    public boolean isSuccessfullyInitialised() {
        return this.successfullyInitialised;
    }

    private HttpHeaders getHttpHeaders(boolean forceLogin) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache");
        headers.add("Content-Type", "application/json");
        if (this.cookies != null && !forceLogin) {
            headers.addAll("Cookie", this.cookies);
        } else {
            String auth = "Basic " + this.authorization;
            headers.add("Authorization", auth);
        }
        return headers;
    }

    private ResponseEntity<String> openNewSessionWithRequest(String endpoint, HttpMethod method, MediaType contentType, String payload, boolean alreadyTriedNewSession) {
        if (alreadyTriedNewSession) {
            log.error("Opening a new session already attempted without success -- giving up on {} to {} with {}", new Object[]{method, endpoint, payload});
            return null;
        }
        this.cookies = null;
        return this.makeRequest(endpoint, method, contentType, payload, true);
    }

    private ResponseEntity<String> openNewSessionWithUpload(String endpoint, HttpMethod method, AbstractResource file, boolean alreadyTriedNewSession) {
        if (alreadyTriedNewSession) {
            log.error("Opening a new session already attempted without success -- giving up on {} to {} with {}", new Object[]{method, endpoint, file});
            return null;
        }
        log.info("Session appears to have timed out -- starting a new session and re-trying the upload.");
        this.cookies = null;
        return this.uploadFile(endpoint, method, file, true);
    }

    private void setCookiesFromResponse(ResponseEntity<String> response) {
        if (response.getStatusCode() == HttpStatus.OK) {
            HttpHeaders headers = response.getHeaders();
            if (headers.get((Object)"Set-Cookie") != null) {
                this.cookies = headers.get((Object)"Set-Cookie");
            }
        } else {
            log.error("Unable to make request or unexpected status: {}", (Object)response.getStatusCode());
        }
    }

    protected Reference readJSONIntoPOJO(JsonNode jsonNode) {
        return this.readJSONIntoPOJO(jsonNode.toString());
    }

    public Reference readJSONIntoPOJO(String json) {
        Reference reference = null;
        try {
            reference = (Reference)this.mapper.readValue(json, Reference.class);
        }
        catch (IOException e) {
            log.error("Unable to translate JSON into POJO: {}", (Object)json, (Object)e);
        }
        return reference;
    }

    public ReferenceList readJSONIntoReferenceList(String json) {
        ReferenceList referenceList = null;
        try {
            referenceList = (ReferenceList)this.mapper.readValue(json, ReferenceList.class);
        }
        catch (IOException e) {
            log.error("Unable to translate JSON into ReferenceList: {}", (Object)json, (Object)e);
        }
        return referenceList;
    }

    public String getValueAsJSON(Reference asset) {
        String payload = null;
        try {
            payload = this.mapper.writeValueAsString((Object)asset);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to translate asset into JSON: {}", (Object)asset, (Object)e);
        }
        return payload;
    }

    public IGCVersionEnum getIgcVersion() {
        return this.igcVersion;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int pageSize) {
        this.defaultPageSize = pageSize;
    }

    public static String encodeBasicAuth(String username, String password) {
        return Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    private ResponseEntity<String> uploadFile(String endpoint, HttpMethod method, AbstractResource file, boolean forceLogin) {
        HttpHeaders headers = this.getHttpHeaders(forceLogin);
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        ResponseEntity<String> response = null;
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)file);
        HttpEntity toSend = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            response = new RestTemplate().exchange(endpoint, method, toSend, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            log.warn("Request failed -- session may have expired, retrying...", (Throwable)e);
            response = this.openNewSessionWithUpload(endpoint, method, file, forceLogin);
        }
        catch (RestClientException e) {
            log.error("Request failed -- check IGC environment connectivity and authentication details.", (Throwable)e);
        }
        return response;
    }

    public boolean uploadFile(String endpoint, HttpMethod method, AbstractResource file) {
        ResponseEntity<String> response = this.uploadFile(endpoint, method, file, false);
        return response == null ? false : response.getStatusCode() == HttpStatus.OK;
    }

    private ResponseEntity<String> makeRequest(String endpoint, HttpMethod method, MediaType contentType, String payload, boolean forceLogin) {
        HttpEntity toSend;
        HttpHeaders headers = this.getHttpHeaders(forceLogin);
        if (payload != null) {
            headers.setContentType(contentType);
            toSend = new HttpEntity((Object)payload, (MultiValueMap)headers);
        } else {
            toSend = new HttpEntity((MultiValueMap)headers);
        }
        ResponseEntity response = null;
        try {
            log.debug("{}ing to {} with: {}", new Object[]{method, endpoint, payload});
            response = new RestTemplate().exchange(endpoint, method, toSend, String.class, new Object[0]);
            this.setCookiesFromResponse((ResponseEntity<String>)response);
        }
        catch (HttpClientErrorException e) {
            log.warn("Request failed -- session may have expired, retrying...", (Throwable)e);
            response = this.openNewSessionWithRequest(endpoint, method, contentType, payload, forceLogin);
        }
        catch (RestClientException e) {
            log.error("Request failed -- check IGC environment connectivity and authentication details.", (Throwable)e);
        }
        return response;
    }

    public JsonNode makeRequest(String endpoint, HttpMethod method, MediaType contentType, String payload) {
        ResponseEntity<String> response = this.makeRequest(endpoint, method, contentType, payload, false);
        JsonNode jsonNode = null;
        if (response == null) {
            log.error("Unable to complete request -- check IGC environment connectivity and authentication details.");
            throw new NullPointerException("Unable to complete request -- check IGC environment connectivity and authentication details.");
        }
        if (response.hasBody()) {
            try {
                jsonNode = this.mapper.readTree((String)response.getBody());
            }
            catch (IOException e) {
                log.error("Unable to read JSON response body when {} to {} with {}", new Object[]{method, endpoint, payload, e});
            }
        }
        return jsonNode;
    }

    public ArrayNode getTypes() {
        return (ArrayNode)this.makeRequest(this.baseURL + EP_TYPES, HttpMethod.GET, null, null);
    }

    public JsonNode getJsonAssetById(String rid) {
        return this.makeRequest(this.baseURL + EP_ASSET + "/" + rid, HttpMethod.GET, null, null);
    }

    public Reference getAssetById(String rid) {
        return this.readJSONIntoPOJO(this.getJsonAssetById(rid));
    }

    public Reference getAssetRefById(String rid) {
        IGCSearchCondition condition = new IGCSearchCondition("_id", "=", rid);
        IGCSearchConditionSet conditionSet = new IGCSearchConditionSet(condition);
        IGCSearch igcSearch = new IGCSearch("main_object", conditionSet);
        igcSearch.addType("classification");
        igcSearch.addType("label");
        igcSearch.addType("user");
        igcSearch.addType("group");
        ReferenceList results = this.search(igcSearch);
        Reference reference = null;
        if (results.getPaging().getNumTotal() > 0) {
            if (results.getPaging().getNumTotal() > 1) {
                log.warn("Found multiple assets for RID {}, taking only the first.", (Object)rid);
            }
            reference = results.getItems().get(0);
        }
        return reference;
    }

    public JsonNode searchJson(JsonNode query) {
        return this.makeRequest(this.baseURL + EP_SEARCH, HttpMethod.POST, MediaType.APPLICATION_JSON, query.toString());
    }

    public JsonNode searchJson(IGCSearch igcSearch) {
        return this.searchJson(igcSearch.getQuery());
    }

    public ReferenceList search(IGCSearch igcSearch) {
        ReferenceList referenceList = null;
        JsonNode results = this.searchJson(igcSearch);
        try {
            referenceList = (ReferenceList)this.mapper.readValue(results.toString(), ReferenceList.class);
        }
        catch (IOException e) {
            log.error("Unable to translate JSON results: {}", (Object)results, (Object)e);
        }
        return referenceList;
    }

    public JsonNode updateJson(String rid, JsonNode value) {
        return this.makeRequest(this.baseURL + EP_ASSET + "/" + rid, HttpMethod.PUT, MediaType.APPLICATION_JSON, value.toString());
    }

    public boolean update(IGCUpdate igcUpdate) {
        JsonNode result = this.updateJson(igcUpdate.getRidToUpdate(), igcUpdate.getUpdate());
        return result != null;
    }

    public boolean upsertOpenIgcBundle(String name, AbstractResource file) {
        List<String> existingBundles = this.getOpenIgcBundles();
        boolean success = existingBundles.contains(name) ? this.uploadFile(this.baseURL + EP_BUNDLES, HttpMethod.PUT, file) : this.uploadFile(this.baseURL + EP_BUNDLES, HttpMethod.POST, file);
        return success;
    }

    public File createOpenIgcBundleFile(File directory) {
        File bundle = null;
        try {
            bundle = File.createTempFile("openigc", "zip");
        }
        catch (IOException e) {
            log.error("Unable to create temporary file needed for OpenIGC bundle from directory: {}", (Object)directory, (Object)e);
        }
        if (bundle != null) {
            try (FileOutputStream bundleOut = new FileOutputStream(bundle);
                 ZipOutputStream zipOutput = new ZipOutputStream(bundleOut);){
                if (!directory.isDirectory()) {
                    log.error("Provided bundle location is not a directory: {}", (Object)directory);
                } else {
                    this.recursivelyZipFiles(directory, "", zipOutput);
                }
            }
            catch (IOException e) {
                log.error("Unable to create temporary file needed for OpenIGC bundle from directory: {}", (Object)directory, (Object)e);
            }
        }
        return bundle;
    }

    private void recursivelyZipFiles(File file, String name, ZipOutputStream zipOutput) {
        if (file.isDirectory()) {
            String directoryName = name;
            if (!directoryName.equals("")) {
                directoryName = directoryName.endsWith(File.separator) ? directoryName : directoryName + File.separator;
            }
            try {
                File[] files;
                if (!directoryName.equals("")) {
                    zipOutput.putNextEntry(new ZipEntry(directoryName));
                }
                for (File subFile : files = file.listFiles()) {
                    this.recursivelyZipFiles(subFile, directoryName + subFile.getName(), zipOutput);
                }
            }
            catch (IOException e) {
                log.error("Unable to create directory entry in zip file for {}.", (Object)directoryName, (Object)e);
            }
        } else {
            try (FileInputStream fileInput = new FileInputStream(file);){
                int length;
                zipOutput.putNextEntry(new ZipEntry(name));
                byte[] buffer = new byte[1024];
                while ((length = fileInput.read(buffer)) >= 0) {
                    zipOutput.write(buffer, 0, length);
                }
            }
            catch (FileNotFoundException e) {
                log.error("Unable to find file: {}", (Object)file, (Object)e);
            }
            catch (IOException e) {
                log.error("Unable to read/write file: {}", (Object)file, (Object)e);
            }
        }
    }

    public List<String> getOpenIgcBundles() {
        JsonNode bundles = this.makeRequest(this.baseURL + EP_BUNDLES, HttpMethod.GET, null, null);
        ArrayList<String> alBundles = new ArrayList<String>();
        try {
            String[] aBundles;
            for (String bundleName : aBundles = (String[])this.mapper.readValue(bundles.toString(), String[].class)) {
                alBundles.add(bundleName);
            }
        }
        catch (IOException e) {
            log.error("Unable to parse bundle response: {}", (Object)bundles.toString(), (Object)e);
        }
        return alBundles;
    }

    public JsonNode upsertOpenIgcAsset(String assetXML) {
        return this.makeRequest(this.baseURL + EP_BUNDLE_ASSETS, HttpMethod.POST, MediaType.APPLICATION_XML, assetXML);
    }

    public boolean deleteOpenIgcAsset(String assetXML) {
        return this.makeRequest(this.baseURL + EP_BUNDLE_ASSETS, HttpMethod.DELETE, MediaType.APPLICATION_XML, assetXML) == null;
    }

    public JsonNode getNextPage(JsonNode paging) {
        JsonNode nextPage = null;
        try {
            String sNextURL;
            nextPage = this.mapper.readTree("{\"items\": []}");
            JsonNode nextURL = paging.path("next");
            if (!nextURL.isMissingNode() && (sNextURL = nextURL.asText()) != null && !sNextURL.equals("null")) {
                if (this.workflowEnabled.booleanValue() && !sNextURL.contains("workflowMode=draft")) {
                    sNextURL = sNextURL + "&workflowMode=draft";
                }
                nextPage = this.makeRequest(sNextURL, HttpMethod.GET, null, null);
                if (sNextURL.contains(EP_ASSET)) {
                    String remainder = sNextURL.substring((this.baseURL + EP_ASSET).length() + 2);
                    String attributeName = remainder.substring(remainder.indexOf(47) + 1, remainder.indexOf(63));
                    nextPage = nextPage.path(attributeName);
                }
            }
        }
        catch (IOException e) {
            log.error("Unable to parse next page from JSON: {}", (Object)paging, (Object)e);
        }
        return nextPage;
    }

    public ArrayNode getAllPages(ArrayNode items, JsonNode paging) {
        ArrayNode allPages = items;
        JsonNode results = this.getNextPage(paging);
        ArrayNode resultsItems = (ArrayNode)results.path("items");
        if (resultsItems.size() > 0) {
            allPages = this.getAllPages(items.addAll(resultsItems), results.path("paging"));
        }
        return allPages;
    }

    public ReferenceList getNextPage(Paging paging) {
        JsonNode nextPage = this.getNextPage((JsonNode)this.mapper.convertValue((Object)paging, JsonNode.class));
        ReferenceList rlNextPage = null;
        try {
            rlNextPage = (ReferenceList)this.mapper.readValue(nextPage.toString(), ReferenceList.class);
        }
        catch (IOException e) {
            log.error("Unable to parse next page from JSON: {}", (Object)paging, (Object)e);
        }
        return rlNextPage;
    }

    public List<Reference> getAllPages(List<Reference> items, Paging paging) {
        List<Reference> allPages = items;
        ReferenceList results = this.getNextPage(paging);
        ArrayList<Reference> resultsItems = results.getItems();
        if (!resultsItems.isEmpty()) {
            resultsItems.addAll(allPages);
            allPages = this.getAllPages(resultsItems, results.getPaging());
        }
        return allPages;
    }

    public void disconnect() {
        this.makeRequest(this.baseURL + EP_LOGOUT, HttpMethod.GET, null, null);
    }

    public void registerPOJO(Class clazz) {
        try {
            Method getTypeId = clazz.getMethod("getIgcTypeId", new Class[0]);
            String typeId = (String)getTypeId.invoke(null, new Object[0]);
            this.mapper.registerSubtypes(new NamedType[]{new NamedType(clazz, typeId)});
            this.registeredPojosByType.put(typeId, clazz);
            log.debug("Registered IGC type {} to be handled by POJO: {}", (Object)typeId, (Object)clazz.getCanonicalName());
        }
        catch (NoSuchMethodException e) {
            log.error("Unable to find 'getIgcTypeId' method on class: {}", (Object)clazz.getCanonicalName(), (Object)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Unable to access or invoke 'getIgcTypeId' method on class: {}", (Object)clazz.getCanonicalName(), (Object)e);
        }
    }

    public Class getPOJOForType(String typeName) {
        return this.registeredPojosByType.get(typeName);
    }

    public Boolean isWorkflowEnabled() {
        return this.workflowEnabled;
    }
}

