/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary;

import java.io.Serializable;

public enum IGCVersionEnum implements Serializable
{
    V11501(11501000, "v11501", "xsd_unique_key"),
    V11501RU5(11501500, "v11501ru5", "development_log"),
    V11502(11502000, "v11502", "term_assignment"),
    V11502SP3(11502300, "v11502sp3", "Rule_Execution_Result"),
    V11502SP5(11502500, "v11502sp5", "hbase_namespace"),
    V11700(11700000, "v11700", "binary_infoset_operation"),
    V11701(11701000, "v11701", "analytics_project"),
    V11701SP1(11701100, "v11701sp1", "automation_rule"),
    V11702(11702000, "v11702", "lineage_container");

    private static final long serialVersionUID = 1L;
    private int versionCode;
    private String versionName;
    private String typeNameFirstAvailable;

    private IGCVersionEnum(int versionCode, String versionName, String typeNameFirstAvailable) {
        this.versionCode = versionCode;
        this.versionName = versionName;
        this.typeNameFirstAvailable = typeNameFirstAvailable;
    }

    private int getOrdinal() {
        return this.versionCode;
    }

    public String getVersionString() {
        return this.versionName;
    }

    public String getTypeNameFirstAvailableInThisVersion() {
        return this.typeNameFirstAvailable;
    }

    public boolean isLowerThan(IGCVersionEnum version) {
        return this.getOrdinal() < version.getOrdinal();
    }

    public boolean isEqualTo(IGCVersionEnum version) {
        return this.getOrdinal() == version.getOrdinal();
    }

    public boolean isHigherThan(IGCVersionEnum version) {
        return this.getOrdinal() > version.getOrdinal();
    }

    public String toString() {
        return "IGCVersion{versionCode=" + this.versionCode + ", versionName='" + this.versionName + '\'' + '}';
    }
}

