/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestConstants;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCVersionEnum;
import org.odpi.openmetadata.http.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.util.HtmlUtils;

public class IGCRestModelGenerator {
    private static final Logger log = LoggerFactory.getLogger(IGCRestModelGenerator.class);
    private Set<String> IGNORE_TYPES;
    private Set<String> IGNORE_PROPERTIES;
    private Set<String> RESERVED_WORDS;
    private Set<String> QUALIFY_PROPERTIES;
    private Map<String, String> ALIAS_OBJECTS;
    private Map<String, String> BASIC_TYPE_TO_JAVA_TYPE;
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private IGCRestClient igcRestClient;

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Inadequate parameters provided.");
            IGCRestModelGenerator.printUsage();
            System.exit(1);
        }
        HttpHelper.noStrictSSL();
        IGCRestModelGenerator generator = new IGCRestModelGenerator(args[0], args[1], args[2], args[3]);
        generator.generateForAllIgcTypesInEnvironment(args[4]);
    }

    private static void printUsage() {
        System.out.println("Usage: ");
        System.out.println("  IGCRestModelGenerator hostname port username password directory");
    }

    public IGCRestModelGenerator(String hostname, String port, String username, String password) {
        this.IGNORE_TYPES = new HashSet<String>();
        this.IGNORE_TYPES.add("main_object");
        this.IGNORE_TYPES.add("information_asset");
        this.IGNORE_PROPERTIES = new HashSet<String>();
        this.IGNORE_PROPERTIES.add("_name");
        this.IGNORE_PROPERTIES.add("_type");
        this.IGNORE_PROPERTIES.add("_url");
        this.IGNORE_PROPERTIES.add("_id");
        this.IGNORE_PROPERTIES.add("_context");
        this.IGNORE_PROPERTIES.add("notes");
        this.RESERVED_WORDS = new HashSet<String>();
        this.RESERVED_WORDS.add("package");
        this.RESERVED_WORDS.add("final");
        this.RESERVED_WORDS.add("abstract");
        this.RESERVED_WORDS.add("default");
        this.QUALIFY_PROPERTIES = new HashSet<String>();
        this.QUALIFY_PROPERTIES.add("name");
        this.QUALIFY_PROPERTIES.add("type");
        this.QUALIFY_PROPERTIES.add("url");
        this.QUALIFY_PROPERTIES.add("id");
        this.QUALIFY_PROPERTIES.add("context");
        this.ALIAS_OBJECTS = new HashMap<String, String>();
        this.ALIAS_OBJECTS.put("host_(engine)", "host");
        this.BASIC_TYPE_TO_JAVA_TYPE = new HashMap<String, String>();
        this.BASIC_TYPE_TO_JAVA_TYPE.put("string", "String");
        this.BASIC_TYPE_TO_JAVA_TYPE.put("boolean", "Boolean");
        this.BASIC_TYPE_TO_JAVA_TYPE.put("datetime", "Date");
        this.BASIC_TYPE_TO_JAVA_TYPE.put("number", "Number");
        this.BASIC_TYPE_TO_JAVA_TYPE.put("enum", "String");
        this.igcRestClient = new IGCRestClient("https://" + hostname + ":" + port, IGCRestClient.encodeBasicAuth(username, password));
    }

    public void generateForAllIgcTypesInEnvironment(String directory) {
        File dir = new File(directory);
        if (!dir.exists()) {
            System.out.println("Creating directory: " + directory);
            dir.mkdirs();
        }
        System.out.println("Generating POJOs for IGC version: " + this.igcRestClient.getIgcVersion());
        ArrayNode types = this.igcRestClient.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            String type = types.get(i).path("_id").asText();
            JsonNode properties = this.igcRestClient.makeRequest(this.igcRestClient.getBaseURL() + "/ibm/iis/igc-rest/v1/types/" + type + "?showViewProperties=true&showCreateProperties=true", HttpMethod.GET, MediaType.APPLICATION_JSON, null);
            this.createPOJOForType(properties, directory, this.igcRestClient.getIgcVersion());
        }
        this.igcRestClient.disconnect();
    }

    private StringBuilder getPropertyHeading(String propertyId, String propertyDisplayName, JsonNode typeObj, String javaType) {
        ArrayNode validValues;
        StringBuilder sb = new StringBuilder();
        sb.append("    /**");
        sb.append(System.lineSeparator());
        sb.append("     * The {@code " + propertyId + "} property, displayed as '{@literal " + propertyDisplayName + "}' in the IGC UI.");
        sb.append(System.lineSeparator());
        String typeName = typeObj.path("name").asText();
        if (typeObj.hasNonNull("url")) {
            sb.append("     * <br><br>");
            sb.append(System.lineSeparator());
            if (javaType.equals("ReferenceList")) {
                sb.append("     * Will be a {@link ReferenceList} of {@link " + IGCRestConstants.getClassNameForAssetType(typeName) + "} objects.");
                sb.append(System.lineSeparator());
            } else if (javaType.equals("Reference")) {
                sb.append("     * Will be a single {@link Reference} to a {@link " + IGCRestConstants.getClassNameForAssetType(typeName) + "} object.");
                sb.append(System.lineSeparator());
            }
        } else if (typeName.equals("enum") && (validValues = (ArrayNode)typeObj.path("validValues")) != null && validValues.size() > 0) {
            sb.append("     * <br><br>");
            sb.append(System.lineSeparator());
            sb.append("     * Can be one of the following values:");
            sb.append(System.lineSeparator());
            sb.append("     * <ul>");
            sb.append(System.lineSeparator());
            for (int i = 0; i < validValues.size(); ++i) {
                JsonNode validValue = validValues.get(i);
                sb.append("     *     <li>" + HtmlUtils.htmlEscape((String)validValue.path("id").asText()) + " (displayed in the UI as '" + HtmlUtils.htmlEscape((String)validValue.path("displayName").asText()) + "')</li>");
                sb.append(System.lineSeparator());
            }
            sb.append("     * </ul>");
            sb.append(System.lineSeparator());
        }
        sb.append("     */");
        sb.append(System.lineSeparator());
        return sb;
    }

    private PropertyDetail getPropertyDetailForPOJO(String name, JsonNode typeObj, int maxNum, String displayName) {
        String type;
        PropertyDetail detail = new PropertyDetail();
        String nominalType = type = typeObj.path("name").asText();
        if (typeObj.hasNonNull("url")) {
            nominalType = "Reference";
        } else if (this.BASIC_TYPE_TO_JAVA_TYPE.containsKey(type)) {
            nominalType = this.BASIC_TYPE_TO_JAVA_TYPE.get(type);
        } else if (!this.BASIC_TYPE_TO_JAVA_TYPE.containsKey(type)) {
            log.warn("Found unknown type: " + type + " (" + typeObj.toString() + ")");
            return null;
        }
        String javaType = "";
        javaType = maxNum != 1 ? (nominalType.equals("Reference") ? "ReferenceList" : (nominalType.equals("Boolean") ? nominalType : "ArrayList<" + nominalType + ">")) : nominalType;
        detail.setJavaType(javaType);
        String propName = name;
        StringBuilder declMember = this.getPropertyHeading(name, displayName, typeObj, javaType);
        Matcher m = IGCRestConstants.INVALID_NAMING_CHARS.matcher(propName);
        if (m.find()) {
            propName = m.replaceAll("_");
            declMember.append("    @JsonProperty(\"" + name + "\") protected " + javaType + " " + propName + ";");
            declMember.append(System.lineSeparator());
        } else if (this.RESERVED_WORDS.contains(propName)) {
            propName = "__" + propName;
            declMember.append("    @JsonProperty(\"" + name + "\") protected " + javaType + " " + propName + ";");
            declMember.append(System.lineSeparator());
        } else {
            declMember.append("    protected " + javaType + " " + propName + ";");
            declMember.append(System.lineSeparator());
        }
        detail.setMember(declMember.toString());
        String ccName = IGCRestConstants.getCamelCase(propName);
        if (this.QUALIFY_PROPERTIES.contains(propName)) {
            ccName = IGCRestConstants.getCamelCase("the_" + propName);
        }
        StringBuilder getSetter = new StringBuilder();
        String getSetPrepend = "    /** @see #" + propName + " */ @JsonProperty(\"" + name + "\") ";
        getSetter.append(getSetPrepend);
        getSetter.append(" public " + javaType + " get" + ccName + "() { return this." + propName + "; }");
        getSetter.append(System.lineSeparator());
        getSetter.append(getSetPrepend);
        getSetter.append(" public void set" + ccName + "(" + javaType + " " + propName + ") { this." + propName + " = " + propName + "; }");
        getSetter.append(System.lineSeparator());
        getSetter.append(System.lineSeparator());
        detail.setGetSet(getSetter.toString());
        return detail;
    }

    private PropertyList getPropertiesForPOJO(BufferedWriter fs, ArrayNode properties) throws IOException {
        PropertyList propertiesList = new PropertyList();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyDetail details;
            JsonNode property = properties.get(i);
            String propName = property.path("name").asText();
            if (propName == null || propName.equals("null") || this.IGNORE_PROPERTIES.contains(propName)) continue;
            JsonNode typeObj = property.path("type");
            int maxNum = -1;
            if (property.hasNonNull("maxCardinality")) {
                maxNum = property.path("maxCardinality").asInt();
            }
            if ((details = this.getPropertyDetailForPOJO(propName, typeObj, maxNum, property.path("displayName").asText())) == null) continue;
            propertiesList.addMember(details.getMember());
            propertiesList.addGetterSetter(details.getGetSet());
            propertiesList.addToAllProperties(propName);
            if (!details.getJavaType().contains("Reference")) {
                propertiesList.addNonRelationshipProperty(propName);
                if (!details.getJavaType().contains("String") || "enum".equals(typeObj.path("name").asText())) continue;
                propertiesList.addStringProperty(propName);
                continue;
            }
            if (!details.getJavaType().contains("ReferenceList")) continue;
            propertiesList.addRelationshipProperty(propName);
        }
        List<String> members = propertiesList.getMembers();
        for (int j = 0; j < members.size(); ++j) {
            fs.append(members.get(j));
            fs.append(System.lineSeparator());
        }
        List<String> getterSetters = propertiesList.getGettersSetters();
        fs.append(System.lineSeparator());
        for (int k = 0; k < getterSetters.size(); ++k) {
            fs.append(getterSetters.get(k));
        }
        return propertiesList;
    }

    private void createPOJOForType(JsonNode jsonProps, String directory, IGCVersionEnum version) {
        String packageName = "org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.generated." + version.getVersionString();
        String id = jsonProps.path("_id").asText();
        String name = jsonProps.path("_name").asText();
        String url = jsonProps.path("_url").asText();
        if (!this.IGNORE_TYPES.contains(id)) {
            String className = IGCRestConstants.getClassNameForAssetType(id);
            String filename = directory + File.separator + className + ".java";
            try (BufferedWriter fs = new BufferedWriter(new FileWriter(filename));){
                fs.append("/* SPDX-License-Identifier: Apache-2.0 */");
                fs.append(System.lineSeparator());
                fs.append("/* Copyright Contributors to the ODPi Egeria project. */");
                fs.append(System.lineSeparator());
                fs.append("package " + packageName + ";");
                fs.append(System.lineSeparator());
                fs.append(System.lineSeparator());
                fs.append("import com.fasterxml.jackson.annotation.JsonIgnoreProperties;");
                fs.append(System.lineSeparator());
                if (!this.ALIAS_OBJECTS.containsKey(id)) {
                    fs.append("import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.*;");
                    fs.append(System.lineSeparator());
                    fs.append("import com.fasterxml.jackson.annotation.JsonProperty;");
                    fs.append(System.lineSeparator());
                    fs.append("import java.util.Arrays;");
                    fs.append(System.lineSeparator());
                    fs.append("import java.util.Date;");
                    fs.append(System.lineSeparator());
                    fs.append("import java.util.List;");
                    fs.append(System.lineSeparator());
                    fs.append("import java.util.ArrayList;");
                    fs.append(System.lineSeparator());
                }
                fs.append(System.lineSeparator());
                fs.append(this.getClassHeading(name, id));
                fs.append("@JsonIgnoreProperties(ignoreUnknown=true)");
                fs.append(System.lineSeparator());
                if (this.ALIAS_OBJECTS.containsKey(id)) {
                    fs.append("public class " + className + " extends " + IGCRestConstants.getClassNameForAssetType(this.ALIAS_OBJECTS.get(id)) + " {");
                    fs.append(System.lineSeparator() + System.lineSeparator());
                } else {
                    fs.append("public class " + className + " extends Reference {");
                    fs.append(System.lineSeparator() + System.lineSeparator());
                }
                fs.append("    public static String getIgcTypeId() { return \"" + id + "\"; }");
                fs.append(System.lineSeparator());
                fs.append("    public static String getIgcTypeDisplayName() { return \"" + name + "\"; }");
                fs.append(System.lineSeparator());
                fs.append(System.lineSeparator());
                if (!this.ALIAS_OBJECTS.containsKey(id)) {
                    PropertyList propertyList = new PropertyList();
                    ArrayNode view = this.nf.arrayNode();
                    if (jsonProps.hasNonNull("viewInfo") && jsonProps.path("viewInfo").hasNonNull("properties")) {
                        view = (ArrayNode)jsonProps.path("viewInfo").path("properties");
                    }
                    if (view.size() > 0) {
                        propertyList = this.getPropertiesForPOJO(fs, view);
                    }
                    fs.append("    public static Boolean canBeCreated() { return " + jsonProps.hasNonNull("createInfo") + "; }");
                    fs.append(System.lineSeparator());
                    List<String> nonRelationshipProperties = propertyList.getNonRelationshipProperties();
                    fs.append("    public static Boolean includesModificationDetails() { return " + nonRelationshipProperties.contains("modified_on") + "; }");
                    fs.append(System.lineSeparator());
                    if (!nonRelationshipProperties.isEmpty()) {
                        fs.append("    private static final List<String> NON_RELATIONAL_PROPERTIES = Arrays.asList(");
                        fs.append(System.lineSeparator());
                        for (int i = 0; i < nonRelationshipProperties.size() - 1; ++i) {
                            fs.append("        \"" + nonRelationshipProperties.get(i) + "\",");
                            fs.append(System.lineSeparator());
                        }
                        fs.append("        \"" + nonRelationshipProperties.get(nonRelationshipProperties.size() - 1) + "\"");
                        fs.append(System.lineSeparator());
                        fs.append("    );");
                        fs.append(System.lineSeparator());
                    } else {
                        fs.append("    private static final List<String> NON_RELATIONAL_PROPERTIES = new ArrayList<>();");
                        fs.append(System.lineSeparator());
                    }
                    List<String> stringProperties = propertyList.getStringProperties();
                    if (!stringProperties.isEmpty()) {
                        fs.append("    private static final List<String> STRING_PROPERTIES = Arrays.asList(");
                        fs.append(System.lineSeparator());
                        for (int i = 0; i < stringProperties.size() - 1; ++i) {
                            fs.append("        \"" + stringProperties.get(i) + "\",");
                            fs.append(System.lineSeparator());
                        }
                        fs.append("        \"" + stringProperties.get(stringProperties.size() - 1) + "\"");
                        fs.append(System.lineSeparator());
                        fs.append("    );");
                        fs.append(System.lineSeparator());
                    } else {
                        fs.append("    private static final List<String> STRING_PROPERTIES = new ArrayList<>();");
                        fs.append(System.lineSeparator());
                    }
                    List<String> relationshipProperties = propertyList.getRelationshipProperties();
                    if (!relationshipProperties.isEmpty()) {
                        fs.append("    private static final List<String> PAGED_RELATIONAL_PROPERTIES = Arrays.asList(");
                        fs.append(System.lineSeparator());
                        for (int i = 0; i < relationshipProperties.size() - 1; ++i) {
                            fs.append("        \"" + relationshipProperties.get(i) + "\",");
                            fs.append(System.lineSeparator());
                        }
                        fs.append("        \"" + relationshipProperties.get(relationshipProperties.size() - 1) + "\"");
                        fs.append(System.lineSeparator());
                        fs.append("    );");
                        fs.append(System.lineSeparator());
                    } else {
                        fs.append("    private static final List<String> PAGED_RELATIONAL_PROPERTIES = new ArrayList<>();");
                        fs.append(System.lineSeparator());
                    }
                    List<String> allProperties = propertyList.getAllProperties();
                    if (!allProperties.isEmpty()) {
                        fs.append("    private static final List<String> ALL_PROPERTIES = Arrays.asList(");
                        fs.append(System.lineSeparator());
                        for (int i = 0; i < allProperties.size() - 1; ++i) {
                            fs.append("        \"" + allProperties.get(i) + "\",");
                            fs.append(System.lineSeparator());
                        }
                        fs.append("        \"" + allProperties.get(allProperties.size() - 1) + "\"");
                        fs.append(System.lineSeparator());
                        fs.append("    );");
                        fs.append(System.lineSeparator());
                    } else {
                        fs.append("    private static final List<String> ALL_PROPERTIES = new ArrayList<>();");
                        fs.append(System.lineSeparator());
                    }
                    fs.append("    public static List<String> getNonRelationshipProperties() { return NON_RELATIONAL_PROPERTIES; }");
                    fs.append(System.lineSeparator());
                    fs.append("    public static List<String> getStringProperties() { return STRING_PROPERTIES; }");
                    fs.append(System.lineSeparator());
                    fs.append("    public static List<String> getPagedRelationshipProperties() { return PAGED_RELATIONAL_PROPERTIES; }");
                    fs.append(System.lineSeparator());
                    fs.append("    public static List<String> getAllProperties() { return ALL_PROPERTIES; }");
                    fs.append(System.lineSeparator());
                }
                fs.append("    public static Boolean is" + className + "(Object obj) { return (obj.getClass() == " + className + ".class); }");
                fs.append(System.lineSeparator());
                fs.append(System.lineSeparator());
                fs.append("}");
                fs.append(System.lineSeparator());
            }
            catch (IOException e) {
                log.error("Unable to open file output: {}" + filename, (Throwable)e);
            }
        }
    }

    private String getClassHeading(String displayName, String typeName) {
        StringBuilder sb = new StringBuilder();
        sb.append("/**");
        sb.append(System.lineSeparator());
        sb.append(" * POJO for the {@code ");
        sb.append(typeName);
        sb.append("} asset type in IGC, displayed as '{@literal ");
        sb.append(displayName);
        sb.append("}' in the IGC UI.");
        sb.append(System.lineSeparator());
        sb.append(" * <br><br>");
        sb.append(System.lineSeparator());
        sb.append(" * (this code has been generated based on out-of-the-box IGC metadata types;");
        sb.append(System.lineSeparator());
        sb.append(" *  if modifications are needed, eg. to handle custom attributes,");
        sb.append(System.lineSeparator());
        sb.append(" *  extending from this class in your own custom class is the best approach.)");
        sb.append(System.lineSeparator());
        sb.append(" */");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    protected class PropertyDetail {
        private String member;
        private String getSet;
        private String javaType;

        public void setMember(String member) {
            this.member = member;
        }

        public void setGetSet(String getSet) {
            this.getSet = getSet;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getMember() {
            return this.member;
        }

        public String getGetSet() {
            return this.getSet;
        }

        public String getJavaType() {
            return this.javaType;
        }
    }

    protected class PropertyList {
        private List<String> members = new ArrayList<String>();
        private List<String> gettersSetters = new ArrayList<String>();
        private List<String> nonRelationship = new ArrayList<String>();
        private List<String> stringProperties = new ArrayList<String>();
        private List<String> relationship = new ArrayList<String>();
        private List<String> allProperties = new ArrayList<String>();

        public void addMember(String member) {
            this.members.add(member);
        }

        public void addGetterSetter(String getterSetter) {
            this.gettersSetters.add(getterSetter);
        }

        public List<String> getMembers() {
            return this.members;
        }

        public List<String> getGettersSetters() {
            return this.gettersSetters;
        }

        public void addNonRelationshipProperty(String propertyName) {
            this.nonRelationship.add(propertyName);
        }

        public void addStringProperty(String propertyName) {
            this.stringProperties.add(propertyName);
        }

        public void addRelationshipProperty(String propertyName) {
            this.relationship.add(propertyName);
        }

        public void addToAllProperties(String propertyName) {
            this.allProperties.add(propertyName);
        }

        public List<String> getNonRelationshipProperties() {
            return this.nonRelationship;
        }

        public List<String> getStringProperties() {
            return this.stringProperties;
        }

        public List<String> getRelationshipProperties() {
            return this.relationship;
        }

        public List<String> getAllProperties() {
            return this.allProperties;
        }
    }
}

