/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;

public class Identity {
    private List<Reference> context = new ArrayList<Reference>();
    private String assetType = "";
    private String assetName = "";
    private String rid = null;

    public Identity() {
    }

    public Identity(List<Reference> context, String assetType, String assetName) {
        this(context, assetType, assetName, null);
    }

    public Identity(List<Reference> context, String assetType, String assetName, String rid) {
        this();
        this.context = context;
        this.assetType = assetType;
        this.assetName = assetName;
        this.rid = rid;
    }

    public boolean sameas(Identity identity) {
        return this.toString().equals(identity.toString());
    }

    public Identity getParentIdentity() {
        Identity parent = null;
        if (!this.context.isEmpty()) {
            Integer lastIndex = this.context.size() - 1;
            Reference endOfCtx = this.context.get(lastIndex);
            List<Reference> parentCtx = this.context.subList(0, lastIndex);
            parent = new Identity(parentCtx, endOfCtx.getType(), endOfCtx.getName(), endOfCtx.getId());
        }
        return parent;
    }

    public String getRid() {
        return this.rid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Reference ref : this.context) {
            sb.append("(" + ref.getType() + ")=" + ref.getName() + "::");
        }
        sb.append("(" + this.assetType + ")=" + this.assetName);
        return sb.toString();
    }
}

