/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectPrinter {
    private static final Logger log = LoggerFactory.getLogger(ObjectPrinter.class);

    protected ArrayList<Field> getAllFields(Class clazz) {
        Class superClazz = clazz.getSuperclass();
        ArrayList<Field> al = superClazz != null ? this.getAllFields(superClazz) : new ArrayList();
        al.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return al;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"" + this.getClass().getName() + "\"");
        sb.append(": { ");
        try {
            for (Field f : this.getAllFields(this.getClass())) {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                sb.append("\"" + f.getName() + "\"");
                sb.append(": ");
                Object value = f.get(this);
                if (value == null) {
                    sb.append("\"null\"");
                } else if (Reference.isSimpleType(value).booleanValue()) {
                    sb.append("\"" + value + "\"");
                } else {
                    sb.append(value);
                }
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 2);
        }
        catch (IllegalAccessException e) {
            log.error("Unable to access all fields.", (Throwable)e);
        }
        sb.append("}}");
        return sb.toString();
    }
}

