/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestClient;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.IGCRestConstants;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.Identity;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.MainObject;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ObjectPrinter;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.model.common.ReferenceList;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearch;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchSorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="_type", visible=true, defaultImpl=Reference.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MainObject.class, name="main_object")})
@JsonIgnoreProperties(ignoreUnknown=true)
public class Reference
extends ObjectPrinter {
    @JsonIgnore
    private static final Logger log = LoggerFactory.getLogger(Reference.class);
    @JsonIgnore
    private Identity identity = null;
    @JsonIgnore
    private boolean fullyRetrieved = false;
    protected ArrayList<Reference> _context = new ArrayList();
    protected String _name;
    protected String _type;
    protected String _id;
    protected String _url;
    private static final List<String> NON_RELATIONAL_PROPERTIES = Arrays.asList("name");

    @JsonProperty(value="_context")
    public ArrayList<Reference> getContext() {
        return this._context;
    }

    @JsonProperty(value="_context")
    public void setContext(ArrayList<Reference> _context) {
        this._context = _context;
    }

    @JsonProperty(value="_name")
    public String getName() {
        return this._name;
    }

    @JsonProperty(value="_name")
    public void setName(String _name) {
        this._name = _name;
    }

    @JsonProperty(value="_type")
    public String getType() {
        return this._type;
    }

    @JsonProperty(value="_type")
    public void setType(String _type) {
        this._type = _type;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this._id;
    }

    @JsonProperty(value="_id")
    public void setId(String _id) {
        this._id = _id;
    }

    @JsonProperty(value="_url")
    public String getUrl() {
        return this._url;
    }

    @JsonProperty(value="_url")
    public void setUrl(String _url) {
        this._url = _url;
    }

    public boolean isFullyRetrieved() {
        return this.fullyRetrieved;
    }

    public void setFullyRetrieved() {
        this.fullyRetrieved = true;
    }

    public static List<String> getNonRelationshipProperties() {
        return NON_RELATIONAL_PROPERTIES;
    }

    public Reference getAssetWithSubsetOfProperties(IGCRestClient igcrest, String[] properties, int pageSize, IGCSearchSorting sorting) {
        ReferenceList assetsWithProperties;
        Reference assetWithProperties = null;
        IGCSearchCondition idOnly = new IGCSearchCondition("_id", "=", this._id);
        IGCSearchConditionSet idOnlySet = new IGCSearchConditionSet(idOnly);
        IGCSearch igcSearch = new IGCSearch(Reference.getAssetTypeForSearch(this.getType()), properties, idOnlySet);
        if (pageSize > 0) {
            igcSearch.setPageSize(pageSize);
        }
        if (sorting != null) {
            igcSearch.addSortingCriteria(sorting);
        }
        if (!(assetsWithProperties = igcrest.search(igcSearch)).getItems().isEmpty()) {
            assetWithProperties = assetsWithProperties.getItems().get(0);
        }
        return assetWithProperties;
    }

    public Reference getAssetWithSubsetOfProperties(IGCRestClient igcrest, String[] properties, int pageSize) {
        return this.getAssetWithSubsetOfProperties(igcrest, properties, pageSize, null);
    }

    public Reference getAssetWithSubsetOfProperties(IGCRestClient igcrest, String[] properties) {
        return this.getAssetWithSubsetOfProperties(igcrest, properties, igcrest.getDefaultPageSize());
    }

    public Reference getAssetDetails(IGCRestClient igcrest) {
        return igcrest.getAssetById(this._id);
    }

    public Reference getFullAssetDetails(IGCRestClient igcrest) {
        Reference asset = igcrest.getAssetById(this.getId());
        try {
            for (Field f : asset.getClass().getFields()) {
                Object relationship;
                Class<?> fieldClass = f.getType();
                if (fieldClass != ReferenceList.class || (relationship = f.get(asset)) == null) continue;
                ((ReferenceList)relationship).getAllPages(igcrest);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Unable to access field.", (Throwable)e);
        }
        return asset;
    }

    private static Field recursePropertyByName(String name, Class clazz) {
        Field f = null;
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            try {
                f = superClazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                f = Reference.recursePropertyByName(name, superClazz);
            }
        }
        return f;
    }

    public Field getFieldByName(String name) {
        Field field;
        try {
            field = this.getClass().getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            field = Reference.recursePropertyByName(name, this.getClass());
        }
        return field;
    }

    public boolean hasProperty(String name) {
        Field property = this.getFieldByName(name);
        return property != null;
    }

    public Object getPropertyByName(String name) {
        Object value = null;
        Field property = this.getFieldByName(name);
        if (property != null) {
            try {
                property.setAccessible(true);
                value = property.get(this);
            }
            catch (IllegalAccessException e) {
                log.error("Unable to access property '" + name + "'", (Throwable)e);
            }
        }
        return value;
    }

    public void setPropertyByName(String name, Object value) {
        Field property = this.getFieldByName(name);
        if (property != null) {
            try {
                property.setAccessible(true);
                property.set(this, value);
            }
            catch (IllegalAccessException e) {
                log.error("Unable to access property '" + name + "'", (Throwable)e);
            }
        }
    }

    public static final Boolean isReference(Object obj) {
        Class<?> clazz;
        for (clazz = obj.getClass(); clazz != null && clazz != Reference.class; clazz = clazz.getSuperclass()) {
        }
        return clazz == Reference.class;
    }

    public Boolean isReference(String propertyName) {
        Field property = this.getFieldByName(propertyName);
        return property.getType() == Reference.class;
    }

    public static final Boolean isReferenceList(Object obj) {
        return obj.getClass() == ReferenceList.class;
    }

    public Boolean isReferenceList(String propertyName) {
        Field property = this.getFieldByName(propertyName);
        return property.getType() == ReferenceList.class;
    }

    public static final Boolean isSimpleType(Object obj) {
        return Reference.isReference(obj) == false && Reference.isReferenceList(obj) == false;
    }

    public Boolean isSimpleType(String propertyName) {
        Field property = this.getFieldByName(propertyName);
        return property.getType() != Reference.class && property.getType() != ReferenceList.class;
    }

    public boolean populateModificationDetails(IGCRestClient igcrest) {
        boolean success = true;
        boolean bHasModificationDetails = this.hasModificationDetails();
        String createdBy = (String)this.getPropertyByName("created_by");
        if (bHasModificationDetails && createdBy == null) {
            IGCSearchCondition idOnly = new IGCSearchCondition("_id", "=", this.getId());
            IGCSearchConditionSet idOnlySet = new IGCSearchConditionSet(idOnly);
            IGCSearch igcSearch = new IGCSearch(this.getType(), idOnlySet);
            igcSearch.addProperties(IGCRestConstants.getModificationProperties());
            igcSearch.setPageSize(2);
            ReferenceList assetsWithModDetails = igcrest.search(igcSearch);
            boolean bl = success = !assetsWithModDetails.getItems().isEmpty();
            if (success) {
                Reference assetWithModDetails = assetsWithModDetails.getItems().get(0);
                this.setPropertyByName("created_on", assetWithModDetails.getPropertyByName("created_on"));
                this.setPropertyByName("created_by", assetWithModDetails.getPropertyByName("created_by"));
                this.setPropertyByName("modified_on", assetWithModDetails.getPropertyByName("modified_on"));
                this.setPropertyByName("modified_by", assetWithModDetails.getPropertyByName("modified_by"));
            }
        }
        return success;
    }

    public boolean populateContext(IGCRestClient igcrest) {
        boolean success = true;
        if (this._context.isEmpty()) {
            boolean bHasModificationDetails = this.hasModificationDetails();
            IGCSearchCondition idOnly = new IGCSearchCondition("_id", "=", this.getId());
            IGCSearchConditionSet idOnlySet = new IGCSearchConditionSet(idOnly);
            IGCSearch igcSearch = new IGCSearch(this.getType(), idOnlySet);
            if (bHasModificationDetails) {
                igcSearch.addProperties(IGCRestConstants.getModificationProperties());
            }
            igcSearch.setPageSize(2);
            ReferenceList assetsWithCtx = igcrest.search(igcSearch);
            boolean bl = success = !assetsWithCtx.getItems().isEmpty();
            if (success) {
                Reference assetWithCtx = assetsWithCtx.getItems().get(0);
                this._context = new ArrayList<Reference>(assetWithCtx.getContext());
                if (bHasModificationDetails) {
                    this.setPropertyByName("created_on", assetWithCtx.getPropertyByName("created_on"));
                    this.setPropertyByName("created_by", assetWithCtx.getPropertyByName("created_by"));
                    this.setPropertyByName("modified_on", assetWithCtx.getPropertyByName("modified_on"));
                    this.setPropertyByName("modified_by", assetWithCtx.getPropertyByName("modified_by"));
                }
            }
        }
        return success;
    }

    public Identity getIdentity(IGCRestClient igcrest) {
        if (this.identity == null) {
            this.populateContext(igcrest);
            this.identity = new Identity(this._context, this.getType(), this.getName());
        }
        return this.identity;
    }

    public boolean hasModificationDetails() {
        return this.hasProperty("modified_on");
    }

    public static boolean isCreatableFromPOJO(Class pojoClass) {
        boolean creatable = false;
        try {
            Method canBeCreated = pojoClass.getMethod("canBeCreated", new Class[0]);
            creatable = (Boolean)canBeCreated.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve creatable status from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return creatable;
    }

    public static String getDisplayNameFromPOJO(Class pojoClass) {
        String igcAssetDisplayName = null;
        try {
            Method getIgcTypeDisplayName = pojoClass.getMethod("getIgcTypeDisplayName", new Class[0]);
            igcAssetDisplayName = (String)getIgcTypeDisplayName.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve display name from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return igcAssetDisplayName;
    }

    public static String getAssetTypeFromPOJO(Class pojoClass) {
        String igcAssetType = null;
        try {
            Method getIgcType = pojoClass.getMethod("getIgcTypeId", new Class[0]);
            igcAssetType = (String)getIgcType.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve asset type from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return igcAssetType;
    }

    public static boolean canAssetBeCreatedFromPOJO(Class pojoClass) {
        Boolean canBe = false;
        try {
            Method canBeCreated = pojoClass.getMethod("canBeCreated", new Class[0]);
            canBe = (Boolean)canBeCreated.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve creation capability from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return canBe;
    }

    public static List<String> getNonRelationshipPropertiesFromPOJO(Class pojoClass) {
        List list = null;
        try {
            Method getNonRelationshipProperties = pojoClass.getMethod("getNonRelationshipProperties", new Class[0]);
            list = (List)getNonRelationshipProperties.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve non-relationship properties from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return list;
    }

    public static List<String> getStringPropertiesFromPOJO(Class pojoClass) {
        List list = null;
        try {
            Method getStringProperties = pojoClass.getMethod("getStringProperties", new Class[0]);
            list = (List)getStringProperties.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve string properties from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return list;
    }

    public static List<String> getAllPropertiesFromPOJO(Class pojoClass) {
        List list = null;
        try {
            Method getAllProperties = pojoClass.getMethod("getAllProperties", new Class[0]);
            list = (List)getAllProperties.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve all properties from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return list;
    }

    public static List<String> getPagedRelationalPropertiesFromPOJO(Class pojoClass) {
        List list = null;
        try {
            Method getPagedProperties = pojoClass.getMethod("getPagedRelationshipProperties", new Class[0]);
            list = (List)getPagedProperties.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve paged relationship properties from IGC POJO: {}", (Object)pojoClass, (Object)e);
        }
        return list;
    }

    public static boolean hasModificationDetails(Class pojoClass) {
        boolean hasModDetails = false;
        if (pojoClass != null) {
            try {
                Method hasModificationDetails = pojoClass.getMethod("includesModificationDetails", new Class[0]);
                Boolean bHasModificationDetails = (Boolean)hasModificationDetails.invoke(null, new Object[0]);
                hasModDetails = bHasModificationDetails != null && bHasModificationDetails != false;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.info("Unable to find modification details for class {}", (Object)pojoClass);
            }
        }
        return hasModDetails;
    }

    public static String getAssetTypeForSearch(String assetType) {
        String typeForSearch = null;
        switch (assetType) {
            case "host_(engine)": {
                typeForSearch = "host";
                break;
            }
            case "non_steward_user": 
            case "steward_user": {
                typeForSearch = "user";
                break;
            }
            default: {
                typeForSearch = assetType;
            }
        }
        return typeForSearch;
    }
}

