/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchConditionSet;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchSorting;

public class IGCSearch {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private ArrayNode types = this.nf.arrayNode();
    private ArrayNode properties = this.nf.arrayNode();
    private IGCSearchConditionSet conditions;
    private List<IGCSearchSorting> sortings = new ArrayList<IGCSearchSorting>();
    private int pageSize = 100;
    private int beginAt = 0;
    private boolean devGlossary = false;

    public IGCSearch() {
    }

    public IGCSearch(String type) {
        this();
        this.addType(type);
    }

    public IGCSearch(String type, IGCSearchConditionSet conditions) {
        this(type);
        this.addConditions(conditions);
    }

    public IGCSearch(String type, String[] properties, IGCSearchConditionSet conditions) {
        this();
        this.addType(type);
        for (String property : properties) {
            this.addProperty(property);
        }
        this.addConditions(conditions);
    }

    public void addType(String type) {
        this.types.add(type);
    }

    public void addProperty(String property) {
        this.properties.add(property);
    }

    public void addProperties(List<String> properties) {
        for (String property : properties) {
            this.properties.add(property);
        }
    }

    public void addConditions(IGCSearchConditionSet conditions) {
        this.conditions = conditions;
    }

    public void addSortingCriteria(IGCSearchSorting sortings) {
        this.sortings.add(sortings);
    }

    public void setPageSize(int size) {
        this.pageSize = size;
    }

    public void setBeginAt(int beginAt) {
        this.beginAt = beginAt;
    }

    public void setDevGlossary(boolean on) {
        this.devGlossary = on;
    }

    public JsonNode getQuery() {
        ObjectNode query = this.nf.objectNode();
        query.set("types", (JsonNode)this.types);
        if (this.properties != null && this.properties.size() > 0) {
            query.set("properties", (JsonNode)this.properties);
        }
        if (this.pageSize > 0) {
            query.set("pageSize", (JsonNode)this.nf.numberNode(this.pageSize));
        }
        if (this.conditions != null && this.conditions.size() > 0) {
            query.set("where", (JsonNode)this.conditions.getConditionSetObject());
        }
        if (this.sortings != null && !this.sortings.isEmpty()) {
            ArrayNode anSorts = this.nf.arrayNode();
            for (IGCSearchSorting sorting : this.sortings) {
                anSorts.add((JsonNode)sorting.getSortObject());
            }
            query.set("sorts", (JsonNode)anSorts);
        }
        if (this.beginAt > 0) {
            query.set("begin", (JsonNode)this.nf.numberNode(this.beginAt));
        }
        if (this.devGlossary) {
            query.set("workflowMode", (JsonNode)this.nf.textNode("draft"));
        }
        return query;
    }

    public String toString() {
        return this.getQuery().toString();
    }
}

