/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class IGCSearchCondition {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private String property;
    private String operator;
    private String value = null;
    private Boolean negated = null;

    public IGCSearchCondition(String property, String operator, String value) {
        this.property = property;
        this.operator = operator;
        this.value = value;
    }

    public IGCSearchCondition(String property, String operator, Boolean negated) {
        this.property = property;
        this.operator = operator;
        this.negated = negated;
    }

    public IGCSearchCondition(String property, String operator, String value, Boolean negated) {
        this.property = property;
        this.operator = operator;
        this.value = value;
        this.negated = negated;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getNegated() {
        return this.negated;
    }

    public void setNegated(Boolean negated) {
        this.negated = negated;
    }

    public ObjectNode getConditionObject() {
        ObjectNode condObj = this.nf.objectNode();
        condObj.set("property", (JsonNode)this.nf.textNode(this.getProperty()));
        condObj.set("operator", (JsonNode)this.nf.textNode(this.getOperator()));
        if (this.value != null) {
            condObj.set("value", (JsonNode)this.nf.textNode(this.getValue()));
        }
        if (this.negated != null) {
            condObj.set("negated", (JsonNode)this.nf.booleanNode(this.getNegated().booleanValue()));
        }
        return condObj;
    }
}

