/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search.IGCSearchCondition;

public class IGCSearchConditionSet {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private ArrayNode conditions = this.nf.arrayNode();
    private String conditionJoin = "and";
    private boolean negateAll = false;

    public IGCSearchConditionSet() {
    }

    public IGCSearchConditionSet(IGCSearchCondition condition) {
        this();
        this.addCondition(condition);
    }

    public void addCondition(IGCSearchCondition condition) {
        this.conditions.add((JsonNode)condition.getConditionObject());
    }

    public void setMatchAnyCondition(boolean on) {
        this.conditionJoin = on ? "or" : "and";
    }

    public void setNegateAll(boolean on) {
        this.negateAll = on;
    }

    public void addNestedConditionSet(IGCSearchConditionSet igcConditions) {
        this.conditions.add((JsonNode)igcConditions.getConditionSetObject());
    }

    public int size() {
        return this.conditions.size();
    }

    public ObjectNode getConditionSetObject() {
        ObjectNode condSet = this.nf.objectNode();
        if (this.size() > 0) {
            condSet.set("conditions", (JsonNode)this.conditions);
            condSet.set("operator", (JsonNode)this.nf.textNode(this.conditionJoin));
        }
        if (this.negateAll) {
            condSet.set("negated", (JsonNode)this.nf.booleanNode(true));
        }
        return condSet;
    }
}

