/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;

public class IGCSearchSorting {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private String property;
    private Boolean ascending;

    public IGCSearchSorting(String property, Boolean ascending) {
        this.property = property;
        this.ascending = ascending;
    }

    public IGCSearchSorting(String property) {
        this.property = property;
        this.ascending = true;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Boolean getAscending() {
        return this.ascending;
    }

    public void setAscending(Boolean ascending) {
        this.ascending = ascending;
    }

    public ObjectNode getSortObject() {
        ObjectNode sortObj = this.nf.objectNode();
        sortObj.set("property", (JsonNode)this.nf.textNode(this.getProperty()));
        sortObj.set("ascending", (JsonNode)this.nf.booleanNode(this.getAscending().booleanValue()));
        return sortObj;
    }

    public static IGCSearchSorting sortFromNonPropertySequencingOrder(SequencingOrder sequencingOrder) {
        IGCSearchSorting sort = null;
        if (sequencingOrder != null) {
            switch (sequencingOrder) {
                case GUID: {
                    sort = new IGCSearchSorting("_id");
                    break;
                }
                case CREATION_DATE_RECENT: {
                    sort = new IGCSearchSorting("created_on", false);
                    break;
                }
                case CREATION_DATE_OLDEST: {
                    sort = new IGCSearchSorting("created_on", true);
                    break;
                }
                case LAST_UPDATE_RECENT: {
                    sort = new IGCSearchSorting("modified_on", false);
                    break;
                }
                case LAST_UPDATE_OLDEST: {
                    sort = new IGCSearchSorting("modified_on", true);
                    break;
                }
                default: {
                    sort = null;
                }
            }
        }
        return sort;
    }
}

