/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.igc.clientlibrary.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IGCUpdate {
    private JsonNodeFactory nf = JsonNodeFactory.instance;
    private String ridToUpdate;
    private Map<String, List<String>> relationships;
    private Map<String, String> exclusiveRelationships;
    private UpdateMode relationshipUpdateMode;

    public IGCUpdate(String ridToUpdate) {
        this.ridToUpdate = ridToUpdate;
        this.relationships = new HashMap<String, List<String>>();
        this.exclusiveRelationships = new HashMap<String, String>();
    }

    public void addExclusiveRelationship(String propertyName, String relatedRid) {
        this.exclusiveRelationships.put(propertyName, relatedRid);
    }

    public void addRelationship(String propertyName, String relatedRid) {
        if (!this.relationships.containsKey(propertyName)) {
            this.relationships.put(propertyName, new ArrayList());
        }
        this.relationships.get(propertyName).add(relatedRid);
    }

    public void setRelationshipUpdateMode(UpdateMode updateMode) {
        this.relationshipUpdateMode = updateMode;
    }

    public String getRidToUpdate() {
        return this.ridToUpdate;
    }

    public JsonNode getUpdate() {
        ObjectNode update = this.nf.objectNode();
        for (String propertyName : this.relationships.keySet()) {
            List<String> rids = this.relationships.get(propertyName);
            ArrayNode ridArray = this.nf.arrayNode(rids.size());
            for (String rid : rids) {
                ridArray.add(rid);
            }
            ObjectNode items = this.nf.objectNode();
            items.set("items", (JsonNode)ridArray);
            if (this.relationshipUpdateMode != null) {
                TextNode mode = null;
                mode = this.relationshipUpdateMode == UpdateMode.REPLACE ? this.nf.textNode("replace") : this.nf.textNode("add");
                items.set("mode", (JsonNode)mode);
            }
            update.set(propertyName, (JsonNode)items);
        }
        if (!this.exclusiveRelationships.isEmpty()) {
            for (String propertyName : this.exclusiveRelationships.keySet()) {
                update.set(propertyName, (JsonNode)this.nf.textNode(this.exclusiveRelationships.get(propertyName)));
            }
        }
        return update;
    }

    public String toString() {
        return this.getUpdate().toString();
    }

    public static enum UpdateMode {
        APPEND,
        REPLACE;

    }
}

