/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.admin;

import java.util.Map;
import org.odpi.openmetadata.accessservices.informationview.auditlog.InformationViewAuditCode;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.ColumnContextEventBuilder;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.EntitiesCreatorHelper;
import org.odpi.openmetadata.accessservices.informationview.eventprocessor.EventPublisher;
import org.odpi.openmetadata.accessservices.informationview.listeners.InformationViewEnterpriseOmrsEventListener;
import org.odpi.openmetadata.accessservices.informationview.listeners.InformationViewInTopicListener;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopic;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationViewAdmin
implements AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(InformationViewAdmin.class);
    private EventPublisher eventPublisher;
    private OMRSRepositoryConnector enterpriseConnector;
    private OpenMetadataTopicConnector informationViewTopicConnector;
    private OMRSTopicConnector enterpriseOMRSTopicConnector = null;
    private OpenMetadataTopicListener informationViewInTopicListener;
    private EntitiesCreatorHelper entitiesCreatorHelper;
    private ColumnContextEventBuilder columnContextEventBuilder;
    private InformationViewEnterpriseOmrsEventListener informationViewEnterpriseOmrsEventListener;
    private OMRSAuditLog auditLog;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        InformationViewAuditCode auditCode = InformationViewAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.enterpriseOMRSTopicConnector = enterpriseOMRSTopicConnector;
        this.enterpriseConnector = enterpriseOMRSRepositoryConnector;
        this.auditLog = auditLog;
        this.informationViewTopicConnector = this.initializeInformationViewTopicConnector(accessServiceConfigurationProperties.getAccessServiceInTopic(), accessServiceConfigurationProperties.getAccessServiceOutTopic());
        this.entitiesCreatorHelper = new EntitiesCreatorHelper(this.enterpriseConnector, auditLog);
        if (enterpriseOMRSTopicConnector != null) {
            auditCode = InformationViewAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.columnContextEventBuilder = new ColumnContextEventBuilder(this.enterpriseConnector);
            this.eventPublisher = new EventPublisher((OpenMetadataTopic)this.informationViewTopicConnector, this.columnContextEventBuilder, auditLog);
            this.informationViewEnterpriseOmrsEventListener = new InformationViewEnterpriseOmrsEventListener(this.eventPublisher, auditLog);
            this.enterpriseOMRSTopicConnector.registerListener((OMRSTopicListener)this.informationViewEnterpriseOmrsEventListener);
        }
        if (this.informationViewTopicConnector != null) {
            auditCode = InformationViewAuditCode.SERVICE_REGISTERED_WITH_IV_TOPIC;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.informationViewInTopicListener = new InformationViewInTopicListener(this.entitiesCreatorHelper, auditLog);
            this.informationViewTopicConnector.registerListener(this.informationViewInTopicListener);
            try {
                this.informationViewTopicConnector.start();
            }
            catch (ConnectorCheckedException e) {
                auditCode = InformationViewAuditCode.ERROR_INITIALIZING_INFORMATION_VIEW_TOPIC_CONNECTION;
                auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
                throw new OMAGConfigurationErrorException(400, InformationViewAdmin.class.getSimpleName(), "initialize", auditCode.getFormattedLogMessage(new String[0]), auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        auditCode = InformationViewAuditCode.SERVICE_INITIALIZED;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    private OpenMetadataTopicConnector initializeInformationViewTopicConnector(Connection accessServiceInTopic, Connection accessServiceOutTopic) {
        String actionDescription = "initialize";
        if (accessServiceInTopic != null) {
            Map properties = accessServiceInTopic.getAdditionalProperties();
            ((Map)properties.get("consumer")).replace("kafka.omrs.topic.id", accessServiceInTopic.getQualifiedName());
            ((Map)properties.get("producer")).replace("kafka.omrs.topic.id", accessServiceOutTopic.getQualifiedName());
            accessServiceInTopic.setAdditionalProperties(properties);
            try {
                return this.getTopicConnector(accessServiceInTopic);
            }
            catch (Exception e) {
                InformationViewAuditCode auditCode = InformationViewAuditCode.ERROR_INITIALIZING_CONNECTION;
                this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(accessServiceInTopic.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction());
                throw e;
            }
        }
        return null;
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            return (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
        }
        catch (Throwable error) {
            String methodName = "getTopicConnector()";
            if (log.isDebugEnabled()) {
                log.debug("Unable to create topic connector: " + error.toString());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getTopicConnector"});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public void shutdown() {
        try {
            this.informationViewTopicConnector.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Error disconnecting information view topic connector");
        }
        String actionDescription = "shutdown";
        InformationViewAuditCode auditCode = InformationViewAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

