/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.contentmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.informationview.events.BusinessTerm;
import org.odpi.openmetadata.accessservices.informationview.events.ColumnContextEvent;
import org.odpi.openmetadata.accessservices.informationview.events.ColumnDetails;
import org.odpi.openmetadata.accessservices.informationview.events.ConnectionDetails;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnContextEventBuilder {
    private static final Logger log = LoggerFactory.getLogger(ColumnContextEventBuilder.class);
    private OMRSRepositoryConnector enterpriseConnector;

    public ColumnContextEventBuilder(OMRSRepositoryConnector enterpriseConnector) {
        this.enterpriseConnector = enterpriseConnector;
    }

    public List<ColumnContextEvent> buildEvents(String guidColumn) throws Exception {
        ArrayList<ColumnContextEvent> allEvents = new ArrayList<ColumnContextEvent>();
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
        for (Relationship relationship : this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", guidColumn, relationshipTypeGuid, 0, null, null, null, null, 0)) {
            allEvents.addAll(this.getTableTypeDetails(guidColumn, relationship));
        }
        log.info("Context events: {}", allEvents);
        return allEvents;
    }

    private List<ColumnContextEvent> getTableTypeDetails(String guidColumn, Relationship relationshipToParentType) throws Exception {
        log.debug("Load table type details for entity with guid {}", (Object)guidColumn);
        String tableTypeGuid = this.getOtherEntityGuid(guidColumn, relationshipToParentType);
        EntityDetail tableTypeDetail = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", tableTypeGuid);
        List<ColumnDetails> allColumns = this.getAllColumnsOfTable(tableTypeGuid);
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "SchemaAttributeType").getGUID();
        ArrayList<ColumnContextEvent> allEvents = new ArrayList<ColumnContextEvent>();
        for (Relationship parentTableRelationship : this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", tableTypeDetail.getGUID(), relationshipTypeGuid, 0, null, null, null, null, 0)) {
            allEvents.addAll(this.getRelationalTableDetails(tableTypeGuid, parentTableRelationship, allColumns));
        }
        String tableTypeQualifiedName = EntityPropertiesUtils.getStringValueForProperty(tableTypeDetail.getProperties(), "qualifiedName");
        allEvents = allEvents.stream().peek(e -> e.getTableContext().setTableTypeQualifiedName(tableTypeQualifiedName)).collect(Collectors.toList());
        return allEvents;
    }

    private List<ColumnContextEvent> getRelationalTableDetails(String guid, Relationship relationship, List<ColumnDetails> allColumns) throws Exception {
        log.debug("Load table details for entity with guid {}", (Object)guid);
        ArrayList<ColumnContextEvent> allEvents = new ArrayList<ColumnContextEvent>();
        String tableGuid = this.getOtherEntityGuid(guid, relationship);
        EntityDetail tableEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", tableGuid);
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
        String tableName = EntityPropertiesUtils.getStringValueForProperty(tableEntity.getProperties(), "name");
        String tableQualifiedName = EntityPropertiesUtils.getStringValueForProperty(tableEntity.getProperties(), "qualifiedName");
        for (Relationship schemaTypeRelationship : this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", tableEntity.getGUID(), relationshipTypeGuid, 0, null, null, null, null, 0)) {
            List<ColumnContextEvent> events = this.getDbSchemaTypeDetails(tableGuid, schemaTypeRelationship);
            allEvents.addAll(events.stream().peek(e -> {
                e.getTableContext().setTableName(tableName);
                e.getTableContext().setTableQualifiedName(tableQualifiedName);
                e.setTableColumns(allColumns);
            }).collect(Collectors.toList()));
        }
        return allEvents;
    }

    private List<ColumnDetails> getAllColumnsOfTable(String tableTypeGuid) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, TypeDefNotKnownException, PropertyErrorException, FunctionNotSupportedException, PagingErrorException, EntityProxyOnlyException, RelationshipNotKnownException, TypeErrorException {
        log.debug("Load table columns for entity with guid {}", (Object)tableTypeGuid);
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
        ArrayList<ColumnDetails> allColumns = new ArrayList<ColumnDetails>();
        for (Relationship relationship : this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", tableTypeGuid, relationshipTypeGuid, 0, null, null, null, null, 0)) {
            EntityDetail columnEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", this.getOtherEntityGuid(tableTypeGuid, relationship));
            ColumnDetails columnDetails = new ColumnDetails();
            columnDetails.setAttributeName(EntityPropertiesUtils.getStringValueForProperty(columnEntity.getProperties(), "name"));
            columnDetails.setPosition(EntityPropertiesUtils.getIntegerValueForProperty(columnEntity.getProperties(), "position"));
            columnDetails.setGuid(columnEntity.getGUID());
            columnDetails.setBusinessTerm(this.getBusinessTermAssociated(columnEntity));
            EntityDetail columnTypeUniverse = this.getColumnType(columnEntity);
            columnDetails.setType(EntityPropertiesUtils.getStringValueForProperty(columnTypeUniverse.getProperties(), "dataType"));
            columnDetails.setQualifiedNameColumnType(EntityPropertiesUtils.getStringValueForProperty(columnTypeUniverse.getProperties(), "qualifiedName"));
            columnDetails.setQualifiedName(EntityPropertiesUtils.getStringValueForProperty(columnEntity.getProperties(), "qualifiedName"));
            allColumns.add(columnDetails);
        }
        return allColumns;
    }

    private EntityDetail getColumnType(EntityDetail columnEntity) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, RelationshipNotKnownException, FunctionNotSupportedException, TypeDefNotKnownException, EntityProxyOnlyException, PagingErrorException, PropertyErrorException, TypeErrorException {
        log.debug("Load column type for entity with guid {}", (Object)columnEntity.getGUID());
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "SchemaAttributeType").getGUID();
        Relationship columnToColumnType = (Relationship)this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", columnEntity.getGUID(), relationshipTypeGuid, 0, null, null, null, null, 0).get(0);
        return this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", this.getOtherEntityGuid(columnEntity.getGUID(), columnToColumnType));
    }

    private BusinessTerm getBusinessTermAssociated(EntityDetail columnEntity) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, TypeDefNotKnownException, PropertyErrorException, FunctionNotSupportedException, PagingErrorException, EntityProxyOnlyException, TypeErrorException {
        log.debug("Load business term associated to column with guid {}", (Object)columnEntity.getGUID());
        BusinessTerm businessTerm = null;
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "SemanticAssignment").getGUID();
        List btRelationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", columnEntity.getGUID(), relationshipTypeGuid, 0, null, null, null, null, 0);
        if (btRelationships != null && btRelationships.size() != 0) {
            Relationship btRelationship = (Relationship)btRelationships.get(0);
            String btGuid = this.getOtherEntityGuid(columnEntity.getGUID(), btRelationship);
            EntityDetail btDetail = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", btGuid);
            businessTerm = new BusinessTerm();
            businessTerm.setGuid(btGuid);
            businessTerm.setName(EntityPropertiesUtils.getStringValueForProperty(btDetail.getProperties(), "displayName"));
            businessTerm.setQuery(EntityPropertiesUtils.getStringValueForProperty(btDetail.getProperties(), "query"));
        }
        return businessTerm;
    }

    private List<ColumnContextEvent> getDbSchemaTypeDetails(String guid, Relationship relationalDbSchemaRelationship) throws Exception {
        log.debug("Load db schema type for entity with guid {}", (Object)guid);
        ArrayList<ColumnContextEvent> allEvents = new ArrayList<ColumnContextEvent>();
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "AssetSchemaType").getGUID();
        String dbSchemaTypeGuid = this.getOtherEntityGuid(guid, relationalDbSchemaRelationship);
        List relationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", dbSchemaTypeGuid, relationshipTypeGuid, 0, null, null, null, null, 0);
        log.debug("Loaded AssetSchemaType relationships for {}", (Object)dbSchemaTypeGuid);
        for (Relationship relationship : relationships) {
            List<ColumnContextEvent> events = this.getDeployedDatabaseSchemaDetails(dbSchemaTypeGuid, relationship);
            allEvents.addAll(events);
        }
        InstanceProperties dbSchemaTypeProperties = ((Relationship)relationships.get(0)).getEntityTwoProxy().getUniqueProperties();
        allEvents.stream().peek(e -> e.getTableContext().setSchemaTypeQualifiedName(EntityPropertiesUtils.getStringValueForProperty(dbSchemaTypeProperties, "qualifiedName"))).collect(Collectors.toList());
        return allEvents;
    }

    private List<ColumnContextEvent> getDeployedDatabaseSchemaDetails(String guid, Relationship relationshipToDeployedDatabaseSchema) throws Exception {
        log.debug("Load deployed db schema for entity with guid {}", (Object)guid);
        ArrayList<ColumnContextEvent> allEvents = new ArrayList<ColumnContextEvent>();
        String deployedDatabaseSchemaGuid = this.getOtherEntityGuid(guid, relationshipToDeployedDatabaseSchema);
        EntityDetail deployedDatabaseSchemaEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", deployedDatabaseSchemaGuid);
        InstanceProperties deployedDatabaseSchemaEntityProperties = deployedDatabaseSchemaEntity.getProperties();
        String schemaName = EntityPropertiesUtils.getStringValueForProperty(deployedDatabaseSchemaEntityProperties, "name");
        String schemaQualifiedName = EntityPropertiesUtils.getStringValueForProperty(deployedDatabaseSchemaEntityProperties, "qualifiedName");
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "DataContentForDataSet").getGUID();
        List dbRelationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", deployedDatabaseSchemaGuid, relationshipTypeGuid, 0, null, null, null, null, 0);
        for (Relationship relationship : dbRelationships) {
            List<ColumnContextEvent> events = this.getDatabaseDetails(deployedDatabaseSchemaGuid, relationship);
            allEvents.addAll(events.stream().peek(e -> {
                e.getTableContext().setSchemaName(schemaName);
                e.getTableContext().setSchemaQualifiedName(schemaQualifiedName);
            }).collect(Collectors.toList()));
        }
        return allEvents;
    }

    private List<ColumnContextEvent> getDatabaseDetails(String guid, Relationship dbRelationships) throws Exception {
        log.debug("Load database details for entity with guid {}", (Object)guid);
        ArrayList<ColumnContextEvent> allEvents = new ArrayList<ColumnContextEvent>();
        String databaseGuid = this.getOtherEntityGuid(guid, dbRelationships);
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "ConnectionToAsset").getGUID();
        InstanceProperties databaseEntityProperties = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", databaseGuid).getProperties();
        List relationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", databaseGuid, relationshipTypeGuid, 0, null, null, null, null, 0);
        for (Relationship relationship : relationships) {
            ColumnContextEvent event = this.getConnectionDetails(databaseGuid, relationship);
            event.getTableContext().setDatabaseName(EntityPropertiesUtils.getStringValueForProperty(databaseEntityProperties, "name"));
            event.getTableContext().setDatabaseQualifiedName(EntityPropertiesUtils.getStringValueForProperty(databaseEntityProperties, "qualifiedName"));
            allEvents.add(event);
        }
        return allEvents;
    }

    private ColumnContextEvent getConnectionDetails(String guid, Relationship relationship) throws Exception {
        log.debug("Load connection details for entity with guid {}", (Object)guid);
        String connectionEntityGUID = this.getOtherEntityGuid(guid, relationship);
        EntityDetail connectionEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", connectionEntityGUID);
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "ConnectionEndpoint").getGUID();
        Relationship relationshipToEndpoint = (Relationship)this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", connectionEntityGUID, relationshipTypeGuid, 0, null, null, null, null, 0).get(0);
        String endpointGuid = this.getOtherEntityGuid(connectionEntityGUID, relationshipToEndpoint);
        ColumnContextEvent event = this.getEndpointDetails(endpointGuid);
        EntityDetail connectorTypeEntity = this.getConnectorTypeProviderName(connectionEntityGUID);
        event.getConnectionDetails().setConnectorProviderName(EntityPropertiesUtils.getStringValueForProperty(connectorTypeEntity.getProperties(), "connectorProviderClassName"));
        event.getConnectionDetails().setConnectorProviderQualifiedName(EntityPropertiesUtils.getStringValueForProperty(connectorTypeEntity.getProperties(), "qualifiedName"));
        event.getConnectionDetails().setConnectionQualifiedName(EntityPropertiesUtils.getStringValueForProperty(connectionEntity.getProperties(), "qualifiedName"));
        return event;
    }

    private EntityDetail getConnectorTypeProviderName(String connectionEntityGuid) throws Exception {
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", "ConnectionConnectorType").getGUID();
        Relationship relationshipToConnectorType = (Relationship)this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", connectionEntityGuid, relationshipTypeGuid, 0, null, null, null, null, 0).get(0);
        String connectorTypeGuid = this.getOtherEntityGuid(connectionEntityGuid, relationshipToConnectorType);
        return this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", connectorTypeGuid);
    }

    private ColumnContextEvent getEndpointDetails(String endpointGuid) throws Exception {
        log.debug("Load endpoint details for entity with guid {}", (Object)endpointGuid);
        EntityDetail endpointEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", endpointGuid);
        ColumnContextEvent columnContextEvent = new ColumnContextEvent();
        ConnectionDetails connectionDetails = new ConnectionDetails();
        columnContextEvent.setConnectionDetails(connectionDetails);
        String address = EntityPropertiesUtils.getStringValueForProperty(endpointEntity.getProperties(), "networkAddress");
        connectionDetails.setNetworkAddress(address);
        connectionDetails.setProtocol(EntityPropertiesUtils.getStringValueForProperty(endpointEntity.getProperties(), "protocol"));
        connectionDetails.setUrl(EntityPropertiesUtils.getStringValueForProperty(endpointEntity.getProperties(), "url"));
        connectionDetails.setEndpointQualifiedName(EntityPropertiesUtils.getStringValueForProperty(endpointEntity.getProperties(), "qualifiedName"));
        MapPropertyValue additionalProperties = EntityPropertiesUtils.getMapValueForProperty(endpointEntity.getProperties(), "additionalProperties");
        if (additionalProperties != null && additionalProperties.getMapValues() != null) {
            connectionDetails.setGaianNodeName(EntityPropertiesUtils.getStringValueForProperty(additionalProperties.getMapValues(), "GDName"));
        }
        return columnContextEvent;
    }

    private String getOtherEntityGuid(String guid, Relationship relationship) {
        if (guid.equals(relationship.getEntityOneProxy().getGUID())) {
            return relationship.getEntityTwoProxy().getGUID();
        }
        return relationship.getEntityOneProxy().getGUID();
    }
}

