/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.contentmanager;

import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitiesCreatorHelper {
    private static final Logger log = LoggerFactory.getLogger(EntitiesCreatorHelper.class);
    private static final Integer PAGE_SIZE = 0;
    private OMRSRepositoryConnector enterpriseConnector;
    private OMRSAuditLog auditLog;

    public EntitiesCreatorHelper(OMRSRepositoryConnector enterpriseConnector, OMRSAuditLog auditLog) {
        this.enterpriseConnector = enterpriseConnector;
        this.auditLog = auditLog;
    }

    private EntityDetail addEntity(String metadataCollectionId, String userName, String typeName, InstanceProperties instanceProperties) throws Exception {
        try {
            EntityDetail entity = this.enterpriseConnector.getRepositoryHelper().getSkeletonEntity("", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userName, typeName);
            return this.enterpriseConnector.getMetadataCollection().addEntity(userName, entity.getType().getTypeDefGUID(), instanceProperties, entity.getClassifications(), entity.getStatus());
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.ADD_ENTITY_EXCEPTION;
            this.auditLog.logException("addEntity", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(typeName), "entity of type{" + typeName + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private Relationship addRelationship(String metadataCollectionId, String typeName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID) throws Exception {
        try {
            Relationship relationship = this.enterpriseConnector.getRepositoryHelper().getSkeletonRelationship("", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, "informationViewOmas", typeName);
            return this.enterpriseConnector.getMetadataCollection().addRelationship("informationViewOmas", relationship.getType().getTypeDefGUID(), initialProperties, entityOneGUID, entityTwoGUID, InstanceStatus.ACTIVE);
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.ADD_RELATIONSHIP_EXCEPTION;
            this.auditLog.logException("addRelationship", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(typeName), "relationship of type{" + typeName + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public EntityDetail getEntity(String typeName, String qualifiedName) throws Exception {
        InstanceProperties matchProperties = this.buildMatchingInstanceProperties("qualifiedName", qualifiedName);
        TypeDef typeDef = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", typeName);
        try {
            List existingEntities = this.enterpriseConnector.getMetadataCollection().findEntitiesByProperty("informationViewOmas", typeDef.getGUID(), matchProperties, MatchCriteria.ALL, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, SequencingOrder.ANY, PAGE_SIZE.intValue());
            return this.checkEntities(existingEntities, qualifiedName);
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.GET_ENTITY_EXCEPTION;
            this.auditLog.logException("getEntity", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(qualifiedName), "entity with properties{" + matchProperties + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private EntityDetail checkEntities(List<EntityDetail> existingEntities, String qualifiedName) {
        if (existingEntities != null && !existingEntities.isEmpty()) {
            return existingEntities.stream().filter(e -> qualifiedName.equals(EntityPropertiesUtils.getStringValueForProperty(e.getProperties(), "qualifiedName"))).findFirst().get();
        }
        return null;
    }

    private Relationship getRelationship(String relationshipType, String guid1, String guid2) throws Exception {
        List relationships;
        try {
            String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", relationshipType).getGUID();
            relationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", guid2, relationshipTypeGuid, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, 0);
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.GET_RELATIONSHIP_EXCEPTION;
            this.auditLog.logException("getRelationship", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(relationshipType), "relationship with type" + relationshipType + " between {" + guid1 + ", " + guid2 + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
        if (relationships != null && !relationships.isEmpty()) {
            for (Relationship relationship : relationships) {
                if (!relationship.getType().getTypeDefName().equals(relationshipType) || !this.checkRelationshipEnds(relationship, guid1, guid2)) continue;
                return relationship;
            }
        }
        return null;
    }

    private boolean checkRelationshipEnds(Relationship relationship, String guid1, String guid2) {
        String end1Guid = relationship.getEntityOneProxy().getGUID();
        String end2Guid = relationship.getEntityTwoProxy().getGUID();
        return end1Guid.equals(guid1) && end2Guid.equals(guid2) || end1Guid.equals(guid2) && end2Guid.equals(guid1);
    }

    public EntityDetail addEntity(String typeName, String qualifiedName, InstanceProperties properties) throws Exception {
        EntityDetail entityDetail = this.getEntity(typeName, qualifiedName);
        if (entityDetail == null) {
            entityDetail = this.addEntity("", "informationViewOmas", typeName, properties);
            log.info("Entity with qualified name {} added", (Object)qualifiedName);
            log.info("Entity: {}", (Object)entityDetail);
        } else {
            log.info("Entity with qualified name {} already exists", (Object)qualifiedName);
            log.info("Entity: {}", (Object)entityDetail);
        }
        return entityDetail;
    }

    public Relationship addRelationship(String relationshipType, String guid1, String guid2, String source, InstanceProperties properties) throws Exception {
        Relationship relationship = this.getRelationship(relationshipType, guid1, guid2);
        if (relationship == null) {
            relationship = this.addRelationship("", relationshipType, properties, guid1, guid2);
            log.info("Relationship {} added between: {} and {}", new Object[]{relationshipType, guid1, guid2});
            log.info("Relationship: {}", (Object)relationship);
        } else {
            log.info("Relationship {} already exists between: {} and {}", new Object[]{relationshipType, guid1, guid2});
            log.info("Relationship: {}", (Object)relationship);
        }
        return relationship;
    }

    private InstanceProperties buildMatchingInstanceProperties(String key, String value) {
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setProperty(key, (InstancePropertyValue)EntityPropertiesUtils.createPrimitiveStringPropertyValue(value));
        return instanceProperties;
    }
}

