/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.listeners;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.EntitiesCreatorHelper;
import org.odpi.openmetadata.accessservices.informationview.events.DerivedColumnDetail;
import org.odpi.openmetadata.accessservices.informationview.events.InformationViewEvent;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationViewInTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(InformationViewInTopicListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final EntitiesCreatorHelper entitiesCreatorHelper;
    private final OMRSAuditLog auditLog;

    public InformationViewInTopicListener(EntitiesCreatorHelper entitiesCreatorHelper, OMRSAuditLog auditLog) {
        this.entitiesCreatorHelper = entitiesCreatorHelper;
        this.auditLog = auditLog;
    }

    public void processEvent(String eventAsString) {
        InformationViewErrorCode auditCode;
        InformationViewEvent event = null;
        try {
            event = (InformationViewEvent)OBJECT_MAPPER.readValue(eventAsString, InformationViewEvent.class);
        }
        catch (Exception e) {
            auditCode = InformationViewErrorCode.PARSE_EVENT;
            this.auditLog.logException("processEvent", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getErrorMessage(), "event {" + eventAsString + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
        }
        if (event != null) {
            try {
                EntityDetail dataStore = this.entitiesCreatorHelper.getEntity("DataStore", event.getTableContext().getDatabaseQualifiedName());
                String qualifiedNameForInformationView = "iv_" + event.getTableContext().getSchemaQualifiedName();
                InstanceProperties ivProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForInformationView).withStringProperty("name", "iv_" + event.getTableContext().getSchemaName()).withStringProperty("owner", "").withStringProperty("description", "This asset is an information view").build();
                EntityDetail informationViewEntity = this.entitiesCreatorHelper.addEntity("InformationView", qualifiedNameForInformationView, ivProperties);
                this.entitiesCreatorHelper.addRelationship("DataContentForDataSet", dataStore.getGUID(), informationViewEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
                String qualifiedNameForDbSchemaType = "iv_" + event.getTableContext().getSchemaTypeQualifiedName();
                InstanceProperties dbSchemaTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForDbSchemaType).withStringProperty("displayName", "iv_" + event.getTableContext().getSchemaName() + "_type").withStringProperty("author", "").withStringProperty("usage", "").withStringProperty("encodingStandard", "").build();
                EntityDetail relationalDbSchemaType = this.entitiesCreatorHelper.addEntity("RelationalDBSchemaType", qualifiedNameForDbSchemaType, dbSchemaTypeProperties);
                this.entitiesCreatorHelper.addRelationship("AssetSchemaType", informationViewEntity.getGUID(), relationalDbSchemaType.getGUID(), "InformationViewOmas", new InstanceProperties());
                String qualifiedNameForTableType = "iv_" + event.getTableContext().getTableTypeQualifiedName();
                InstanceProperties tableTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForTableType).withStringProperty("displayName", "iv_" + event.getTableContext().getTableName() + "_type").withStringProperty("author", "").withStringProperty("usage", "").withStringProperty("encodingStandard", "").build();
                EntityDetail tableTypeEntity = this.entitiesCreatorHelper.addEntity("RelationalTableType", qualifiedNameForTableType, tableTypeProperties);
                String qualifiedNameForTable = "iv_" + event.getTableContext().getTableQualifiedName();
                InstanceProperties tableProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForTable).withStringProperty("name", "iv_" + event.getTableContext().getTableName()).build();
                EntityDetail tableEntity = this.entitiesCreatorHelper.addEntity("RelationalTable", qualifiedNameForTable, tableProperties);
                this.entitiesCreatorHelper.addRelationship("SchemaAttributeType", tableEntity.getGUID(), tableTypeEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
                this.entitiesCreatorHelper.addRelationship("AttributeForSchema", relationalDbSchemaType.getGUID(), tableEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
                for (DerivedColumnDetail derivedColumn : event.getDerivedColumns()) {
                    String qualifiedNameColumnType = "iv_" + derivedColumn.getRealColumn().getQualifiedNameColumnType();
                    InstanceProperties columnTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameColumnType).withStringProperty("displayName", "iv_" + derivedColumn.getAttributeName() + "_type").withStringProperty("author", "").withStringProperty("usage", "").withStringProperty("encodingStandard", "").withStringProperty("dataType", derivedColumn.getType()).build();
                    EntityDetail columnTypeEntity = this.entitiesCreatorHelper.addEntity("RelationalColumnType", qualifiedNameColumnType, columnTypeProperties);
                    String qualifiedNameForColumn = EntityPropertiesUtils.getStringValueForProperty(columnTypeEntity.getProperties(), "qualifiedName") + "." + derivedColumn.getAttributeName();
                    InstanceProperties columnProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForColumn).withStringProperty("name", derivedColumn.getAttributeName()).withStringProperty("formula", "").withIntegerProperty("position", derivedColumn.getPosition()).build();
                    EntityDetail derivedColumnEntity = this.entitiesCreatorHelper.addEntity("DerivedRelationalColumn", qualifiedNameForColumn, columnProperties);
                    InstanceProperties schemaQueryImplProperties = new EntityPropertiesBuilder().withStringProperty("query", "").build();
                    this.entitiesCreatorHelper.addRelationship("SchemaQueryImplementation", derivedColumnEntity.getGUID(), derivedColumn.getRealColumn().getGuid(), "InformationViewOmas", schemaQueryImplProperties);
                    this.entitiesCreatorHelper.addRelationship("SchemaAttributeType", derivedColumnEntity.getGUID(), columnTypeEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
                    this.entitiesCreatorHelper.addRelationship("SemanticAssignment", derivedColumnEntity.getGUID(), derivedColumn.getRealColumn().getBusinessTerm().getGuid(), "InformationViewOmas", new InstanceProperties());
                    this.entitiesCreatorHelper.addRelationship("AttributeForSchema", tableTypeEntity.getGUID(), derivedColumnEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
                }
            }
            catch (Exception e) {
                log.error("Exception processing event from in topic", (Throwable)e);
                auditCode = InformationViewErrorCode.PROCESS_EVENT_EXCEPTION;
                this.auditLog.logException("processEvent", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(eventAsString), e.getMessage(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            }
        }
    }
}

