/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.contentmanager;

import java.util.Collections;
import java.util.List;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitiesCreatorHelper {
    private static final Logger log = LoggerFactory.getLogger(EntitiesCreatorHelper.class);
    private static final Integer PAGE_SIZE = 0;
    private OMRSRepositoryConnector enterpriseConnector;
    private OMRSAuditLog auditLog;

    public EntitiesCreatorHelper(OMRSRepositoryConnector enterpriseConnector, OMRSAuditLog auditLog) {
        this.enterpriseConnector = enterpriseConnector;
        this.auditLog = auditLog;
    }

    private EntityDetail addEntity(String metadataCollectionId, String userName, String typeName, InstanceProperties instanceProperties, List<Classification> classifications, String sourceName) throws Exception {
        try {
            EntityDetail entity = this.enterpriseConnector.getRepositoryHelper().getSkeletonEntity(sourceName, metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userName, typeName);
            entity.setClassifications(classifications);
            return this.enterpriseConnector.getMetadataCollection().addEntity(userName, entity.getType().getTypeDefGUID(), instanceProperties, entity.getClassifications(), entity.getStatus());
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.ADD_ENTITY_EXCEPTION;
            this.auditLog.logException("addEntity", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(typeName), "entity of type{" + typeName + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private Relationship addRelationship(String metadataCollectionId, String typeName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID) throws Exception {
        try {
            Relationship relationship = this.enterpriseConnector.getRepositoryHelper().getSkeletonRelationship("", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, "informationViewOmas", typeName);
            return this.enterpriseConnector.getMetadataCollection().addRelationship("informationViewOmas", relationship.getType().getTypeDefGUID(), initialProperties, entityOneGUID, entityTwoGUID, InstanceStatus.ACTIVE);
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.ADD_RELATIONSHIP_EXCEPTION;
            this.auditLog.logException("addRelationship", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(typeName), "relationship of type{" + typeName + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public EntityDetail getEntity(String typeName, String qualifiedName) throws Exception {
        InstanceProperties matchProperties = this.buildMatchingInstanceProperties("qualifiedName", qualifiedName);
        TypeDef typeDef = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", typeName);
        try {
            List existingEntities = this.enterpriseConnector.getMetadataCollection().findEntitiesByProperty("informationViewOmas", typeDef.getGUID(), matchProperties, MatchCriteria.ALL, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, SequencingOrder.ANY, PAGE_SIZE.intValue());
            return this.checkEntities(existingEntities, qualifiedName);
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.GET_ENTITY_EXCEPTION;
            this.auditLog.logException("getEntity", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(qualifiedName), "entity with properties{" + matchProperties + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private EntityDetail checkEntities(List<EntityDetail> existingEntities, String qualifiedName) {
        if (existingEntities != null && !existingEntities.isEmpty()) {
            return existingEntities.stream().filter(e -> qualifiedName.equals(EntityPropertiesUtils.getStringValueForProperty(e.getProperties(), "qualifiedName"))).findFirst().orElse(null);
        }
        return null;
    }

    private Relationship getRelationship(String relationshipType, String guid1, String guid2) throws Exception {
        List<Relationship> relationships;
        try {
            relationships = this.getRelationships(relationshipType, guid2);
        }
        catch (Exception e) {
            InformationViewErrorCode auditCode = InformationViewErrorCode.GET_RELATIONSHIP_EXCEPTION;
            this.auditLog.logException("getRelationship", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(relationshipType), "relationship with type" + relationshipType + " between {" + guid1 + ", " + guid2 + "}", auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
        if (relationships != null && !relationships.isEmpty()) {
            for (Relationship relationship : relationships) {
                if (!relationship.getType().getTypeDefName().equals(relationshipType) || !this.checkRelationshipEnds(relationship, guid1, guid2)) continue;
                return relationship;
            }
        }
        return null;
    }

    public List<Relationship> getRelationships(String relationshipType, String guid2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        String relationshipTypeGuid = this.enterpriseConnector.getMetadataCollection().getTypeDefByName("informationViewOmas", relationshipType).getGUID();
        List relationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", guid2, relationshipTypeGuid, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, 0);
        return relationships;
    }

    private boolean checkRelationshipEnds(Relationship relationship, String guid1, String guid2) {
        String end1Guid = relationship.getEntityOneProxy().getGUID();
        String end2Guid = relationship.getEntityTwoProxy().getGUID();
        return end1Guid.equals(guid1) && end2Guid.equals(guid2) || end1Guid.equals(guid2) && end2Guid.equals(guid1);
    }

    public EntityDetail addEntity(String typeName, String qualifiedName, InstanceProperties properties) throws Exception {
        return this.addEntity(typeName, qualifiedName, properties, null);
    }

    public EntityDetail addEntity(String typeName, String qualifiedName, InstanceProperties properties, List<Classification> classifications) throws Exception {
        EntityDetail entityDetail = this.getEntity(typeName, qualifiedName);
        if (entityDetail == null) {
            entityDetail = this.addEntity("", "informationViewOmas", typeName, properties, classifications, "InformationViewOmas");
            log.info("Entity with qualified name {} added", (Object)qualifiedName);
            log.info("Entity: {}", (Object)entityDetail);
        } else {
            log.info("Entity with qualified name {} already exists", (Object)qualifiedName);
            log.info("Entity: {}", (Object)entityDetail);
        }
        return entityDetail;
    }

    public Relationship addRelationship(String relationshipType, String guid1, String guid2, String source, InstanceProperties properties) throws Exception {
        Relationship relationship = this.getRelationship(relationshipType, guid1, guid2);
        if (relationship == null) {
            relationship = this.addRelationship("", relationshipType, properties, guid1, guid2);
            log.info("Relationship {} added between: {} and {}", new Object[]{relationshipType, guid1, guid2});
            log.info("Relationship: {}", (Object)relationship);
        } else {
            log.info("Relationship {} already exists between: {} and {}", new Object[]{relationshipType, guid1, guid2});
            log.info("Relationship: {}", (Object)relationship);
        }
        return relationship;
    }

    private InstanceProperties buildMatchingInstanceProperties(String key, String value) {
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties.setProperty(key, (InstancePropertyValue)EntityPropertiesUtils.createPrimitiveStringPropertyValue(value));
        return instanceProperties;
    }

    public Classification buildClassification(String classificationTypeName, String entityTypeName, InstanceProperties classificationProperties) throws Exception {
        try {
            Classification classification = this.enterpriseConnector.getRepositoryHelper().getSkeletonClassification("", "informationViewOmas", classificationTypeName, entityTypeName);
            classification.setProperties(classificationProperties);
            return classification;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            InformationViewErrorCode auditCode = InformationViewErrorCode.ADD_CLASSIFICATION;
            this.auditLog.logException("getClassification", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(classificationTypeName, entityTypeName), e.getMessage(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public EntityDetail getEntity(String guid) throws RepositoryErrorException, UserNotAuthorizedException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException {
        return this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", guid);
    }
}

