/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.contentmanager;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.EntitiesCreatorHelper;
import org.odpi.openmetadata.accessservices.informationview.events.ConnectionDetails;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseColumnReference;
import org.odpi.openmetadata.accessservices.informationview.events.ReportColumn;
import org.odpi.openmetadata.accessservices.informationview.events.ReportRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportCreator {
    private static final Logger log = LoggerFactory.getLogger(ReportCreator.class);
    private EntitiesCreatorHelper entitiesCreatorHelper;

    public ReportCreator(EntitiesCreatorHelper entitiesCreatorHelper) {
        this.entitiesCreatorHelper = entitiesCreatorHelper;
    }

    public void createReportModel(ReportRequestBody payload) {
        try {
            log.info("Creating report based on payload {}", (Object)payload);
            URL url = new URL(payload.getReportUrl());
            String networkAddress = url.getHost();
            if (url.getPort() > 0) {
                networkAddress = networkAddress + ":" + url.getPort();
            }
            String qualifiedNameForEndpoint = networkAddress;
            InstanceProperties endpointProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForEndpoint).withStringProperty("name", qualifiedNameForEndpoint).withStringProperty("networkAddress", networkAddress).withStringProperty("protocol", url.getProtocol()).build();
            EntityDetail endpointEntity = this.entitiesCreatorHelper.addEntity("Endpoint", qualifiedNameForEndpoint, endpointProperties);
            String qualifiedNameForConnection = qualifiedNameForEndpoint + ".Connection";
            InstanceProperties connectionProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForConnection).withStringProperty("description", "Connection to " + qualifiedNameForConnection).build();
            EntityDetail connectionEntity = this.entitiesCreatorHelper.addEntity("Connection", qualifiedNameForConnection, connectionProperties);
            this.entitiesCreatorHelper.addRelationship("ConnectionEndpoint", endpointEntity.getGUID(), connectionEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
            String qualifiedNameForReport = networkAddress + "." + payload.getId();
            InstanceProperties reportProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForReport).withStringProperty("name", payload.getReportName()).withStringProperty("author", payload.getAuthor()).withStringProperty("id", payload.getId()).withStringProperty("url", payload.getReportUrl()).withStringProperty("lastModifiedTime", payload.getLastModifiedTime()).withStringProperty("lastModifier", payload.getLastModifier()).withStringProperty("createdTime", payload.getCreatedTime()).build();
            EntityDetail report = this.entitiesCreatorHelper.addEntity("DeployedReport", qualifiedNameForReport, reportProperties, null);
            this.entitiesCreatorHelper.addRelationship("ConnectionToAsset", connectionEntity.getGUID(), report.getGUID(), "InformationViewOmas", new InstanceProperties());
            String qualifiedNameForComplexSchemaType = qualifiedNameForReport + "_type";
            InstanceProperties complexSchemaTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForComplexSchemaType).build();
            EntityDetail complexSchemaType = this.entitiesCreatorHelper.addEntity("ComplexSchemaType", qualifiedNameForComplexSchemaType, complexSchemaTypeProperties, null);
            this.entitiesCreatorHelper.addRelationship("AssetSchemaType", report.getGUID(), complexSchemaType.getGUID(), "InformationViewOmas", new InstanceProperties());
            this.addTables(qualifiedNameForComplexSchemaType, complexSchemaType, payload);
        }
        catch (Exception e) {
            log.error("Exception processing event REST call", (Throwable)e);
            InformationViewErrorCode informationViewErrorCode = InformationViewErrorCode.PROCESS_EVENT_EXCEPTION;
        }
    }

    private void addTables(String qualifiedNameForComplexSchemaType, EntityDetail complexSchemaType, ReportRequestBody payload) throws Exception {
        Set allSections = payload.getReportColumns().stream().map(e -> e.getSectionName()).collect(Collectors.toSet());
        for (String section : allSections) {
            String qualifiedNameForType = qualifiedNameForComplexSchemaType + "." + section + "_type";
            InstanceProperties typeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForType).build();
            EntityDetail typeEntity = this.entitiesCreatorHelper.addEntity("ComplexSchemaType", qualifiedNameForType, typeProperties);
            String qualifiedNameForTable = qualifiedNameForComplexSchemaType + "." + section;
            InstanceProperties tableProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForTable).withStringProperty("name", section).build();
            EntityDetail tableEntity = this.entitiesCreatorHelper.addEntity("SchemaAttribute", qualifiedNameForTable, tableProperties);
            this.entitiesCreatorHelper.addRelationship("SchemaAttributeType", tableEntity.getGUID(), typeEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
            this.entitiesCreatorHelper.addRelationship("AttributeForSchema", complexSchemaType.getGUID(), tableEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
            List<ReportColumn> reportColumnList = payload.getReportColumns().stream().filter(e -> e.getSectionName().equals(section)).collect(Collectors.toList());
            this.createDerivedRelationalColumn(typeEntity, qualifiedNameForTable, reportColumnList, payload.getSourceConnectionDetails(), payload.getSources());
        }
    }

    private void createDerivedRelationalColumn(EntityDetail parentEntity, String parentQualifiedName, List<ReportColumn> reportColumnList, ConnectionDetails sourceConnectionDetails, Map<String, Source> sources) throws Exception {
        for (ReportColumn reportColumn : reportColumnList) {
            EntityDetail realColumn = this.entitiesCreatorHelper.getEntity("RelationalColumn", this.getQualifiedNameForRealColumn(reportColumn.getRealColumn(), sourceConnectionDetails, sources));
            if (realColumn == null) continue;
            log.info("real database column found.");
            List<Relationship> relationships = this.entitiesCreatorHelper.getRelationships("SemanticAssignment", realColumn.getGUID());
            if (relationships == null || relationships.isEmpty()) continue;
            Relationship relationship = relationships.get(0);
            EntityProxy btProxy = realColumn.getGUID().equals(relationship.getEntityOneProxy().getGUID()) ? relationship.getEntityTwoProxy() : relationship.getEntityOneProxy();
            EntityDetail btEntity = this.entitiesCreatorHelper.getEntity(btProxy.getGUID());
            String businessTermNAme = EntityPropertiesUtils.getStringValueForProperty(btEntity.getProperties(), "displayName");
            log.info("business term name:[] " + businessTermNAme);
            String qualifiedNameForColumn = parentQualifiedName + "." + businessTermNAme;
            InstanceProperties columnProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForColumn).withStringProperty("name", businessTermNAme).withStringProperty("formula", reportColumn.getFormula()).build();
            EntityDetail derivedColumnEntity = this.entitiesCreatorHelper.addEntity("DerivedSchemaAttribute", qualifiedNameForColumn, columnProperties);
            this.entitiesCreatorHelper.addRelationship("AttributeForSchema", parentEntity.getGUID(), derivedColumnEntity.getGUID(), "InformationViewOmas", new InstanceProperties());
            InstanceProperties schemaQueryImplProperties = new EntityPropertiesBuilder().withStringProperty("query", "").build();
            this.entitiesCreatorHelper.addRelationship("SchemaQueryImplementation", derivedColumnEntity.getGUID(), realColumn.getGUID(), "InformationViewOmas", schemaQueryImplProperties);
            this.entitiesCreatorHelper.addRelationship("SemanticAssignment", derivedColumnEntity.getGUID(), btProxy.getGUID(), "InformationViewOmas", new InstanceProperties());
        }
    }

    private String getQualifiedNameForRealColumn(DatabaseColumnReference realColumn, ConnectionDetails sourceConnectionDetails, Map<String, Source> sources) {
        Source source = sources.get(realColumn.getSourceId());
        String qualifiedName = sourceConnectionDetails.getNetworkAddress() + ".Connection." + source.getDatabaseName() + "." + source.getSchemaName() + "." + source.getTableName() + ".";
        qualifiedName = qualifiedName + realColumn.getName();
        return qualifiedName;
    }
}

