/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.listeners;

import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationViewEnterpriseOmrsEventListener
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(InformationViewEnterpriseOmrsEventListener.class);
    private OMRSInstanceEventProcessor instanceEventProcessor;
    private OMRSAuditLog auditLog;

    public InformationViewEnterpriseOmrsEventListener(OMRSInstanceEventProcessor instanceEventProcessor, OMRSAuditLog auditLog) {
        this.instanceEventProcessor = instanceEventProcessor;
        this.auditLog = auditLog;
    }

    public void processEvent(OMRSEventV1 event) {
        String actionDescription = "Process Incoming Event";
        if (event != null) {
            switch (event.getEventCategory()) {
                case INSTANCE: {
                    this.processInstanceEvent(new OMRSInstanceEvent(event));
                    break;
                }
                default: {
                    log.debug("This event should not be handled by iv omas: " + event.getEventCategory());
                    break;
                }
            }
        } else {
            OMRSAuditCode auditCode = OMRSAuditCode.NULL_OMRS_EVENT_RECEIVED;
            this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            log.debug("Null OMRS Event received ");
        }
    }

    public void processRegistryEvent(OMRSRegistryEvent event) {
    }

    public void processTypeDefEvent(OMRSTypeDefEvent event) {
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event", (Object)instanceEvent);
        if (instanceEvent == null) {
            log.debug("Null instance event - ignoring event");
        } else {
            OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
            OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
            if (instanceEventType != null && instanceEventOriginator != null) {
                switch (instanceEventType) {
                    case NEW_RELATIONSHIP_EVENT: {
                        this.instanceEventProcessor.processNewRelationshipEvent("EnterpriseOMRSTopic", instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    }
                }
            } else {
                log.debug("Ignored instance event - null type");
            }
        }
    }
}

