/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class EntityLookup<T extends Source> {
    private static final Integer PAGE_SIZE = 0;
    private static final Logger log = LoggerFactory.getLogger(EntityLookup.class);
    protected OMRSRepositoryConnector enterpriseConnector;
    protected OMEntityDao omEntityDao;
    protected OMRSAuditLog auditLog;
    protected EntityLookup parentChain;
    protected String equivalentOMType;

    public EntityLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog, String equivalentOMType) {
        this.enterpriseConnector = enterpriseConnector;
        this.omEntityDao = omEntityDao;
        this.auditLog = auditLog;
        this.parentChain = parentChain;
        this.equivalentOMType = equivalentOMType;
    }

    public void setParentChain(EntityLookup parentChain) {
        this.parentChain = parentChain;
    }

    public EntityDetail lookupEntity(T source) {
        if (!StringUtils.isEmpty((Object)source.getGuid())) {
            return this.omEntityDao.getEntityByGuid(source.getGuid());
        }
        if (!StringUtils.isEmpty((Object)source.getQualifiedName())) {
            String sourceQualifiedNameRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getQualifiedName());
            return this.omEntityDao.getEntity(this.equivalentOMType, sourceQualifiedNameRegex, false);
        }
        return null;
    }

    public EntityDetail filterEntities(List<String> typeNames, T source, List<EntityDetail> list) {
        List<EntityDetail> filteredList = list.stream().filter(e -> this.isTypeOf(typeNames, (EntityDetail)e)).collect(Collectors.toList());
        InstanceProperties matchProperties = this.getMatchingProperties(source);
        return this.matchExactlyToUniqueEntity(filteredList, matchProperties);
    }

    private boolean isTypeOf(List<String> typeNames, EntityDetail e) {
        return typeNames.stream().anyMatch(type -> this.enterpriseConnector.getRepositoryHelper().isTypeOf("lookupEntity", e.getType().getTypeDefName(), type));
    }

    protected abstract InstanceProperties getMatchingProperties(T var1);

    public EntityDetail findEntity(InstanceProperties matchProperties, String typeDefName) {
        return this.matchExactlyToUniqueEntity(this.omEntityDao.findEntities(matchProperties, typeDefName, 0, PAGE_SIZE), matchProperties);
    }

    public EntityDetail matchExactlyToUniqueEntity(List<EntityDetail> entities, InstanceProperties matchingProperties) {
        if (!CollectionUtils.isEmpty(entities)) {
            List filteredEntities = entities.stream().filter(e -> this.matchProperties((EntityDetail)e, matchingProperties)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filteredEntities)) {
                throw ExceptionHandler.buildNoMatchingEntityException(matchingProperties, null, this.getClass().getName());
            }
            if (filteredEntities.size() > 1) {
                throw ExceptionHandler.buildMultipleEntitiesMatchingException(matchingProperties, null, this.getClass().getName());
            }
            return (EntityDetail)filteredEntities.get(0);
        }
        throw ExceptionHandler.buildNoMatchingEntityException(matchingProperties, null, this.getClass().getName());
    }

    public boolean matchProperties(EntityDetail entityDetail, InstanceProperties matchingProperties) {
        InstanceProperties entityProperties = entityDetail.getProperties();
        for (Map.Entry property : matchingProperties.getInstanceProperties().entrySet()) {
            String actualValue = this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", (String)property.getKey(), entityProperties, "matchProperties");
            String matchStringValue = (String)((PrimitivePropertyValue)property.getValue()).getPrimitiveValue();
            String literalMatchValue = this.enterpriseConnector.getRepositoryHelper().getUnqualifiedLiteralString(matchStringValue);
            if (literalMatchValue.equals(actualValue)) continue;
            return false;
        }
        return true;
    }
}

