/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.ReportColumnSource;
import org.odpi.openmetadata.accessservices.informationview.events.ReportSectionSource;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupStrategy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LookupBasedOnReportColumn
implements LookupStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReportColumnSource.class);
    public static final String SEPARATOR = "::";
    private OMEntityDao omEntityDao;

    public LookupBasedOnReportColumn(OMEntityDao omEntityDao) {
        this.omEntityDao = omEntityDao;
    }

    @Override
    public EntityDetail lookup(Source source) {
        if (!(source instanceof ReportColumnSource)) {
            log.error("Source is not a ReportColumnSource");
            return null;
        }
        String qualifiedName = !StringUtils.isEmpty((Object)source.getQualifiedName()) ? this.buildQualifiedName((ReportColumnSource)source) : source.getQualifiedName();
        return this.omEntityDao.getEntity("DerivedSchemaAttribute", qualifiedName, false);
    }

    private String buildQualifiedName(ReportColumnSource source) {
        StringBuilder builder = new StringBuilder();
        for (ReportSectionSource parentReportSection = source.getParentReportSection(); parentReportSection != null; parentReportSection = parentReportSection.getParentReportSection()) {
            builder.insert(0, parentReportSection.getName() + SEPARATOR);
            if (parentReportSection.getParentReportSection() != null) continue;
            builder.insert(0, parentReportSection.getReportSource().getEndpointSource().getNetworkAddress() + SEPARATOR + parentReportSection.getReportSource().getReportId() + SEPARATOR);
        }
        builder.append(source.getName());
        return builder.toString();
    }
}

