/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import java.util.List;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewColumn;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewElement;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewModel;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.BasicOperation;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataViewBasicOperation
extends BasicOperation {
    private static final Logger log = LoggerFactory.getLogger(DataViewBasicOperation.class);

    protected DataViewBasicOperation(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper helper, OMRSAuditLog auditLog) {
        super(omEntityDao, lookupHelper, helper, auditLog);
    }

    protected void addElements(String userId, String parentQualifiedName, String parentGuid, String registrationGuid, String registrationQualifiedName, List<DataViewElement> dataViewElements) {
        if (dataViewElements == null || dataViewElements.isEmpty()) {
            return;
        }
        dataViewElements.parallelStream().forEach(e -> this.addDataViewElement(userId, parentQualifiedName, parentGuid, registrationGuid, registrationQualifiedName, (DataViewElement)e));
    }

    public void addDataViewElement(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, DataViewElement element) {
        if (element instanceof DataViewModel) {
            this.addDataViewModel(userId, qualifiedNameForParent, registrationGuid, registrationQualifiedName, parentGuid, (DataViewModel)element);
        } else if (element instanceof DataViewColumn) {
            this.addDataViewColumn(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, (DataViewColumn)element);
        }
    }

    private void addDataViewModel(String userId, String qualifiedNameForParent, String registrationGuid, String registrationQualifiedName, String parentGuid, DataViewModel DataViewModel2) {
        String qualifiedNameForDataViewModel = QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, "SchemaAttribute", DataViewModel2.getId());
        InstanceProperties sectionProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForDataViewModel).withStringProperty("name", DataViewModel2.getName()).withStringProperty("id", DataViewModel2.getId()).withStringProperty("comment", DataViewModel2.getComment()).withStringProperty("nativeClass", DataViewModel2.getNativeClass()).withStringProperty("description", DataViewModel2.getDescription()).build();
        EntityDetail DataViewModelEntity = this.createSchemaType(userId, "SchemaAttribute", qualifiedNameForDataViewModel, registrationGuid, registrationQualifiedName, sectionProperties, "AttributeForSchema", parentGuid);
        String qualifiedNameForDataViewModelType = QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, "ComplexSchemaType", DataViewModel2.getId() + "_type");
        EntityDetail schemaTypeEntity = this.addSchemaType(userId, qualifiedNameForDataViewModelType, registrationGuid, registrationQualifiedName, DataViewModelEntity.getGUID(), "ComplexSchemaType", null);
        this.addElements(userId, qualifiedNameForParent, schemaTypeEntity.getGUID(), registrationGuid, registrationQualifiedName, DataViewModel2.getElements());
    }

    protected EntityDetail addDataViewColumn(String userId, String parentQualifiedName, String parentGuid, String registrationGuid, String registrationQualifiedName, DataViewColumn dataViewColumn) {
        String qualifiedNameForColumn = QualifiedNameUtils.buildQualifiedName(parentQualifiedName, "DerivedSchemaAttribute", dataViewColumn.getId());
        InstanceProperties columnProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForColumn).withStringProperty("name", dataViewColumn.getName()).withStringProperty("description", dataViewColumn.getDescription()).withStringProperty("comment", dataViewColumn.getComment()).withStringProperty("formula", dataViewColumn.getExpression()).withStringProperty("id", dataViewColumn.getId()).withStringProperty("nativeClass", dataViewColumn.getNativeClass()).withStringProperty("aggregatingFunction", dataViewColumn.getRegularAggregate()).build();
        EntityDetail dataViewColumnEntity = this.createSchemaType(userId, "DerivedSchemaAttribute", qualifiedNameForColumn, registrationGuid, registrationQualifiedName, columnProperties, "AttributeForSchema", parentGuid);
        this.addSemanticAssignments(userId, registrationGuid, registrationQualifiedName, dataViewColumn.getBusinessTerms(), dataViewColumnEntity);
        this.addQueryTargets(userId, registrationGuid, registrationQualifiedName, dataViewColumn.getSources(), dataViewColumnEntity);
        InstanceProperties typeProperties = new EntityPropertiesBuilder().withStringProperty("dataType", dataViewColumn.getDataType()).build();
        String qualifiedNameForColumnType = QualifiedNameUtils.buildQualifiedName(parentQualifiedName, "PrimitiveSchemaType", dataViewColumn.getId() + "_type");
        this.addSchemaType(userId, qualifiedNameForColumnType, registrationGuid, registrationQualifiedName, dataViewColumnEntity.getGUID(), "PrimitiveSchemaType", typeProperties);
        return dataViewColumnEntity;
    }
}

