/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.informationview.events.ReportRequestBody;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportBasicOperation;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportCreator
extends ReportBasicOperation {
    private static final Logger log = LoggerFactory.getLogger(ReportCreator.class);

    public ReportCreator(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper helper, OMRSAuditLog auditLog) {
        super(omEntityDao, lookupHelper, helper, auditLog);
    }

    public void createReport(String userId, ReportRequestBody payload, EntityDetail reportEntity) {
        String qualifiedNameForComplexSchemaType = QualifiedNameUtils.buildQualifiedName("", "AssetSchemaType", payload.getReport().getId() + "_type");
        InstanceProperties complexSchemaTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForComplexSchemaType).build();
        OMEntityWrapper complexSchemaTypeEntityWrapper = this.omEntityDao.createOrUpdateExternalEntity(userId, "ComplexSchemaType", qualifiedNameForComplexSchemaType, payload.getRegistrationGuid(), payload.getRegistrationQualifiedName(), complexSchemaTypeProperties, null, true, false);
        log.debug("Created report schema type {}", (Object)complexSchemaTypeEntityWrapper.getEntityDetail().getGUID());
        this.omEntityDao.addExternalRelationship(userId, "AssetSchemaType", payload.getRegistrationGuid(), payload.getRegistrationQualifiedName(), reportEntity.getGUID(), complexSchemaTypeEntityWrapper.getEntityDetail().getGUID(), new InstanceProperties());
        this.addElements(userId, this.helper.getStringProperty("InformationViewOmas", "qualifiedName", reportEntity.getProperties(), "createReport"), complexSchemaTypeEntityWrapper.getEntityDetail().getGUID(), payload.getRegistrationGuid(), payload.getRegistrationQualifiedName(), payload.getReport().getReportElements());
    }
}

