/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.informationview.events.ReportRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.SoftwareServerCapabilitySource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.ReportSubmitException;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportCreator;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportUpdater;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportHandler {
    private static final Logger log = LoggerFactory.getLogger(ReportHandler.class);
    private ReportCreator reportCreator;
    private ReportUpdater reportUpdater;
    private OMEntityDao omEntityDao;
    private OMRSAuditLog auditLog;

    public ReportHandler(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper repositoryHelper, OMRSAuditLog auditLog) {
        this.reportCreator = new ReportCreator(omEntityDao, lookupHelper, repositoryHelper, auditLog);
        this.reportUpdater = new ReportUpdater(omEntityDao, lookupHelper, repositoryHelper, auditLog);
        this.omEntityDao = omEntityDao;
        this.auditLog = auditLog;
    }

    public void submitReportModel(String userId, ReportRequestBody payload) throws ReportSubmitException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Creating report based on payload {}", (Object)payload);
            }
            SoftwareServerCapabilitySource softwareServerCapabilitySource = this.reportCreator.retrieveSoftwareServerCapability(payload.getRegistrationGuid(), payload.getRegistrationQualifiedName());
            payload.setRegistrationGuid(softwareServerCapabilitySource.getGuid());
            payload.setRegistrationQualifiedName(softwareServerCapabilitySource.getQualifiedName());
            String qualifiedNameForReport = QualifiedNameUtils.buildQualifiedName("", "DeployedReport", payload.getRegistrationQualifiedName() + "::" + payload.getReport().getId());
            InstanceProperties reportProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForReport).withStringProperty("name", payload.getReport().getReportName()).withStringProperty("author", payload.getReport().getAuthor()).withStringProperty("id", payload.getReport().getId()).withStringProperty("url", payload.getReport().getReportUrl()).withStringProperty("lastModifier", payload.getReport().getLastModifier()).withDateProperty("lastModifiedTime", payload.getReport().getLastModifiedTime()).withDateProperty("createdTime", payload.getReport().getCreatedTime()).build();
            OMEntityWrapper reportWrapper = this.omEntityDao.createOrUpdateExternalEntity(userId, "DeployedReport", qualifiedNameForReport, payload.getRegistrationGuid(), payload.getRegistrationQualifiedName(), reportProperties, null, true, true);
            if (reportWrapper.getEntityStatus().equals((Object)OMEntityWrapper.EntityStatus.NEW)) {
                this.reportCreator.createReport(userId, payload, reportWrapper.getEntityDetail());
            } else {
                this.reportUpdater.updateReport(userId, payload, payload.getRegistrationGuid(), payload.getRegistrationQualifiedName(), reportWrapper.getEntityDetail());
            }
        }
        catch (EntityNotDeletedException | EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            throw new ReportSubmitException(500, ReportHandler.class.getName(), InformationViewErrorCode.REPORT_SUBMIT_EXCEPTION.getFormattedErrorMessage(e.getMessage()), InformationViewErrorCode.REPORT_SUBMIT_EXCEPTION.getUserAction(), InformationViewErrorCode.REPORT_SUBMIT_EXCEPTION.getSystemAction(), e, payload.getReport().getReportName());
        }
    }
}

