/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.admin;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.informationview.auditlog.InformationViewAuditCode;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.context.ContextBuilders;
import org.odpi.openmetadata.accessservices.informationview.eventprocessor.EventPublisher;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.listeners.InformationViewEnterpriseOmrsEventListener;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.registration.RegistrationHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.DataViewHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportHandler;
import org.odpi.openmetadata.accessservices.informationview.server.InformationViewServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationViewAdmin
extends AccessServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(InformationViewAdmin.class);
    private OpenMetadataTopicConnector informationViewOutTopicConnector;
    private OMRSAuditLog auditLog;
    private String serverName = null;
    private InformationViewServicesInstance instance = null;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        InformationViewAuditCode auditCode = InformationViewAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.auditLog = auditLog;
        if (enterpriseConnector != null) {
            this.serverName = enterpriseConnector.getServerName();
        }
        String outTopicName = this.getTopicName(accessServiceConfigurationProperties.getAccessServiceOutTopic());
        this.informationViewOutTopicConnector = this.initializeInformationViewTopicConnector(accessServiceConfigurationProperties.getAccessServiceOutTopic());
        List<String> supportedZones = this.extractSupportedZones(accessServiceConfigurationProperties.getAccessServiceOptions());
        OMEntityDao omEntityDao = new OMEntityDao(enterpriseConnector, supportedZones, auditLog);
        EventPublisher eventPublisher = null;
        if (enterpriseOMRSTopicConnector != null) {
            auditCode = InformationViewAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            eventPublisher = new EventPublisher(this.informationViewOutTopicConnector, enterpriseConnector, supportedZones, auditLog);
            InformationViewEnterpriseOmrsEventListener informationViewEnterpriseOmrsEventListener = new InformationViewEnterpriseOmrsEventListener(eventPublisher, auditLog);
            enterpriseOMRSTopicConnector.registerListener((OMRSTopicListener)informationViewEnterpriseOmrsEventListener, accessServiceConfigurationProperties.getAccessServiceName());
        }
        if (this.informationViewOutTopicConnector != null) {
            this.startConnector(InformationViewAuditCode.SERVICE_REGISTERED_WITH_IV_OUT_TOPIC, "initialize", outTopicName, this.informationViewOutTopicConnector);
        }
        LookupHelper lookupHelper = new LookupHelper(enterpriseConnector, omEntityDao, auditLog);
        DataViewHandler dataViewHandler = new DataViewHandler(omEntityDao, lookupHelper, enterpriseConnector.getRepositoryHelper(), auditLog);
        ReportHandler reportHandler = new ReportHandler(omEntityDao, lookupHelper, enterpriseConnector.getRepositoryHelper(), auditLog);
        RegistrationHandler registrationHandler = new RegistrationHandler(omEntityDao, enterpriseConnector, auditLog);
        ContextBuilders contextBuilders = new ContextBuilders(enterpriseConnector, omEntityDao, auditLog);
        this.instance = new InformationViewServicesInstance(reportHandler, dataViewHandler, registrationHandler, contextBuilders, this.serverName);
        auditCode = InformationViewAuditCode.SERVICE_INITIALIZED;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), accessServiceConfigurationProperties.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
    }

    private void startConnector(InformationViewAuditCode auditCode, String actionDescription, String topicName, OpenMetadataTopicConnector topicConnector) throws OMAGConfigurationErrorException {
        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            topicConnector.start();
        }
        catch (ConnectorCheckedException e) {
            auditCode = InformationViewAuditCode.ERROR_INITIALIZING_INFORMATION_VIEW_TOPIC_CONNECTION;
            this.auditLog.logException(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicName, this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
            throw new OMAGConfigurationErrorException(400, InformationViewAdmin.class.getSimpleName(), actionDescription, auditCode.getFormattedLogMessage(new String[0]), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
        }
    }

    private OpenMetadataTopicConnector initializeInformationViewTopicConnector(Connection topicConnection) {
        String actionDescription = "initialize";
        if (topicConnection != null) {
            try {
                return this.getTopicConnector(topicConnection);
            }
            catch (Exception e) {
                InformationViewAuditCode auditCode = InformationViewAuditCode.ERROR_INITIALIZING_CONNECTION;
                this.auditLog.logException("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(topicConnection.toString(), this.serverName, e.getMessage()), topicConnection.toString(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    private OpenMetadataTopicConnector getTopicConnector(Connection topicConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connectorBroker.getConnector(topicConnection);
            topicConnector.setAuditLog(this.auditLog.createNewAuditLog(OMRSAuditingComponent.OPEN_METADATA_TOPIC_CONNECTOR));
            return topicConnector;
        }
        catch (Throwable error) {
            String methodName = "getTopicConnector";
            if (log.isDebugEnabled()) {
                log.debug("Unable to create topic connector: " + error.toString());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getTopicConnector"});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private List<String> extractSupportedZones(Map<String, Object> accessServiceOptions) throws OMAGConfigurationErrorException {
        String methodName = "extractSupportedZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get(this.supportedZonesPropertyName);
        if (zoneListObject == null) {
            InformationViewAuditCode auditCode = InformationViewAuditCode.ALL_ZONES;
            this.auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            InformationViewAuditCode auditCode = InformationViewAuditCode.SUPPORTED_ZONES;
            this.auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(zoneList.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return zoneList;
        }
        catch (Throwable error) {
            InformationViewAuditCode auditCode = InformationViewAuditCode.BAD_CONFIG;
            this.auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(zoneListObject.toString(), this.supportedZonesPropertyName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            InformationViewErrorCode errorCode = InformationViewErrorCode.BAD_CONFIG;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(zoneListObject.toString(), this.supportedZonesPropertyName, error.getClass().getName(), error.getMessage());
            throw new OMAGConfigurationErrorException(errorCode.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), "extractSupportedZones", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public void shutdown() {
        try {
            this.informationViewOutTopicConnector.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Error disconnecting information view topic connector");
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        String actionDescription = "shutdown";
        InformationViewAuditCode auditCode = InformationViewAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

