/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.eventprocessor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.odpi.openmetadata.accessservices.informationview.context.ColumnContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.events.InformationViewHeader;
import org.odpi.openmetadata.accessservices.informationview.events.SemanticAssignment;
import org.odpi.openmetadata.accessservices.informationview.events.TableColumn;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.accessservices.informationview.events.UpdatedEntityEvent;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.InformationViewExceptionBase;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopic;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPublisher
extends OMRSInstanceEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(EventPublisher.class);
    private static final String eventPublisherName = "Information View OMAS Event Publisher";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private OpenMetadataTopic informationViewOutTopicConnector;
    private OMRSRepositoryConnector enterpriseConnector;
    private ColumnContextBuilder columnContextBuilder;
    private OMRSRepositoryHelper helper;
    private OMRSAuditLog auditLog;
    private List<String> zones;

    public EventPublisher(OpenMetadataTopicConnector informationViewOutTopicConnector, OMRSRepositoryConnector enterpriseConnector, List<String> zones, OMRSAuditLog auditLog) {
        super(eventPublisherName);
        this.columnContextBuilder = new ColumnContextBuilder(enterpriseConnector);
        this.informationViewOutTopicConnector = informationViewOutTopicConnector;
        this.enterpriseConnector = enterpriseConnector;
        this.helper = enterpriseConnector.getRepositoryHelper();
        this.zones = zones;
        this.auditLog = auditLog;
    }

    public void sendInstanceEvent(String sourceName, OMRSInstanceEvent instanceEvent) {
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail entity) {
        UpdatedEntityEvent updatedEntityEvent = new UpdatedEntityEvent();
        updatedEntityEvent.setNewProperties(entity.getProperties());
        if (oldEntity != null) {
            updatedEntityEvent.setOldProperties(oldEntity.getProperties());
        }
        updatedEntityEvent.setType(entity.getType());
        updatedEntityEvent.setGuid(entity.getGUID());
        this.sendEvent((InformationViewHeader)updatedEntityEvent);
        if (entity.getType().getTypeDefName().equals("GlossaryTerm") && this.isRename(oldEntity, entity)) {
            log.info("Glossary term name was updated");
            String glossaryTermGuid = entity.getGUID();
            try {
                List<EntitySummary> assignedColumns = this.columnContextBuilder.getAssignedColumns(glossaryTermGuid);
                if (assignedColumns != null && !assignedColumns.isEmpty()) {
                    assignedColumns.parallelStream().forEach(s -> this.publishColumnContextEvent(s.getGUID()));
                }
            }
            catch (InformationViewExceptionBase e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isRename(EntityDetail oldEntity, EntityDetail entity) {
        if (oldEntity != null && entity != null) {
            String oldName = this.helper.getStringProperty("InformationViewOmas", "displayName", oldEntity.getProperties(), "isRename");
            String newName = this.helper.getStringProperty("InformationViewOmas", "displayName", entity.getProperties(), "isRename");
            return !newName.equals(oldName);
        }
        return false;
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDef, EntityDetail entity) {
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
    }

    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (!relationship.getType().getTypeDefName().equals("SemanticAssignment") || !relationship.getEntityOneProxy().getType().getTypeDefName().equals("RelationalColumn")) {
            log.info("Event is ignored as the relationship is not a semantic assignment for a column");
        } else {
            log.info("Processing semantic assignment relationship event for a column");
            try {
                this.publishSemanticAssignment(relationship);
            }
            catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
                log.error("Exception building events", e);
                InformationViewErrorCode auditCode = InformationViewErrorCode.PUBLISH_EVENT_EXCEPTION;
                this.auditLog.logException("processNewRelationshipEvent", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(SemanticAssignment.class.getName(), e.getMessage()), e.getMessage(), auditCode.getSystemAction(), auditCode.getUserAction(), e);
            }
            this.publishColumnContextEvent(relationship.getEntityOneProxy().getGUID());
        }
    }

    private void publishColumnContextEvent(String guid) {
        List<TableContextEvent> events = null;
        try {
            events = this.columnContextBuilder.buildContexts(guid);
            this.sendColumnContextEvents(events);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void publishSemanticAssignment(Relationship relationship) throws RepositoryErrorException, UserNotAuthorizedException, EntityProxyOnlyException, InvalidParameterException, EntityNotKnownException {
        SemanticAssignment semanticAssignment = new SemanticAssignment();
        EntityDetail businessTerm = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", relationship.getEntityTwoProxy().getGUID());
        semanticAssignment.setBusinessTerm(this.columnContextBuilder.buildBusinessTerm(businessTerm));
        TableColumn databaseColumn = new TableColumn();
        EntityDetail columnEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", relationship.getEntityOneProxy().getGUID());
        databaseColumn.setGuid(columnEntity.getGUID());
        databaseColumn.setName(this.helper.getStringProperty("InformationViewOmas", "name", columnEntity.getProperties(), "publishSemanticAssignment"));
        databaseColumn.setQualifiedName(this.helper.getStringProperty("InformationViewOmas", "qualifiedName", columnEntity.getProperties(), "publishSemanticAssignment"));
        semanticAssignment.setTableColumn(databaseColumn);
        this.sendEvent((InformationViewHeader)semanticAssignment);
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship, Relationship oldRelationship) {
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (!relationship.getType().getTypeDefName().equals("SemanticAssignment") || !relationship.getEntityOneProxy().getType().getTypeDefName().equals("RelationalColumn")) {
            log.info("Event is ignored as the relationship is not a delete of semantic assignment for a column");
        } else {
            log.info("Processing delete of semantic assignment for a column");
            this.publishColumnContextEvent(relationship.getEntityOneProxy().getGUID());
        }
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        if (!relationship.getType().getTypeDefName().equals("SemanticAssignment") || !relationship.getEntityOneProxy().getType().getTypeDefName().equals("RelationalColumn")) {
            log.info("Event is ignored as the relationship is not a delete-purge of semantic assignment for a column");
        } else {
            log.info("Processing delete-purge of semantic assignment for a column");
            this.publishColumnContextEvent(relationship.getEntityOneProxy().getGUID());
        }
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDef, Relationship relationship) {
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, Relationship relationship) {
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
    }

    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
    }

    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDef, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDef, String otherInstanceGUID, String errorMessage) {
    }

    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDef, String targetInstanceGUID, TypeDefSummary otherTypeDef, String errorMessage) {
    }

    private boolean sendColumnContextEvents(List<TableContextEvent> eventList) {
        boolean allSuccessful = true;
        for (TableContextEvent event : eventList) {
            if (this.sendEvent((InformationViewHeader)event)) continue;
            allSuccessful = false;
        }
        return allSuccessful;
    }

    public boolean sendEvent(InformationViewHeader event) {
        String actionDescription = "Send New Event";
        boolean successFlag = false;
        log.info("Sending event {} to information view out topic", event.getClass());
        if (log.isDebugEnabled()) {
            log.debug("event: ", (Object)event);
        }
        try {
            this.informationViewOutTopicConnector.sendEvent(OBJECT_MAPPER.writeValueAsString((Object)event));
            successFlag = true;
        }
        catch (Throwable error) {
            log.error("Exception publishing event", error);
            InformationViewErrorCode auditCode = InformationViewErrorCode.PUBLISH_EVENT_EXCEPTION;
            this.auditLog.logException(actionDescription, auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(event.getClass().getName(), error.getMessage()), "event {" + event.toString() + "}", auditCode.getSystemAction(), auditCode.getUserAction(), error);
        }
        return successFlag;
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
    }
}

