/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.SoftwareServerCapabilitySource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.EndpointLookup;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftwareServerCapabilityLookup
extends EntityLookup<SoftwareServerCapabilitySource> {
    private static final Logger log = LoggerFactory.getLogger(EndpointLookup.class);

    public SoftwareServerCapabilityLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, parentChain, auditLog, "SoftwareServerCapability");
    }

    @Override
    public EntityDetail lookupEntity(SoftwareServerCapabilitySource source) {
        EntityDetail entity = Optional.ofNullable(super.lookupEntity(source)).orElseThrow(() -> ExceptionHandler.buildEntityNotFoundException("qualifiedName", source.getQualifiedName(), "SoftwareServerCapability", SoftwareServerCapabilityLookup.class.getName()));
        if (log.isDebugEnabled()) {
            log.debug("SoftwareServerCapability found [{}]", (Object)entity);
        }
        return entity;
    }

    @Override
    protected InstanceProperties getMatchingProperties(SoftwareServerCapabilitySource softwareServerCapabilitySource) {
        InstanceProperties matchProperties = new InstanceProperties();
        String softwareServerCapabilitySourceQualifiedNameRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(softwareServerCapabilitySource.getQualifiedName());
        matchProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("InformationViewOmas", matchProperties, "qualifiedName", softwareServerCapabilitySourceQualifiedNameRegex, "getMatchingProperties");
        return matchProperties;
    }
}

