/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.registration;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.informationview.events.RegistrationRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.SoftwareServerCapabilitySource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.RegistrationException;
import org.odpi.openmetadata.accessservices.informationview.lookup.SoftwareServerCapabilityLookup;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RegistrationHandler {
    private static final Logger log = LoggerFactory.getLogger(RegistrationHandler.class);
    private OMEntityDao omEntityDao;
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSAuditLog auditLog;
    private SoftwareServerCapabilityLookup lookup;

    public RegistrationHandler(OMEntityDao omEntityDao, OMRSRepositoryConnector enterpriseConnector, OMRSAuditLog auditLog) {
        this.omEntityDao = omEntityDao;
        this.repositoryHelper = enterpriseConnector.getRepositoryHelper();
        this.auditLog = auditLog;
        this.lookup = new SoftwareServerCapabilityLookup(enterpriseConnector, omEntityDao, null, auditLog);
    }

    public SoftwareServerCapabilitySource registerTool(RegistrationRequestBody requestBody) {
        SoftwareServerCapabilitySource softwareServerCapability = requestBody.getSoftwareServerCapability();
        if (StringUtils.isEmpty((Object)softwareServerCapability.getQualifiedName())) {
            throw new RegistrationException(InformationViewErrorCode.REGISTRATION_EXCEPTION.getHttpErrorCode(), RegistrationHandler.class.getName(), InformationViewErrorCode.REGISTRATION_EXCEPTION.getFormattedErrorMessage("No qualified name was provided. This is mandatory."), InformationViewErrorCode.REGISTRATION_EXCEPTION.getSystemAction(), InformationViewErrorCode.REGISTRATION_EXCEPTION.getUserAction(), null);
        }
        String qualifiedNameForSoftwareServer = softwareServerCapability.getQualifiedName();
        InstanceProperties softwareServerProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForSoftwareServer).withStringProperty("patchLevel", softwareServerCapability.getPatchLevel()).withStringProperty("type", softwareServerCapability.getType()).withStringProperty("version", softwareServerCapability.getVersion()).withStringProperty("source", softwareServerCapability.getSource()).withStringProperty("name", softwareServerCapability.getName()).withStringProperty("description", softwareServerCapability.getDescription()).build();
        try {
            OMEntityWrapper registration = this.omEntityDao.createOrUpdateEntity("SoftwareServerCapability", qualifiedNameForSoftwareServer, softwareServerProperties, null, true, true);
            return this.buildSoftwareServerCapabilitySource(registration.getEntityDetail());
        }
        catch (ClassificationErrorException | EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            throw new RegistrationException(InformationViewErrorCode.REGISTRATION_EXCEPTION.getHttpErrorCode(), RegistrationHandler.class.getName(), InformationViewErrorCode.REGISTRATION_EXCEPTION.getFormattedErrorMessage(e.getMessage()), InformationViewErrorCode.REGISTRATION_EXCEPTION.getSystemAction(), InformationViewErrorCode.REGISTRATION_EXCEPTION.getUserAction(), null);
        }
    }

    public SoftwareServerCapabilitySource lookupSoftwareServerCapability(RegistrationRequestBody requestBody) {
        EntityDetail entity = Optional.ofNullable(this.lookup.lookupEntity(requestBody.getSoftwareServerCapability())).orElseThrow(() -> ExceptionHandler.buildEntityNotFoundException("source", requestBody.getSoftwareServerCapability().toString(), "SoftwareServerCapability", this.getClass().getName()));
        return this.buildSoftwareServerCapabilitySource(entity);
    }

    private SoftwareServerCapabilitySource buildSoftwareServerCapabilitySource(EntityDetail entity) {
        SoftwareServerCapabilitySource source = new SoftwareServerCapabilitySource();
        source.setName(this.repositoryHelper.getStringProperty("InformationViewOmas", "name", entity.getProperties(), ""));
        source.setQualifiedName(this.repositoryHelper.getStringProperty("InformationViewOmas", "qualifiedName", entity.getProperties(), ""));
        source.setVersion(this.repositoryHelper.getStringProperty("InformationViewOmas", "version", entity.getProperties(), ""));
        source.setPatchLevel(this.repositoryHelper.getStringProperty("InformationViewOmas", "patchLevel", entity.getProperties(), ""));
        source.setType(this.repositoryHelper.getStringProperty("InformationViewOmas", "type", entity.getProperties(), ""));
        source.setDescription(this.repositoryHelper.getStringProperty("InformationViewOmas", "description", entity.getProperties(), ""));
        source.setGuid(entity.getGUID());
        return source;
    }
}

