/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.assets;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.context.ColumnContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseSource;
import org.odpi.openmetadata.accessservices.informationview.events.TableColumn;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.accessservices.informationview.events.TableSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.ContextLoadException;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.EntityNotFoundException;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.IncorrectModelException;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.IncorrectTypeException;
import org.odpi.openmetadata.accessservices.informationview.utils.Constants;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseContextHandler {
    private static final Logger log = LoggerFactory.getLogger(DatabaseContextHandler.class);
    private OMEntityDao omEntityDao;
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSAuditLog auditLog;
    private ColumnContextBuilder columnContextBuilder;

    public DatabaseContextHandler(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, OMRSAuditLog auditLog) {
        this.omEntityDao = omEntityDao;
        this.repositoryHelper = enterpriseConnector.getRepositoryHelper();
        this.auditLog = auditLog;
        this.columnContextBuilder = new ColumnContextBuilder(enterpriseConnector);
    }

    public List<DatabaseSource> getDatabases(int startFrom, int pageSize) {
        InstanceProperties instanceProperties = this.omEntityDao.buildMatchingInstanceProperties(Collections.emptyMap(), true);
        List<EntityDetail> entities = this.omEntityDao.findEntities(instanceProperties, "Database", startFrom, pageSize);
        return this.buildDatabaseContext(entities);
    }

    public List<TableSource> getTables(String databaseGuid, int startFrom, int pageSize) {
        EntityDetail database = this.getEntity(databaseGuid, "DataStore");
        return this.columnContextBuilder.getTablesForDatabase(database.getGUID(), startFrom, pageSize);
    }

    public List<TableContextEvent> getTableContext(String tableGuid) {
        EntityDetail table = this.getEntity(tableGuid, "RelationalTable");
        List<Relationship> relationships = this.columnContextBuilder.getSchemaTypeRelationships(table, "SchemaAttributeType", 0, Constants.PAGE_SIZE);
        if (relationships != null && !relationships.isEmpty()) {
            return this.columnContextBuilder.getTableContext(relationships.get(0).getEntityTwoProxy().getGUID(), 0, Constants.PAGE_SIZE);
        }
        throw new ContextLoadException(InformationViewErrorCode.RETRIEVE_CONTEXT_EXCEPTION.getHttpErrorCode(), DatabaseContextHandler.class.getName(), InformationViewErrorCode.RETRIEVE_CONTEXT_EXCEPTION.getFormattedErrorMessage(tableGuid, "Schema attribute type relationship doesn't exist"), InformationViewErrorCode.RETRIEVE_CONTEXT_EXCEPTION.getSystemAction(), InformationViewErrorCode.RETRIEVE_CONTEXT_EXCEPTION.getUserAction(), null);
    }

    private List<DatabaseSource> buildDatabaseContext(List<EntityDetail> entities) {
        List<DatabaseSource> databaseSources = ((Stream)Optional.ofNullable(entities).map(Collection::stream).orElseGet(Stream::empty).parallel()).map(e -> {
            List<TableContextEvent> contexts = this.columnContextBuilder.getDatabaseContext(e.getGUID());
            if (!CollectionUtils.isEmpty(contexts)) {
                return contexts.get(0).getTableSource().getDatabaseSource();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return databaseSources;
    }

    public List<TableColumn> getTableColumns(String tableGuid, int startFrom, int pageSize) {
        EntityDetail table = this.getEntity(tableGuid, "RelationalTable");
        List<Relationship> relationships = this.columnContextBuilder.getSchemaTypeRelationships(table, "SchemaAttributeType", 0, Constants.PAGE_SIZE);
        if (relationships != null && !relationships.isEmpty()) {
            return this.columnContextBuilder.getTableColumns(relationships.get(0).getEntityTwoProxy().getGUID(), startFrom, pageSize);
        }
        throw new IncorrectModelException(DatabaseContextHandler.class.getName(), InformationViewErrorCode.INCORRECT_MODEL_EXCEPTION.getFormattedErrorMessage(tableGuid, "Table Schema Type is missing"), InformationViewErrorCode.INCORRECT_MODEL_EXCEPTION.getSystemAction(), InformationViewErrorCode.INCORRECT_MODEL_EXCEPTION.getUserAction(), null);
    }

    private EntityDetail getEntity(String guid, String typeName) {
        EntityDetail entityDetail = this.omEntityDao.getEntityByGuid(guid);
        if (entityDetail == null) {
            throw new EntityNotFoundException(InformationViewErrorCode.ENTITY_NOT_FOUND_EXCEPTION.getHttpErrorCode(), DatabaseContextHandler.class.getName(), InformationViewErrorCode.ENTITY_NOT_FOUND_EXCEPTION.getFormattedErrorMessage("guid", guid, typeName), InformationViewErrorCode.ENTITY_NOT_FOUND_EXCEPTION.getSystemAction(), InformationViewErrorCode.ENTITY_NOT_FOUND_EXCEPTION.getUserAction(), null);
        }
        if (!this.repositoryHelper.isTypeOf("lookupEntityByGuid", entityDetail.getType().getTypeDefName(), typeName)) {
            throw new IncorrectTypeException(InformationViewErrorCode.INCORRECT_TYPE_EXCEPTION.getHttpErrorCode(), DatabaseContextHandler.class.getName(), InformationViewErrorCode.INCORRECT_TYPE_EXCEPTION.getFormattedErrorMessage("guid", guid, typeName), InformationViewErrorCode.INCORRECT_TYPE_EXCEPTION.getSystemAction(), InformationViewErrorCode.INCORRECT_TYPE_EXCEPTION.getUserAction(), null);
        }
        return entityDetail;
    }
}

