/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewSource;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataViewLookup
extends EntityLookup<DataViewSource> {
    private static final Logger log = LoggerFactory.getLogger(DataViewLookup.class);

    public DataViewLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, parentChain, auditLog, "InformationView");
    }

    @Override
    public EntityDetail lookupEntity(DataViewSource source) {
        EntityDetail entity = Optional.ofNullable(super.lookupEntity(source)).orElseGet(() -> this.findEntity(this.getMatchingProperties(source), "InformationView"));
        if (log.isDebugEnabled()) {
            log.debug("DataView found [{}]", (Object)entity);
        }
        return entity;
    }

    @Override
    protected InstanceProperties getMatchingProperties(DataViewSource source) {
        InstanceProperties matchProperties = new InstanceProperties();
        String sourceIdRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getId());
        matchProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("InformationViewOmas", matchProperties, "id", sourceIdRegex, "getMatchingProperties");
        return matchProperties;
    }
}

