/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.EndpointSource;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EndpointLookup
extends EntityLookup<EndpointSource> {
    private static final Logger log = LoggerFactory.getLogger(EndpointLookup.class);

    public EndpointLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup chain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, chain, auditLog, "Endpoint");
    }

    @Override
    public EntityDetail lookupEntity(EndpointSource source) {
        EntityDetail entity = Optional.ofNullable(super.lookupEntity(source)).orElseGet(() -> this.findEndpoint(source));
        if (log.isDebugEnabled()) {
            log.debug("Endpoint found [{}]", (Object)entity);
        }
        return entity;
    }

    public EntityDetail findEndpoint(EndpointSource source) {
        return this.findEntity(this.getMatchingProperties(source), "Endpoint");
    }

    @Override
    protected InstanceProperties getMatchingProperties(EndpointSource source) {
        InstanceProperties matchProperties = new InstanceProperties();
        String sourceNetworkAddressRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getNetworkAddress());
        matchProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("InformationViewOmas", matchProperties, "networkAddress", sourceNetworkAddressRegex, "findEndpoint");
        if (!StringUtils.isEmpty((Object)source.getProtocol())) {
            String sourceProtocolRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getProtocol());
            matchProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("InformationViewOmas", matchProperties, "protocol", sourceProtocolRegex, "findEndpoint");
        }
        return matchProperties;
    }
}

