/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.TableSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.InformationViewExceptionBase;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TableLookup
extends EntityLookup<TableSource> {
    private static final Logger log = LoggerFactory.getLogger(TableLookup.class);

    public TableLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, parentChain, auditLog, "RelationalTable");
    }

    @Override
    public EntityDetail lookupEntity(TableSource source) {
        EntityDetail entity = Optional.ofNullable(super.lookupEntity(source)).orElseGet(() -> this.lookupStartingFromParent(source));
        if (log.isDebugEnabled()) {
            log.debug("Table found [{}]", (Object)entity);
        }
        return entity;
    }

    public EntityDetail lookupStartingFromParent(TableSource source) {
        Supplier<InformationViewExceptionBase> exceptionBaseSupplier = () -> ExceptionHandler.buildRetrieveEntityException("source", source.toString(), null, this.getClass().getName());
        EntityDetail entityDetail = Optional.ofNullable(this.parentChain.lookupEntity(source)).orElseThrow(exceptionBaseSupplier);
        return Optional.ofNullable(this.lookup(source, entityDetail)).orElseThrow(exceptionBaseSupplier);
    }

    private EntityDetail lookup(TableSource source, EntityDetail schemaDatabase) {
        List<EntityDetail> allSchemaType = this.omEntityDao.getRelatedEntities(Arrays.asList(schemaDatabase.getGUID()), "AssetSchemaType", r -> r.getEntityTwoProxy().getGUID());
        if (!CollectionUtils.isEmpty(allSchemaType)) {
            List<EntityDetail> allLinkedTablesList = this.omEntityDao.getRelatedEntities(allSchemaType.stream().map(InstanceHeader::getGUID).collect(Collectors.toList()), "AttributeForSchema", r -> r.getEntityTwoProxy().getGUID());
            return this.filterEntities(Arrays.asList("RelationalTable"), source, allLinkedTablesList);
        }
        return null;
    }

    @Override
    protected InstanceProperties getMatchingProperties(TableSource source) {
        String sourceNameRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getName());
        return this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("", new InstanceProperties(), "name", sourceNameRegex, "lookupEntity");
    }
}

