/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.contentmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportBasicOperation;
import org.odpi.openmetadata.accessservices.informationview.utils.Constants;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OMEntityDao {
    private static final Logger log = LoggerFactory.getLogger(OMEntityDao.class);
    private final OMRSRepositoryConnector enterpriseConnector;
    private final OMRSAuditLog auditLog;
    private List<String> supportedZones;

    public OMEntityDao(OMRSRepositoryConnector enterpriseConnector, List<String> supportedZones, OMRSAuditLog auditLog) {
        this.enterpriseConnector = enterpriseConnector;
        this.auditLog = auditLog;
        this.supportedZones = supportedZones;
    }

    private EntityDetail addEntity(String metadataCollectionId, String userName, String typeName, InstanceProperties instanceProperties, List<Classification> classifications, boolean zoneRestricted) throws ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, FunctionNotSupportedException {
        EntityDetail entity = this.enterpriseConnector.getRepositoryHelper().getSkeletonEntity("InformationViewOmas", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userName, typeName);
        entity.setClassifications(classifications);
        if (zoneRestricted && this.supportedZones != null && !this.supportedZones.isEmpty()) {
            instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("InformationViewOmas", instanceProperties, "zoneMembership", this.supportedZones, "addEntity");
        }
        return this.enterpriseConnector.getMetadataCollection().addEntity(userName, entity.getType().getTypeDefGUID(), instanceProperties, entity.getClassifications(), entity.getStatus());
    }

    private Relationship addRelationship(String metadataCollectionId, String typeName, InstanceProperties instanceProperties, String entityOneGUID, String entityTwoGUID) {
        Relationship relationship = null;
        try {
            relationship = this.enterpriseConnector.getRepositoryHelper().getSkeletonRelationship("InformationViewOmas", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, "informationViewOmas", typeName);
            return this.enterpriseConnector.getMetadataCollection().addRelationship("informationViewOmas", relationship.getType().getTypeDefGUID(), instanceProperties, entityOneGUID, entityTwoGUID, InstanceStatus.ACTIVE);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildAddRelationshipException(typeName, e.getMessage(), this.getClass().getName());
        }
    }

    public EntityDetail getEntity(String typeName, String qualifiedName, boolean zoneRestricted) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String qualifiedNameRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(qualifiedName);
        properties.put("qualifiedName", qualifiedNameRegex);
        InstanceProperties matchProperties = this.buildMatchingInstanceProperties(properties, zoneRestricted);
        List<EntityDetail> existingEntities = this.findEntities(matchProperties, typeName, 0, Constants.PAGE_SIZE);
        return this.checkEntities(existingEntities, qualifiedName);
    }

    public List<EntityDetail> findEntities(InstanceProperties matchProperties, String typeName, int fromElement, int pageSize) {
        List existingEntities;
        OMRSRepositoryHelper repositoryHelper = this.enterpriseConnector.getRepositoryHelper();
        TypeDef typeDef = repositoryHelper.getTypeDefByName("informationViewOmas", typeName);
        try {
            log.debug("Retrieving entities of type {} with properties {}", (Object)typeDef.getName(), (Object)matchProperties);
            existingEntities = this.enterpriseConnector.getMetadataCollection().findEntitiesByProperty("informationViewOmas", typeDef.getGUID(), matchProperties, MatchCriteria.ALL, fromElement, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, SequencingOrder.ANY, pageSize);
        }
        catch (FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            String keys = String.join((CharSequence)",", matchProperties.getInstanceProperties().keySet());
            String values = matchProperties.getInstanceProperties().values().stream().map(InstancePropertyValue::valueAsString).collect(Collectors.joining(","));
            throw ExceptionHandler.buildRetrieveEntityException(keys, values, e, this.getClass().getName());
        }
        return existingEntities;
    }

    public EntityDetail getEntityByGuid(String guid) {
        EntityDetail entity = null;
        try {
            entity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", guid);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveEntityException("guid", guid, e, this.getClass().getName());
        }
        if (entity == null) {
            throw ExceptionHandler.buildEntityNotFoundException("guid", guid, null, this.getClass().getName());
        }
        return entity;
    }

    private EntityDetail checkEntities(List<EntityDetail> existingEntities, String qualifiedName) {
        if (!CollectionUtils.isEmpty(existingEntities)) {
            return existingEntities.stream().filter(e -> qualifiedName.equals(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "qualifiedName", e.getProperties(), "checkEntities"))).findFirst().orElse(null);
        }
        return null;
    }

    private Relationship checkRelationshipExists(String relationshipType, String guid1, String guid2) {
        List<Relationship> relationships = this.getRelationships(relationshipType, guid2);
        if (!CollectionUtils.isEmpty(relationships)) {
            return relationships.stream().filter(relationship -> relationship.getType().getTypeDefName().equals(relationshipType) && this.checkRelationshipEnds((Relationship)relationship, guid1, guid2)).findFirst().orElse(null);
        }
        return null;
    }

    public List<Relationship> getRelationships(String relationshipType, String guid) {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving relationships of type {} for entity {}", (Object)relationshipType, (Object)guid);
        }
        try {
            String relationshipTypeGuid = this.enterpriseConnector.getRepositoryHelper().getTypeDefByName("informationViewOmas", relationshipType).getGUID();
            return this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", guid, relationshipTypeGuid, 0, Collections.singletonList(InstanceStatus.ACTIVE), null, null, null, Constants.PAGE_SIZE.intValue());
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveRelationshipException(guid, relationshipType, (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
    }

    private boolean checkRelationshipEnds(Relationship relationship, String guid1, String guid2) {
        String end1Guid = relationship.getEntityOneProxy().getGUID();
        String end2Guid = relationship.getEntityTwoProxy().getGUID();
        return end1Guid.equals(guid1) && end2Guid.equals(guid2) || end1Guid.equals(guid2) && end2Guid.equals(guid1);
    }

    public EntityDetail addEntity(String typeName, String qualifiedName, InstanceProperties properties, boolean zoneRestricted) throws InvalidParameterException, PropertyErrorException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, PagingErrorException, ClassificationErrorException, UserNotAuthorizedException, TypeErrorException, StatusNotSupportedException {
        return this.addEntity(typeName, qualifiedName, properties, null, zoneRestricted);
    }

    public EntityDetail addEntity(String typeName, String qualifiedName, InstanceProperties properties, List<Classification> classifications, boolean zoneRestricted) throws InvalidParameterException, StatusNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeErrorException, FunctionNotSupportedException, PagingErrorException, ClassificationErrorException, UserNotAuthorizedException, RepositoryErrorException {
        OMEntityWrapper wrapper = this.createOrUpdateEntity(typeName, qualifiedName, properties, classifications, false, zoneRestricted);
        return wrapper != null ? wrapper.getEntityDetail() : null;
    }

    public OMEntityWrapper createOrUpdateEntity(String typeName, String qualifiedName, InstanceProperties properties, List<Classification> classifications, boolean update, boolean zoneRestricted) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, PropertyErrorException, TypeErrorException, PagingErrorException, ClassificationErrorException, StatusNotSupportedException, EntityNotKnownException {
        OMEntityWrapper wrapper;
        EntityDetail entityDetail = this.getEntity(typeName, qualifiedName, zoneRestricted);
        if (entityDetail == null) {
            entityDetail = this.addEntity("", "informationViewOmas", typeName, properties, classifications, zoneRestricted);
            log.debug("Entity with qualified name {} added", (Object)qualifiedName);
            if (log.isDebugEnabled()) {
                log.debug("Entity: {}", (Object)entityDetail);
            }
            wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.NEW);
        } else {
            log.debug("Entity with qualified name {} already exists", (Object)qualifiedName);
            if (log.isDebugEnabled()) {
                log.debug("Entity: {}", (Object)entityDetail);
            }
            if (update && !EntityPropertiesUtils.matchExactlyInstanceProperties(entityDetail.getProperties(), properties)) {
                log.debug("Updating entity with qualified name {} ", (Object)qualifiedName);
                entityDetail = this.updateEntity(entityDetail, "informationViewOmas", properties, zoneRestricted);
                wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.UPDATED);
            } else {
                wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.EXISTING);
            }
        }
        return wrapper;
    }

    public OMEntityWrapper createOrUpdateExternalEntity(String userId, String typeName, String qualifiedName, String externalSourceGuid, String externalSourceName, InstanceProperties properties, List<Classification> classifications, boolean update, boolean zoneRestricted) {
        OMEntityWrapper wrapper;
        EntityDetail entityDetail = this.getEntity(typeName, qualifiedName, zoneRestricted);
        if (entityDetail == null) {
            entityDetail = this.addExternalEntity(userId, typeName, qualifiedName, externalSourceGuid, externalSourceName, properties, classifications, zoneRestricted);
            log.debug("Entity with qualified name {} added", (Object)qualifiedName);
            if (log.isDebugEnabled()) {
                log.debug("Entity: {}", (Object)entityDetail);
            }
            wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.NEW);
        } else {
            log.debug("Entity with qualified name {} already exists", (Object)qualifiedName);
            if (log.isDebugEnabled()) {
                log.debug("Entity: {}", (Object)entityDetail);
            }
            if (update && !EntityPropertiesUtils.matchExactlyInstanceProperties(entityDetail.getProperties(), properties)) {
                log.debug("Updating entity with qualified name {} ", (Object)qualifiedName);
                if (!externalSourceGuid.equals(entityDetail.getMetadataCollectionId())) {
                    throw ExceptionHandler.buildIllegalUpdateEntityException(null, this.getClass().getName());
                }
                entityDetail = this.updateEntity(entityDetail, userId, properties, zoneRestricted);
                wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.UPDATED);
            } else {
                wrapper = new OMEntityWrapper(entityDetail, OMEntityWrapper.EntityStatus.EXISTING);
            }
        }
        return wrapper;
    }

    public EntityDetail addExternalEntity(String userId, String typeName, String qualifiedName, String externalSourceGuid, String externalSourceName, InstanceProperties properties, List<Classification> classifications, boolean zoneRestricted) {
        TypeDef type = this.enterpriseConnector.getRepositoryHelper().getTypeDefByName("InformationViewOmas", typeName);
        if (zoneRestricted && this.supportedZones != null && !this.supportedZones.isEmpty()) {
            properties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("InformationViewOmas", properties, "zoneMembership", this.supportedZones, "addEntity");
        }
        properties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("InformationViewOmas", properties, "qualifiedName", qualifiedName, "addEntity");
        try {
            return this.enterpriseConnector.getMetadataCollection().addExternalEntity(userId, type.getGUID(), externalSourceGuid, externalSourceName, properties, classifications, InstanceStatus.ACTIVE);
        }
        catch (ClassificationErrorException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildAddEntityRelationship(typeName, (OMRSCheckedExceptionBase)e, ReportBasicOperation.class.getName());
        }
    }

    private EntityDetail updateEntity(EntityDetail entityDetail, String userId, InstanceProperties instanceProperties, boolean zoneRestricted) {
        if (zoneRestricted) {
            instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("InformationViewOmas", instanceProperties, "zoneMembership", this.supportedZones, "addEntity");
        }
        try {
            entityDetail = this.enterpriseConnector.getMetadataCollection().updateEntityProperties(userId, entityDetail.getGUID(), instanceProperties);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildUpdateEntityException(entityDetail.getGUID(), e, this.getClass().getName());
        }
        return entityDetail;
    }

    public Relationship addRelationship(String relationshipType, String guid1, String guid2, InstanceProperties instanceProperties) {
        Relationship relationship = this.checkRelationshipExists(relationshipType, guid1, guid2);
        if (relationship == null) {
            relationship = this.addRelationship("", relationshipType, instanceProperties, guid1, guid2);
            log.debug("Relationship {} added between: {} and {}", new Object[]{relationshipType, guid1, guid2});
            if (log.isDebugEnabled()) {
                log.debug("Relationship: {}", (Object)relationship);
            }
        } else {
            log.debug("Relationship {} already exists between: {} and {}", new Object[]{relationshipType, guid1, guid2});
        }
        return relationship;
    }

    public Relationship addExternalRelationship(String userId, String relationshipType, String externalSourceGuid, String externalSourceName, String guid1, String guid2, InstanceProperties instanceProperties) {
        Relationship relationship = this.checkRelationshipExists(relationshipType, guid1, guid2);
        if (relationship == null) {
            relationship = this.addExternalRelationship(userId, "", relationshipType, externalSourceGuid, externalSourceName, instanceProperties, guid1, guid2);
            log.debug("Relationship {} added between: {} and {}", new Object[]{relationshipType, guid1, guid2});
            if (log.isDebugEnabled()) {
                log.debug("Relationship: {}", (Object)relationship);
            }
        } else {
            log.debug("Relationship {} already exists between: {} and {}", new Object[]{relationshipType, guid1, guid2});
        }
        return relationship;
    }

    private Relationship addExternalRelationship(String userId, String metadataCollectionId, String typeName, String registrationGuid, String registrationQualifiedName, InstanceProperties instanceProperties, String entityOneGUID, String entityTwoGUID) {
        Relationship relationship = null;
        try {
            relationship = this.enterpriseConnector.getRepositoryHelper().getSkeletonRelationship("InformationViewOmas", metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, "informationViewOmas", typeName);
            return this.enterpriseConnector.getMetadataCollection().addExternalRelationship(userId, relationship.getType().getTypeDefGUID(), registrationGuid, registrationQualifiedName, instanceProperties, entityOneGUID, entityTwoGUID, InstanceStatus.ACTIVE);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildAddRelationshipException(typeName, e.getMessage(), this.getClass().getName());
        }
    }

    public InstanceProperties buildMatchingInstanceProperties(Map<String, String> properties, boolean zoneRestricted) {
        InstanceProperties instanceProperties = new InstanceProperties();
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("InformationViewOmas", instanceProperties, entry.getKey(), entry.getValue(), "throw buildMatchingInstanceProperties");
            }
        }
        if (zoneRestricted && this.supportedZones != null && !this.supportedZones.isEmpty()) {
            instanceProperties = this.enterpriseConnector.getRepositoryHelper().addStringArrayPropertyToInstance("InformationViewOmas", instanceProperties, "zoneMembership", this.supportedZones, "throw buildMatchingInstanceProperties");
        }
        return instanceProperties;
    }

    public void purgeRelationships(List<Relationship> relationship) {
        Optional.ofNullable(relationship).map(Collection::stream).orElseGet(Stream::empty).forEach(this::purgeRelationship);
    }

    public void purgeRelationship(Relationship relationship) {
        if (relationship == null || relationship.getGUID() == null || relationship.getType() == null) {
            log.debug("Nothing will be purged, invalid relationship passed as argument: {}", (Object)relationship);
        } else {
            log.debug("Purge relationship with guid {}", (Object)relationship.getGUID());
            try {
                this.enterpriseConnector.getMetadataCollection().deleteRelationship("informationViewOmas", relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID());
                this.enterpriseConnector.getMetadataCollection().purgeRelationship("informationViewOmas", relationship.getType().getTypeDefGUID(), relationship.getType().getTypeDefName(), relationship.getGUID());
            }
            catch (FunctionNotSupportedException | InvalidParameterException | RelationshipNotDeletedException | RelationshipNotKnownException | RepositoryErrorException | UserNotAuthorizedException e) {
                throw ExceptionHandler.buildDeleteRelationshipException(relationship, e, this.getClass().getName());
            }
        }
    }

    public void purgeEntity(EntitySummary entitySummary) throws RepositoryErrorException, UserNotAuthorizedException, InvalidParameterException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException {
        if (entitySummary == null || entitySummary.getGUID() == null || entitySummary.getType() == null) {
            log.debug("Nothing will be purged, invalid entity passed as argument: {}", (Object)entitySummary);
        } else {
            log.debug("Purge entity with guid {}", (Object)entitySummary.getGUID());
            this.enterpriseConnector.getMetadataCollection().deleteEntity("informationViewOmas", entitySummary.getType().getTypeDefGUID(), entitySummary.getType().getTypeDefName(), entitySummary.getGUID());
            this.enterpriseConnector.getMetadataCollection().purgeEntity("informationViewOmas", entitySummary.getType().getTypeDefGUID(), entitySummary.getType().getTypeDefName(), entitySummary.getGUID());
        }
    }

    public List<EntityDetail> getRelatedEntities(List<String> allEntitiesGuids, String relationshipType, Function<Relationship, String> relationshipEndFunction) {
        List<Relationship> relatedEntities = allEntitiesGuids.stream().flatMap(e -> Optional.ofNullable(this.getRelationships(relationshipType, (String)e)).map(Collection::stream).orElseGet(Stream::empty)).collect(Collectors.toList());
        return this.getEntityDetails(relatedEntities, relationshipEndFunction);
    }

    public List<EntityDetail> getEntityDetails(List<Relationship> relationships, Function<Relationship, String> relationshipEndFunction) {
        Set allLinkedEntitiesGuids = Optional.ofNullable(relationships).map(Collection::stream).orElseGet(Stream::empty).map(relationshipEndFunction).collect(Collectors.toSet());
        return allLinkedEntitiesGuids.stream().map(this::getEntityByGuid).collect(Collectors.toList());
    }
}

