/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.context;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.BusinessTerm;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseColumnSource;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class ContextBuilder<T> {
    protected OMRSRepositoryConnector enterpriseConnector;
    protected OMEntityDao entityDao;
    protected OMRSAuditLog auditLog;
    protected OMRSRepositoryHelper omrsRepositoryHelper;

    public ContextBuilder(OMRSRepositoryConnector enterpriseConnector, OMEntityDao entityDao, OMRSAuditLog omrsAuditLog) {
        this.enterpriseConnector = enterpriseConnector;
        this.entityDao = entityDao;
        this.omrsRepositoryHelper = enterpriseConnector.getRepositoryHelper();
    }

    protected List<T> getChildrenElements(String guid) {
        List<Relationship> elementsRelationship = this.entityDao.getRelationships("AttributeForSchema", guid);
        return Optional.ofNullable(elementsRelationship).map(Collection::stream).orElseGet(Stream::empty).map(e -> this.buildElement(this.entityDao.getEntityByGuid(e.getEntityTwoProxy().getGUID()))).collect(Collectors.toList());
    }

    abstract T buildElement(EntityDetail var1);

    protected List<BusinessTerm> getAssignedBusinessTerms(String entityGuid) {
        List<Relationship> semanticAssignments = this.entityDao.getRelationships("SemanticAssignment", entityGuid);
        return Optional.ofNullable(semanticAssignments).map(Collection::stream).orElseGet(Stream::empty).map(r -> this.retrieveBusinessTerm(r.getEntityTwoProxy().getGUID())).collect(Collectors.toList());
    }

    private BusinessTerm retrieveBusinessTerm(String businessTermGuid) {
        BusinessTerm businessTerm = new BusinessTerm();
        EntityDetail businessTermEntity = this.entityDao.getEntityByGuid(businessTermGuid);
        businessTerm.setGuid(businessTermGuid);
        businessTerm.setName(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "name", businessTermEntity.getProperties(), "retrieveReport"));
        businessTerm.setSummary(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "summary", businessTermEntity.getProperties(), "retrieveReport"));
        businessTerm.setExamples(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "examples", businessTermEntity.getProperties(), "retrieveReport"));
        businessTerm.setUsage(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "usage", businessTermEntity.getProperties(), "retrieveReport"));
        businessTerm.setQuery(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "query", businessTermEntity.getProperties(), "retrieveReport"));
        businessTerm.setAbbreviation(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "abbreviation", businessTermEntity.getProperties(), "retrieveReport"));
        businessTerm.setDescription(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "description", businessTermEntity.getProperties(), "retrieveReport"));
        businessTerm.setDisplayName(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "displayName", businessTermEntity.getProperties(), "retrieveReport"));
        return businessTerm;
    }

    protected List<Relationship> getAssetSchemaTypeRelationships(String guid) {
        return this.entityDao.getRelationships("AssetSchemaType", guid);
    }

    protected List<Source> getSources(String guid) {
        List<Relationship> relationships = this.entityDao.getRelationships("SchemaQueryImplementation", guid);
        List entities = Optional.ofNullable(relationships).map(Collection::stream).orElseGet(Stream::empty).map(r -> this.entityDao.getEntityByGuid(r.getEntityTwoProxy().getGUID())).collect(Collectors.toList());
        List<Source> sources = Optional.ofNullable(entities).map(Collection::stream).orElseGet(Stream::empty).map(this::buildSource).collect(Collectors.toList());
        return sources;
    }

    protected Source buildSource(EntityDetail entityDetail) {
        String methodName = "buildSource";
        if (this.omrsRepositoryHelper.isTypeOf("InformationViewOmas", entityDetail.getType().getTypeDefName(), "RelationalColumn")) {
            DatabaseColumnSource columnSource = new DatabaseColumnSource();
            columnSource.setGuid(entityDetail.getGUID());
            columnSource.setQualifiedName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "qualifiedName", entityDetail.getProperties(), methodName));
            return columnSource;
        }
        return null;
    }
}

