/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewColumnSource;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewSource;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupStrategy;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LookupBasedOnDataView
implements LookupStrategy {
    private static final Logger log = LoggerFactory.getLogger(DataViewSource.class);
    private OMEntityDao omEntityDao;

    public LookupBasedOnDataView(OMEntityDao omEntityDao) {
        this.omEntityDao = omEntityDao;
    }

    @Override
    public EntityDetail lookup(Source source) {
        if (!(source instanceof DataViewColumnSource)) {
            log.error("Source is not a DataViewSourceColumn");
            return null;
        }
        String qualifiedName = StringUtils.isEmpty((Object)source.getQualifiedName()) ? this.buildQualifiedName((DataViewColumnSource)source) : source.getQualifiedName();
        return this.omEntityDao.getEntity("DerivedSchemaAttribute", qualifiedName, false);
    }

    private String buildQualifiedName(DataViewColumnSource source) {
        DataViewSource dataViewSource = source.getDataViewSource();
        return QualifiedNameUtils.buildQualifiedNameForDataViewColumn(dataViewSource.getEndpointSource().getNetworkAddress(), dataViewSource.getId(), source.getId());
    }
}

