/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.ReportSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.EntityLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportLookup
extends EntityLookup<ReportSource> {
    private static final Logger log = LoggerFactory.getLogger(ReportLookup.class);

    public ReportLookup(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, EntityLookup parentChain, OMRSAuditLog auditLog) {
        super(enterpriseConnector, omEntityDao, parentChain, auditLog, "DeployedDatabaseSchema");
    }

    @Override
    public EntityDetail lookupEntity(ReportSource source) {
        EntityDetail entity = Optional.ofNullable(this.findEntity(this.getMatchingProperties(source), "DeployedReport")).orElseThrow(() -> ExceptionHandler.buildEntityNotFoundException("source", source.toString(), "DeployedReport", this.getClass().getName()));
        if (log.isDebugEnabled()) {
            log.debug("Report found [{}]", (Object)entity);
        }
        return entity;
    }

    @Override
    protected InstanceProperties getMatchingProperties(ReportSource source) {
        InstanceProperties matchProperties = new InstanceProperties();
        String sourceReportIdRegex = this.enterpriseConnector.getRepositoryHelper().getExactMatchRegex(source.getReportId());
        matchProperties = this.enterpriseConnector.getRepositoryHelper().addStringPropertyToInstance("InformationViewOmas", matchProperties, "id", sourceReportIdRegex, "getMatchingProperties");
        return matchProperties;
    }
}

