/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.BusinessTerm;
import org.odpi.openmetadata.accessservices.informationview.events.ReportElement;
import org.odpi.openmetadata.accessservices.informationview.events.SoftwareServerCapabilitySource;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.EntityReferenceResolver;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportBasicOperation;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class BasicOperation {
    private static final Logger log = LoggerFactory.getLogger(BasicOperation.class);
    protected final OMEntityDao omEntityDao;
    protected final OMRSAuditLog auditLog;
    protected final OMRSRepositoryHelper helper;
    public static final String SEPARATOR = "::";
    protected final EntityReferenceResolver entityReferenceResolver;

    public BasicOperation(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper helper, OMRSAuditLog auditLog) {
        this.omEntityDao = omEntityDao;
        this.auditLog = auditLog;
        this.helper = helper;
        this.entityReferenceResolver = new EntityReferenceResolver(lookupHelper, omEntityDao);
    }

    public SoftwareServerCapabilitySource retrieveSoftwareServerCapability(String registrationGuid, String registrationQualifiedName) {
        if (StringUtils.isEmpty((Object)registrationGuid) && StringUtils.isEmpty((Object)registrationQualifiedName)) {
            throw ExceptionHandler.buildNoRegistrationDetailsProvided(null, ReportBasicOperation.class.getName());
        }
        EntityDetail softwareServerCapability = !StringUtils.isEmpty((Object)registrationGuid) ? Optional.ofNullable(this.omEntityDao.getEntityByGuid(registrationGuid)).orElseThrow(() -> ExceptionHandler.buildEntityNotFoundException("guid", registrationGuid, "SoftwareServerCapability", ReportBasicOperation.class.getName())) : Optional.ofNullable(this.omEntityDao.getEntity("SoftwareServerCapability", registrationQualifiedName, false)).orElseThrow(() -> ExceptionHandler.buildEntityNotFoundException("qualifiedName", registrationQualifiedName, "SoftwareServerCapability", ReportBasicOperation.class.getName()));
        return this.buildSoftwareServerCapabilitySource(softwareServerCapability);
    }

    private SoftwareServerCapabilitySource buildSoftwareServerCapabilitySource(EntityDetail softwareServerCapability) {
        SoftwareServerCapabilitySource softwareServerCapabilitySource = new SoftwareServerCapabilitySource();
        softwareServerCapabilitySource.setGuid(softwareServerCapability.getGUID());
        softwareServerCapabilitySource.setQualifiedName(this.helper.getStringProperty("InformationViewOmas", "qualifiedName", softwareServerCapability.getProperties(), "retrieveSoftwareServerCapability"));
        return softwareServerCapabilitySource;
    }

    protected EntityDetail createSchemaType(String userId, String schemaAttributeTypeName, String qualifiedNameForSchemaType, String registrationGuid, String registrationQualifiedName, InstanceProperties schemaAttributeTypeProperties, String schemaTypeRelationshipName, String schemaAttributeGuid) {
        EntityDetail schemaTypeEntity = this.omEntityDao.addExternalEntity(userId, schemaAttributeTypeName, qualifiedNameForSchemaType, registrationGuid, registrationQualifiedName, schemaAttributeTypeProperties, null, false);
        this.omEntityDao.addExternalRelationship(userId, schemaTypeRelationshipName, registrationGuid, registrationQualifiedName, schemaAttributeGuid, schemaTypeEntity.getGUID(), new InstanceProperties());
        return schemaTypeEntity;
    }

    protected void addBusinessTerm(String userId, String registrationGuid, String registrationQualifiedName, String referenceableEntityGuid, String businessTermGuid) {
        if (!StringUtils.isEmpty((Object)businessTermGuid)) {
            this.omEntityDao.addExternalRelationship(userId, "SemanticAssignment", registrationGuid, registrationQualifiedName, referenceableEntityGuid, businessTermGuid, new InstanceProperties());
        }
    }

    protected void addQueryTarget(String userId, String registrationGuid, String registrationQualifiedName, String derivedColumnEntityGuid, String sourceColumnGuid, String queryValue) {
        InstanceProperties schemaQueryImplProperties = new EntityPropertiesBuilder().withStringProperty("query", queryValue).build();
        this.omEntityDao.addExternalRelationship(userId, "SchemaQueryImplementation", registrationGuid, registrationQualifiedName, derivedColumnEntityGuid, sourceColumnGuid, schemaQueryImplProperties);
    }

    protected EntityDetail addSchemaType(String userId, String qualifiedNameForType, String registrationGuid, String registrationQualifiedName, String schemaAttributeGuid, String schemaAttributeType, InstanceProperties properties) {
        InstanceProperties typeProperties = this.helper.addStringPropertyToInstance("InformationViewOmas", properties, "qualifiedName", qualifiedNameForType, "addSchemaType");
        EntityDetail schemaTypeEntity = this.createSchemaType(userId, schemaAttributeType, qualifiedNameForType, registrationGuid, registrationQualifiedName, typeProperties, "SchemaAttributeType", schemaAttributeGuid);
        return schemaTypeEntity;
    }

    protected EntityDetail addAssetSchemaType(String userId, String assetGuid, String qualifiedNameForComplexSchemaType, String registrationGuid, String registrationQualifiedName, String schemaTypeName, InstanceProperties complexSchemaTypeProperties) {
        EntityDetail complexSchemaTypeEntity = this.omEntityDao.addExternalEntity(userId, schemaTypeName, qualifiedNameForComplexSchemaType, registrationGuid, registrationQualifiedName, complexSchemaTypeProperties, null, false);
        this.omEntityDao.addExternalRelationship(userId, "AssetSchemaType", registrationGuid, registrationQualifiedName, assetGuid, complexSchemaTypeEntity.getGUID(), new InstanceProperties());
        return complexSchemaTypeEntity;
    }

    public void addSemanticAssignments(String userId, String registrationGuid, String registrationQualifiedName, List<BusinessTerm> businessTerms, EntityDetail derivedColumnEntity) {
        if (!CollectionUtils.isEmpty(businessTerms)) {
            businessTerms.forEach(bt -> this.addSemanticAssignment(userId, registrationGuid, registrationQualifiedName, (BusinessTerm)bt, derivedColumnEntity));
        }
    }

    public void addSemanticAssignment(String userId, String registrationGuid, String registrationQualifiedName, BusinessTerm bt, EntityDetail derivedColumnEntity) {
        String businessTermGuid = this.entityReferenceResolver.getBusinessTermGuid(bt);
        this.omEntityDao.addExternalRelationship(userId, "SemanticAssignment", registrationGuid, registrationQualifiedName, derivedColumnEntity.getGUID(), businessTermGuid, new InstanceProperties());
    }

    public void addQueryTargets(String userId, String registrationGuid, String registrationQualifiedName, List<Source> sources, EntityDetail derivedColumnEntity) {
        Optional.ofNullable(sources).map(Collection::stream).orElseGet(Stream::empty).forEach(s -> {
            String sourceColumnGUID = this.entityReferenceResolver.resolveSourceGuid((Source)s);
            this.addQueryTarget(userId, registrationGuid, registrationQualifiedName, derivedColumnEntity.getGUID(), sourceColumnGUID, "");
        });
    }

    protected Relationship createOrUpdateSemanticAssignment(String userId, String registrationGuid, String registrationQualifiedName, String columnGuid, BusinessTerm businessTerm, List<Relationship> existingAssignments) {
        String businessTermAssignedToColumnGuid = this.entityReferenceResolver.getBusinessTermGuid(businessTerm);
        return Optional.ofNullable(existingAssignments).map(Collection::stream).orElseGet(Stream::empty).filter(e -> e.getEntityTwoProxy().getGUID().equals(businessTermAssignedToColumnGuid)).findFirst().orElseGet(() -> this.omEntityDao.addExternalRelationship(userId, "SemanticAssignment", registrationGuid, registrationQualifiedName, columnGuid, businessTermAssignedToColumnGuid, new InstanceProperties()));
    }

    protected String buildQualifiedNameForSchemaType(String qualifiedNameForParent, String schemaType, ReportElement element) {
        return QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, schemaType, element.getName() + "_type");
    }

    protected void createOrUpdateSchemaQueryImplementation(List<Source> sources, String columnGuid) {
        List<Relationship> existingRelationships = this.omEntityDao.getRelationships("SchemaQueryImplementation", columnGuid);
        List validRelationships = sources.stream().map(source -> this.addQueryTarget(columnGuid, (Source)source, existingRelationships).getGUID()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(existingRelationships)) {
            existingRelationships.stream().filter(r -> !validRelationships.contains(r.getGUID())).forEach(this.omEntityDao::purgeRelationship);
        }
    }

    private Relationship addQueryTarget(String columnGuid, Source source, List<Relationship> existingRelationships) {
        String sourceColumnGuid = this.entityReferenceResolver.resolveSourceGuid(source);
        if (!StringUtils.isEmpty((Object)sourceColumnGuid)) {
            log.debug("source {} found.", (Object)source);
            return Optional.ofNullable(existingRelationships).map(Collection::stream).orElseGet(Stream::empty).filter(r -> r.getEntityTwoProxy().getGUID().equals(sourceColumnGuid) || r.getEntityOneProxy().getGUID().equals(sourceColumnGuid)).findFirst().orElseGet(() -> {
                InstanceProperties schemaQueryImplProperties = new EntityPropertiesBuilder().withStringProperty("query", "").build();
                return this.omEntityDao.addRelationship("SchemaQueryImplementation", columnGuid, sourceColumnGuid, schemaQueryImplProperties);
            });
        }
        log.error(MessageFormat.format("source column not found, unable to add relationship {0} between column {1} and source {2}", "SchemaQueryImplementation", columnGuid, source.toString()));
        throw ExceptionHandler.buildAddRelationshipException("SchemaQueryImplementation", null, this.getClass().getName());
    }

    protected void createOrUpdateSemanticAssignments(String userId, String registrationGuid, String registrationQualifiedName, List<BusinessTerm> businessTerms, String columnGuid) {
        List<Relationship> existingAssignments = this.omEntityDao.getRelationships("SemanticAssignment", columnGuid);
        if (CollectionUtils.isEmpty(businessTerms)) {
            this.omEntityDao.purgeRelationships(existingAssignments);
        } else {
            businessTerms.forEach(bt -> this.createOrUpdateSemanticAssignment(userId, registrationGuid, registrationQualifiedName, columnGuid, (BusinessTerm)bt, existingAssignments));
        }
    }
}

