/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityWrapper;
import org.odpi.openmetadata.accessservices.informationview.events.ReportColumn;
import org.odpi.openmetadata.accessservices.informationview.events.ReportElement;
import org.odpi.openmetadata.accessservices.informationview.events.ReportRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.ReportSection;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.ReportElementCreationException;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportBasicOperation;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesUtils;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUpdater
extends ReportBasicOperation {
    private static final Logger log = LoggerFactory.getLogger(ReportUpdater.class);

    public ReportUpdater(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper helper, OMRSAuditLog auditLog) {
        super(omEntityDao, lookupHelper, helper, auditLog);
    }

    public void updateReport(String userId, ReportRequestBody payload, String registrationGuid, String registrationQualifiedName, EntityDetail reportEntity) throws UserNotAuthorizedException, EntityNotKnownException, EntityNotDeletedException, InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException {
        String schemaTypeGuid;
        String qualifiedNameForComplexSchemaType = QualifiedNameUtils.buildQualifiedName("", "AssetSchemaType", payload.getReport().getId() + "_type");
        List<Relationship> relationships = this.omEntityDao.getRelationships("AssetSchemaType", reportEntity.getGUID());
        Relationship schemaTypeRelationship = relationships != null && !relationships.isEmpty() ? relationships.get(0) : null;
        InstanceProperties complexSchemaTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForComplexSchemaType).build();
        if (schemaTypeRelationship != null) {
            schemaTypeGuid = schemaTypeRelationship.getEntityTwoProxy().getGUID();
            InstanceProperties proxyProperties = schemaTypeRelationship.getEntityTwoProxy().getUniqueProperties();
            if (EntityPropertiesUtils.matchExactlyInstanceProperties(proxyProperties, complexSchemaTypeProperties)) {
                log.info("Entity {} already exists", (Object)qualifiedNameForComplexSchemaType);
            } else {
                this.omEntityDao.purgeEntity((EntitySummary)schemaTypeRelationship.getEntityTwoProxy());
                EntityDetail schemaTypeEntity = this.addAssetSchemaType(userId, reportEntity.getGUID(), qualifiedNameForComplexSchemaType, registrationGuid, registrationQualifiedName, "ComplexSchemaType", complexSchemaTypeProperties);
                schemaTypeGuid = schemaTypeEntity.getGUID();
            }
        } else {
            EntityDetail schemaTypeEntity = this.addAssetSchemaType(userId, reportEntity.getGUID(), qualifiedNameForComplexSchemaType, registrationGuid, registrationQualifiedName, "ComplexSchemaType", complexSchemaTypeProperties);
            schemaTypeGuid = schemaTypeEntity.getGUID();
        }
        String qualifiedNameForReport = this.helper.getStringProperty("InformationViewOmas", "qualifiedName", reportEntity.getProperties(), "updateReport");
        this.createOrUpdateElements(userId, qualifiedNameForReport, registrationGuid, registrationQualifiedName, schemaTypeGuid, payload.getReport().getReportElements());
    }

    private void createOrUpdateElements(String userId, String qualifiedNameForParent, String registrationGuid, String registrationQualifiedName, String parentGuid, List<ReportElement> reportElements) throws InvalidParameterException, EntityNotDeletedException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException, RepositoryErrorException {
        List<Relationship> relationships = this.omEntityDao.getRelationships("AttributeForSchema", parentGuid);
        List<EntityDetail> matchingEntities = this.filterMatchingEntities(relationships, reportElements);
        if (reportElements != null && !reportElements.isEmpty()) {
            reportElements.forEach(e -> this.createOrUpdateReportElement(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, matchingEntities, (ReportElement)e));
        }
    }

    private List<EntityDetail> filterMatchingEntities(List<Relationship> relationships, List<ReportElement> reportElements) throws UserNotAuthorizedException, FunctionNotSupportedException, InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException {
        ArrayList<EntityDetail> matchingEntities = new ArrayList<EntityDetail>();
        if (relationships != null && !relationships.isEmpty()) {
            for (Relationship relationship : relationships) {
                String entity2Guid = relationship.getEntityTwoProxy().getGUID();
                EntityDetail entity = this.omEntityDao.getEntityByGuid(entity2Guid);
                if (this.isReportElementDeleted(reportElements, entity.getProperties())) {
                    this.omEntityDao.purgeRelationship(relationship);
                    this.deleteSection((EntitySummary)entity);
                    continue;
                }
                matchingEntities.add(entity);
            }
        }
        return matchingEntities;
    }

    private void deleteSection(EntitySummary entity) throws RepositoryErrorException, UserNotAuthorizedException, InvalidParameterException, FunctionNotSupportedException, EntityNotKnownException, EntityNotDeletedException {
        List<Relationship> typeRelationships = this.omEntityDao.getRelationships("ComplexSchemaType", entity.getGUID());
        if (typeRelationships != null && !typeRelationships.isEmpty()) {
            EntityProxy typeProxy = typeRelationships.get(0).getEntityOneProxy();
            List<Relationship> childrenRelationships = this.omEntityDao.getRelationships("AttributeForSchema", typeProxy.getGUID());
            if (childrenRelationships != null && !childrenRelationships.isEmpty()) {
                for (Relationship relationship : childrenRelationships) {
                    this.deleteSection((EntitySummary)relationship.getEntityTwoProxy());
                }
            }
            this.omEntityDao.purgeEntity((EntitySummary)typeProxy);
        }
        this.omEntityDao.purgeEntity(entity);
    }

    private boolean isReportElementDeleted(List<ReportElement> reportElements, InstanceProperties properties) {
        String elementName = this.helper.getStringProperty("InformationViewOmas", "name", properties, "isReportElementDeleted");
        return reportElements != null && !reportElements.isEmpty() && reportElements.stream().noneMatch(e -> e.getName().equals(elementName));
    }

    private void createOrUpdateReportElement(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, List<EntityDetail> existingElements, ReportElement element) {
        try {
            if (element instanceof ReportSection) {
                this.createOrUpdateReportSection(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, (ReportSection)element, existingElements);
            } else if (element instanceof ReportColumn) {
                this.createOrUpdateReportColumn(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, (ReportColumn)element, existingElements);
            }
        }
        catch (ClassificationErrorException | EntityNotDeletedException | EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | StatusNotSupportedException | TypeErrorException | UserNotAuthorizedException e) {
            throw new ReportElementCreationException(ReportUpdater.class.getName(), InformationViewErrorCode.REPORT_ELEMENT_CREATION_EXCEPTION.getFormattedErrorMessage(element.getName(), e.getMessage()), InformationViewErrorCode.REPORT_ELEMENT_CREATION_EXCEPTION.getSystemAction(), InformationViewErrorCode.REPORT_ELEMENT_CREATION_EXCEPTION.getUserAction(), e);
        }
    }

    private void createOrUpdateReportSection(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, ReportSection reportSection, List<EntityDetail> existingElements) throws InvalidParameterException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException, RepositoryErrorException, EntityNotDeletedException {
        EntityDetail matchingSection = this.findMatchingEntityForElements((ReportElement)reportSection, existingElements);
        if (matchingSection != null) {
            String sectionTypeGuid;
            String methodName = "createOrUpdateReportSection";
            String qualifiedNameForSection = this.helper.getStringProperty("InformationViewOmas", "qualifiedName", matchingSection.getProperties(), methodName);
            String qualifiedNameForSectionType = QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, "DocumentSchemaType", reportSection.getName() + "_type");
            List<Relationship> sectionTypeRelationships = this.omEntityDao.getRelationships("SchemaAttributeType", matchingSection.getGUID());
            if (sectionTypeRelationships == null || sectionTypeRelationships.isEmpty()) {
                EntityDetail schemaType = this.createSchemaType(userId, "DocumentSchemaType", qualifiedNameForSectionType, registrationGuid, registrationQualifiedName, this.helper.addStringPropertyToInstance("InformationViewOmas", new InstanceProperties(), "qualifiedName", qualifiedNameForSectionType, "addSchemaType"), "SchemaAttributeType", matchingSection.getGUID());
                sectionTypeGuid = schemaType.getGUID();
            } else {
                sectionTypeGuid = sectionTypeRelationships.get(0).getEntityTwoProxy().getGUID();
            }
            this.createOrUpdateElements(userId, qualifiedNameForSection, registrationGuid, registrationQualifiedName, sectionTypeGuid, reportSection.getElements());
        } else {
            EntityDetail sectionTypeEntity = this.addSectionAndSectionType(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, reportSection);
            String qualifiedNameForSection = QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, "DocumentSchemaAttribute", reportSection.getName());
            this.createOrUpdateElements(userId, qualifiedNameForSection, registrationGuid, registrationQualifiedName, sectionTypeEntity.getGUID(), reportSection.getElements());
        }
    }

    private EntityDetail findMatchingEntityForElements(ReportElement reportElement, List<EntityDetail> existingElements) {
        List matchingElements = existingElements.stream().filter(e -> {
            String methodName = "findMatchingEntityForElements";
            return this.helper.getStringProperty("InformationViewOmas", "name", e.getProperties(), methodName).contains(reportElement.getName());
        }).collect(Collectors.toList());
        if (matchingElements != null && !matchingElements.isEmpty()) {
            return (EntityDetail)matchingElements.get(0);
        }
        return null;
    }

    private void createOrUpdateReportColumn(String userId, String parentQualifiedName, String parentGuid, String registrationGuid, String registrationQualifiedName, ReportColumn reportColumn, List<EntityDetail> existingElements) throws InvalidParameterException, StatusNotSupportedException, PropertyErrorException, EntityNotKnownException, TypeErrorException, FunctionNotSupportedException, PagingErrorException, ClassificationErrorException, UserNotAuthorizedException, RepositoryErrorException {
        EntityDetail matchingColumn = this.findMatchingEntityForElements((ReportElement)reportColumn, existingElements);
        if (matchingColumn != null) {
            String qualifiedNameForColumn = this.helper.getStringProperty("InformationViewOmas", "qualifiedName", matchingColumn.getProperties(), "createOrUpdateReportColumn");
            InstanceProperties columnProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForColumn).withStringProperty("name", reportColumn.getName()).withStringProperty("formula", reportColumn.getFormula()).build();
            OMEntityWrapper wrapper = this.omEntityDao.createOrUpdateEntity("DerivedSchemaAttribute", qualifiedNameForColumn, columnProperties, null, true, false);
            this.createOrUpdateSemanticAssignments(userId, registrationGuid, registrationQualifiedName, reportColumn.getBusinessTerms(), wrapper.getEntityDetail().getGUID());
            this.createOrUpdateSchemaQueryImplementation(reportColumn.getSources(), wrapper.getEntityDetail().getGUID());
            List<Relationship> columnType = this.omEntityDao.getRelationships("SchemaAttributeType", matchingColumn.getGUID());
            if (columnType == null || columnType.isEmpty()) {
                String qualifiedNameForColumnType = QualifiedNameUtils.buildQualifiedName(parentQualifiedName, "SchemaType", reportColumn.getName());
                InstanceProperties schemaAttributeTypeProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForColumnType).build();
                this.createSchemaType(userId, "SchemaType", qualifiedNameForColumnType, registrationGuid, registrationQualifiedName, schemaAttributeTypeProperties, "SchemaAttributeType", wrapper.getEntityDetail().getGUID());
            }
        } else {
            this.addReportColumn(userId, parentQualifiedName, parentGuid, registrationGuid, registrationQualifiedName, reportColumn);
        }
    }
}

