/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.server;

import org.odpi.openmetadata.accessservices.informationview.assets.DatabaseContextHandler;
import org.odpi.openmetadata.accessservices.informationview.context.DataViewContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.context.ReportContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.PropertyServerException;
import org.odpi.openmetadata.accessservices.informationview.registration.RegistrationHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.DataViewHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportHandler;
import org.odpi.openmetadata.accessservices.informationview.server.InformationViewOMASRegistration;
import org.odpi.openmetadata.accessservices.informationview.server.InformationViewServicesInstance;
import org.odpi.openmetadata.accessservices.informationview.server.InformationViewServicesInstanceMap;

class InformationViewInstanceHandler {
    private static InformationViewServicesInstanceMap instanceMap = new InformationViewServicesInstanceMap();

    InformationViewInstanceHandler() {
        new InformationViewOMASRegistration();
    }

    ReportHandler getReportCreator(String serverName) throws PropertyServerException {
        InformationViewServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getReportHandler();
        }
        String methodName = "getReportCreator";
        this.throwError(serverName, "getReportCreator");
        return null;
    }

    DataViewHandler getDataViewHandler(String serverName) throws PropertyServerException {
        InformationViewServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getDataViewHandler();
        }
        String methodName = "getDataViewHandler";
        this.throwError(serverName, "getDataViewHandler");
        return null;
    }

    DatabaseContextHandler getAssetContextHandler(String serverName) throws PropertyServerException {
        InformationViewServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getContextBuilders().getDatabaseContextHandler();
        }
        String methodName = "getDatabaseContextHandler";
        this.throwError(serverName, "getDatabaseContextHandler");
        return null;
    }

    RegistrationHandler getRegistrationHandler(String serverName) throws PropertyServerException {
        InformationViewServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRegistrationHandler();
        }
        String methodName = "getRegistrationHandler";
        this.throwError(serverName, "getRegistrationHandler");
        return null;
    }

    ReportContextBuilder getReportContextBuilder(String serverName) {
        InformationViewServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getContextBuilders().getReportContextBuilder();
        }
        String methodName = "getReportContextBuilder";
        this.throwError(serverName, "getReportContextBuilder");
        return null;
    }

    DataViewContextBuilder getDataViewContextBuilder(String serverName) {
        InformationViewServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getContextBuilders().getDataViewContextBuilder();
        }
        String methodName = "getReportContextBuilder";
        this.throwError(serverName, "getReportContextBuilder");
        return null;
    }

    private void throwError(String serverName, String methodName) throws PropertyServerException {
        InformationViewErrorCode errorCode = InformationViewErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(serverName);
        throw new PropertyServerException(this.getClass().getName(), errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

