/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.informationview.assets.DatabaseContextHandler;
import org.odpi.openmetadata.accessservices.informationview.context.DataViewContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.context.ReportContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.events.DataView;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseSource;
import org.odpi.openmetadata.accessservices.informationview.events.DeployedReport;
import org.odpi.openmetadata.accessservices.informationview.events.RegistrationRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.ReportRequestBody;
import org.odpi.openmetadata.accessservices.informationview.events.SoftwareServerCapabilitySource;
import org.odpi.openmetadata.accessservices.informationview.events.TableColumn;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.accessservices.informationview.events.TableSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.InformationViewExceptionBase;
import org.odpi.openmetadata.accessservices.informationview.registration.RegistrationHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.DataViewHandler;
import org.odpi.openmetadata.accessservices.informationview.reports.ReportHandler;
import org.odpi.openmetadata.accessservices.informationview.responses.DataViewResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.DatabaseListResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.GuidResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.InformationViewOMASAPIResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.RegistrationResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.ReportResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.TableColumnsResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.TableContextResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.TableListResponse;
import org.odpi.openmetadata.accessservices.informationview.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.informationview.server.InformationViewInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationViewRestServices {
    InformationViewInstanceHandler instanceHandler = new InformationViewInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(InformationViewRestServices.class);

    public InformationViewOMASAPIResponse submitReport(String serverName, String userId, ReportRequestBody requestBody) {
        GuidResponse response = new GuidResponse();
        try {
            ReportHandler reportCreator = this.instanceHandler.getReportCreator(serverName);
            String guid = reportCreator.submitReportModel(userId, requestBody);
            response.setGuid(guid);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse submitDataView(String serverName, String userId, DataViewRequestBody requestBody) {
        GuidResponse response = new GuidResponse();
        try {
            DataViewHandler dataViewHandler = this.instanceHandler.getDataViewHandler(serverName);
            String guid = dataViewHandler.createDataView(userId, requestBody);
            response.setGuid(guid);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse getDatabases(String serverName, String userId, int startFrom, int pageSize) {
        DatabaseListResponse response = new DatabaseListResponse();
        try {
            DatabaseContextHandler databaseContextHandler = this.instanceHandler.getAssetContextHandler(serverName);
            List<DatabaseSource> databases = databaseContextHandler.getDatabases(startFrom, pageSize);
            response.setDatabasesList(databases);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse getTablesForDatabase(String serverName, String userId, String databaseGuid, int startFrom, int pageSize) {
        TableListResponse response = new TableListResponse();
        try {
            DatabaseContextHandler databaseContextHandler = this.instanceHandler.getAssetContextHandler(serverName);
            List<TableSource> tables = databaseContextHandler.getTables(databaseGuid, startFrom, pageSize);
            response.setTableList(tables);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse getTableContext(String serverName, String userId, String tableGuid) {
        TableContextResponse response = new TableContextResponse();
        try {
            DatabaseContextHandler databaseContextHandler = this.instanceHandler.getAssetContextHandler(serverName);
            List<TableContextEvent> tables = databaseContextHandler.getTableContext(tableGuid);
            response.setTableContexts(tables);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse getTableColumns(String serverName, String userId, String tableGuid, int startFrom, int pageSize) {
        TableColumnsResponse response = new TableColumnsResponse();
        try {
            DatabaseContextHandler databaseContextHandler = this.instanceHandler.getAssetContextHandler(serverName);
            List<TableColumn> columns = databaseContextHandler.getTableColumns(tableGuid, startFrom, pageSize);
            response.setTableColumns(columns);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse registerExternalTool(String serverName, String userId, RegistrationRequestBody requestBody) {
        RegistrationResponse response = new RegistrationResponse();
        RegistrationHandler registrationHandler = this.instanceHandler.getRegistrationHandler(serverName);
        try {
            SoftwareServerCapabilitySource softwareServerCapabilitySource = registrationHandler.registerTool(requestBody);
            response.setSoftwareServerCapabilitySource(softwareServerCapabilitySource);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse lookupRegistration(String serverName, String userId, RegistrationRequestBody requestBody) {
        RegistrationResponse response = new RegistrationResponse();
        RegistrationHandler registrationHandler = this.instanceHandler.getRegistrationHandler(serverName);
        try {
            SoftwareServerCapabilitySource softwareServerCapabilitySource = registrationHandler.lookupSoftwareServerCapability(requestBody);
            response.setSoftwareServerCapabilitySource(softwareServerCapabilitySource);
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
        return response;
    }

    public InformationViewOMASAPIResponse retrieveReport(String serverName, String userId, String reportId) {
        try {
            ReportContextBuilder reportContextBuilder = this.instanceHandler.getReportContextBuilder(serverName);
            DeployedReport report = reportContextBuilder.retrieveReport(reportId);
            ReportResponse reportResponse = new ReportResponse();
            reportResponse.setReport(report);
            return reportResponse;
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
    }

    public InformationViewOMASAPIResponse retrieveDataView(String serverName, String userId, String dataViewId) {
        try {
            DataViewContextBuilder dataViewContextHandler = this.instanceHandler.getDataViewContextBuilder(serverName);
            DataView report = dataViewContextHandler.retrieveDataView(dataViewId);
            DataViewResponse reportResponse = new DataViewResponse();
            reportResponse.setDataView(report);
            return reportResponse;
        }
        catch (InformationViewExceptionBase e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleErrorResponse(e);
        }
    }

    private InformationViewOMASAPIResponse handleErrorResponse(InformationViewExceptionBase e) {
        VoidResponse response = new VoidResponse();
        response.setExceptionClassName(e.getReportingClassName());
        response.setExceptionErrorMessage(e.getReportedErrorMessage());
        response.setRelatedHTTPCode(e.getHttpErrorCode());
        response.setExceptionUserAction(e.getReportedUserAction());
        return response;
    }
}

