/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.context;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.context.ContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.events.DeployedReport;
import org.odpi.openmetadata.accessservices.informationview.events.ReportColumn;
import org.odpi.openmetadata.accessservices.informationview.events.ReportElement;
import org.odpi.openmetadata.accessservices.informationview.events.ReportSection;
import org.odpi.openmetadata.accessservices.informationview.events.ReportSource;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.ReportLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class ReportContextBuilder
extends ContextBuilder {
    private ReportLookup reportLookup;

    public ReportContextBuilder(OMRSRepositoryConnector enterpriseConnector, OMEntityDao entityDao, OMRSAuditLog auditLog) {
        super(enterpriseConnector, entityDao, auditLog);
        this.reportLookup = new ReportLookup(enterpriseConnector, entityDao, null, auditLog);
    }

    public DeployedReport retrieveReport(String reportId) {
        ReportSource source = new ReportSource();
        source.setReportId(reportId);
        EntityDetail reportEntity = Optional.ofNullable(this.reportLookup.lookupEntity(source)).orElseThrow(() -> ExceptionHandler.buildEntityNotFoundException("id", reportId, "DeployedReport", this.getClass().getName()));
        return this.buildReport(reportEntity);
    }

    private DeployedReport buildReport(EntityDetail reportEntity) {
        Date createdTime;
        DeployedReport report = new DeployedReport();
        report.setGuid(reportEntity.getGUID());
        report.setAuthor(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "author", reportEntity.getProperties(), "retrieveReport"));
        report.setLastModifier(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "lastModifier", reportEntity.getProperties(), "retrieveReport"));
        Date lastModifiedDate = this.enterpriseConnector.getRepositoryHelper().getDateProperty("InformationViewOmas", "lastModifiedTime", reportEntity.getProperties(), "retrieveReport");
        if (lastModifiedDate != null) {
            report.setLastModifiedTime(Long.valueOf(lastModifiedDate.getTime()));
        }
        if ((createdTime = this.enterpriseConnector.getRepositoryHelper().getDateProperty("InformationViewOmas", "createdTime", reportEntity.getProperties(), "retrieveReport")) != null) {
            report.setCreatedTime(Long.valueOf(createdTime.getTime()));
        }
        report.setId(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "id", reportEntity.getProperties(), "retrieveReport"));
        report.setReportName(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "name", reportEntity.getProperties(), "retrieveReport"));
        report.setReportUrl(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "name", reportEntity.getProperties(), "retrieveReport"));
        this.addReportStructure(report, reportEntity);
        return report;
    }

    private void addReportStructure(DeployedReport report, EntityDetail reportEntity) {
        List<Relationship> relationships = this.getAssetSchemaTypeRelationships(reportEntity.getGUID());
        if (relationships == null || relationships.isEmpty()) {
            return;
        }
        EntityProxy assetSchemaType = relationships.get(0).getEntityTwoProxy();
        report.setReportElements(this.getChildrenElements(assetSchemaType.getGUID()));
    }

    protected ReportElement buildElement(EntityDetail entityDetail) {
        if (entityDetail.getType().getTypeDefName().equals("DocumentSchemaAttribute")) {
            ReportSection reportElement = new ReportSection();
            reportElement.setName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", entityDetail.getProperties(), "buildElement"));
            List<Relationship> schemaType = this.entityDao.getRelationships("SchemaAttributeType", entityDetail.getGUID());
            if (schemaType != null && !schemaType.isEmpty()) {
                reportElement.setElements(this.getChildrenElements(schemaType.get(0).getEntityTwoProxy().getGUID()));
            }
            return reportElement;
        }
        ReportColumn reportElement = new ReportColumn();
        reportElement.setName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", entityDetail.getProperties(), "buildElement"));
        reportElement.setAggregation(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "aggregatingFunction", entityDetail.getProperties(), "buildElement"));
        reportElement.setFormula(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "formula", entityDetail.getProperties(), "buildElement"));
        reportElement.setBusinessTerms(this.getAssignedBusinessTerms(entityDetail.getGUID()));
        reportElement.setSources(this.getSources(entityDetail.getGUID()));
        return reportElement;
    }

    @Override
    protected List<Source> getSources(String guid) {
        return null;
    }
}

