/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.lookup;

import java.text.MessageFormat;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseColumnSource;
import org.odpi.openmetadata.accessservices.informationview.lookup.ColumnLookup;
import org.odpi.openmetadata.accessservices.informationview.lookup.DatabaseLookup;
import org.odpi.openmetadata.accessservices.informationview.lookup.DatabaseSchemaLookup;
import org.odpi.openmetadata.accessservices.informationview.lookup.EndpointLookup;
import org.odpi.openmetadata.accessservices.informationview.lookup.TableLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupHelper {
    private static final Logger log = LoggerFactory.getLogger(LookupHelper.class);
    private OMRSRepositoryConnector enterpriseConnector;
    private OMEntityDao omEntityDao;
    private OMRSAuditLog auditLog;
    private EndpointLookup endpointLookup;
    private DatabaseLookup databaseLookup;
    private DatabaseSchemaLookup databaseSchemaLookup;
    private TableLookup tableLookup;
    private ColumnLookup columnLookup;

    public LookupHelper(OMRSRepositoryConnector enterpriseConnector, OMEntityDao omEntityDao, OMRSAuditLog auditLog) {
        this.enterpriseConnector = enterpriseConnector;
        this.auditLog = auditLog;
        this.omEntityDao = omEntityDao;
        this.endpointLookup = new EndpointLookup(enterpriseConnector, omEntityDao, null, auditLog);
        this.databaseLookup = new DatabaseLookup(enterpriseConnector, omEntityDao, this.endpointLookup, auditLog);
        this.databaseSchemaLookup = new DatabaseSchemaLookup(enterpriseConnector, omEntityDao, this.databaseLookup, auditLog);
        this.tableLookup = new TableLookup(enterpriseConnector, omEntityDao, this.databaseSchemaLookup, auditLog);
        this.columnLookup = new ColumnLookup(enterpriseConnector, omEntityDao, this.tableLookup, auditLog);
    }

    public EntityDetail lookupDatabaseColumn(DatabaseColumnSource source) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("lookup database column {0}", source));
        }
        return this.columnLookup.lookupEntity(source);
    }
}

