/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.reports;

import java.util.List;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.events.ReportColumn;
import org.odpi.openmetadata.accessservices.informationview.events.ReportElement;
import org.odpi.openmetadata.accessservices.informationview.events.ReportSection;
import org.odpi.openmetadata.accessservices.informationview.lookup.LookupHelper;
import org.odpi.openmetadata.accessservices.informationview.reports.BasicOperation;
import org.odpi.openmetadata.accessservices.informationview.utils.EntityPropertiesBuilder;
import org.odpi.openmetadata.accessservices.informationview.utils.QualifiedNameUtils;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportBasicOperation
extends BasicOperation {
    private static final Logger log = LoggerFactory.getLogger(ReportBasicOperation.class);

    public ReportBasicOperation(OMEntityDao omEntityDao, LookupHelper lookupHelper, OMRSRepositoryHelper helper, OMRSAuditLog auditLog) {
        super(omEntityDao, lookupHelper, helper, auditLog);
    }

    public void addElements(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, List<ReportElement> allElements) {
        if (allElements == null || allElements.isEmpty()) {
            return;
        }
        allElements.parallelStream().forEach(e -> this.addReportElement(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, (ReportElement)e));
    }

    public void addReportElement(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, ReportElement element) {
        if (element instanceof ReportSection) {
            this.addReportSection(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, (ReportSection)element);
        } else if (element instanceof ReportColumn) {
            this.addReportColumn(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, (ReportColumn)element);
        }
    }

    private void addReportSection(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, ReportSection reportSection) {
        EntityDetail typeEntity = this.addSectionAndSectionType(userId, qualifiedNameForParent, parentGuid, registrationGuid, registrationQualifiedName, reportSection);
        String qualifiedNameForSection = QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, "DocumentSchemaAttribute", reportSection.getName());
        this.addElements(userId, qualifiedNameForSection, typeEntity.getGUID(), registrationGuid, registrationQualifiedName, reportSection.getElements());
    }

    protected EntityDetail addSectionAndSectionType(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, ReportSection reportSection) {
        String qualifiedNameForSection = QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, "DocumentSchemaAttribute", reportSection.getName());
        InstanceProperties sectionProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForSection).withStringProperty("name", reportSection.getName()).build();
        EntityDetail sectionEntity = this.omEntityDao.addExternalEntity(userId, "DocumentSchemaAttribute", qualifiedNameForSection, registrationGuid, registrationQualifiedName, sectionProperties, null, false);
        this.omEntityDao.addExternalRelationship(userId, "AttributeForSchema", registrationGuid, registrationQualifiedName, parentGuid, sectionEntity.getGUID(), new InstanceProperties());
        String qualifiedNameForSectionType = this.buildQualifiedNameForSchemaType(qualifiedNameForParent, "DocumentSchemaType", (ReportElement)reportSection);
        InstanceProperties schemaAttributeTypeProperties = new InstanceProperties();
        schemaAttributeTypeProperties = this.helper.addStringPropertyToInstance("InformationViewOmas", schemaAttributeTypeProperties, "qualifiedName", qualifiedNameForSectionType, "addSchemaType");
        return this.createSchemaType(userId, "DocumentSchemaType", qualifiedNameForSectionType, registrationGuid, registrationQualifiedName, schemaAttributeTypeProperties, "SchemaAttributeType", sectionEntity.getGUID());
    }

    protected EntityDetail addReportColumn(String userId, String qualifiedNameForParent, String parentGuid, String registrationGuid, String registrationQualifiedName, ReportColumn reportColumn) {
        String qualifiedNameForColumn = QualifiedNameUtils.buildQualifiedName(qualifiedNameForParent, "DerivedSchemaAttributeProperties", reportColumn.getName());
        InstanceProperties columnProperties = new EntityPropertiesBuilder().withStringProperty("qualifiedName", qualifiedNameForColumn).withStringProperty("name", reportColumn.getName()).withStringProperty("formula", reportColumn.getFormula()).build();
        EntityDetail derivedColumnEntity = this.omEntityDao.addExternalEntity(userId, "DerivedSchemaAttributeProperties", qualifiedNameForColumn, registrationGuid, registrationQualifiedName, columnProperties, null, false);
        this.omEntityDao.addExternalRelationship(userId, "AttributeForSchema", registrationGuid, registrationQualifiedName, parentGuid, derivedColumnEntity.getGUID(), new InstanceProperties());
        this.addQueryTargets(userId, registrationGuid, registrationQualifiedName, reportColumn.getSources(), derivedColumnEntity);
        this.addSemanticAssignments(userId, registrationGuid, registrationQualifiedName, reportColumn.getBusinessTerms(), derivedColumnEntity);
        String qualifiedNameForColumnType = this.buildQualifiedNameForSchemaType(qualifiedNameForParent, "SchemaType", (ReportElement)reportColumn);
        InstanceProperties schemaAttributeTypeProperties = new InstanceProperties();
        schemaAttributeTypeProperties = this.helper.addStringPropertyToInstance("InformationViewOmas", schemaAttributeTypeProperties, "qualifiedName", qualifiedNameForColumnType, "addReportColumn");
        this.createSchemaType(userId, "SchemaType", qualifiedNameForColumnType, registrationGuid, registrationQualifiedName, schemaAttributeTypeProperties, "SchemaAttributeType", derivedColumnEntity.getGUID());
        return derivedColumnEntity;
    }
}

