/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.context;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.odpi.openmetadata.accessservices.informationview.contentmanager.OMEntityDao;
import org.odpi.openmetadata.accessservices.informationview.context.ContextBuilder;
import org.odpi.openmetadata.accessservices.informationview.events.DataView;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewColumn;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewElement;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewModel;
import org.odpi.openmetadata.accessservices.informationview.events.DataViewSource;
import org.odpi.openmetadata.accessservices.informationview.events.Source;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.lookup.DataViewLookup;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.springframework.util.CollectionUtils;

public class DataViewContextBuilder
extends ContextBuilder<DataViewElement> {
    private DataViewLookup dataViewLookup;

    public DataViewContextBuilder(OMRSRepositoryConnector enterpriseConnector, OMEntityDao entityDao, OMRSAuditLog auditLog) {
        super(enterpriseConnector, entityDao, auditLog);
        this.dataViewLookup = new DataViewLookup(enterpriseConnector, entityDao, null, auditLog);
    }

    public DataView retrieveDataView(String dataViewId) {
        DataViewSource source = new DataViewSource();
        source.setId(dataViewId);
        EntityDetail dataViewEntity = Optional.ofNullable(this.dataViewLookup.lookupEntity(source)).orElseThrow(() -> ExceptionHandler.buildEntityNotFoundException("id", dataViewId, "InformationView", this.getClass().getName()));
        return this.buildDataView(dataViewEntity);
    }

    private DataView buildDataView(EntityDetail dataViewEntity) {
        Date createdTime;
        DataView dataView = new DataView();
        dataView.setGuid(dataViewEntity.getGUID());
        dataView.setAuthor(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "author", dataViewEntity.getProperties(), "retrieveDataView"));
        dataView.setLastModifier(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "lastModifier", dataViewEntity.getProperties(), "retrieveDataView"));
        Date lastModifiedDate = this.enterpriseConnector.getRepositoryHelper().getDateProperty("InformationViewOmas", "lastModifiedTime", dataViewEntity.getProperties(), "retrieveDataView");
        if (lastModifiedDate != null) {
            dataView.setLastModifiedTime(Long.valueOf(lastModifiedDate.getTime()));
        }
        if ((createdTime = this.enterpriseConnector.getRepositoryHelper().getDateProperty("InformationViewOmas", "createdTime", dataViewEntity.getProperties(), "retrieveDataView")) != null) {
            dataView.setCreatedTime(Long.valueOf(createdTime.getTime()));
        }
        dataView.setId(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "id", dataViewEntity.getProperties(), "retrieveDataView"));
        dataView.setNativeClass(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "nativeClass", dataViewEntity.getProperties(), "retrieveDataView"));
        dataView.setEndpointAddress(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "networkAddress", dataViewEntity.getProperties(), "retrieveDataView"));
        dataView.setName(this.enterpriseConnector.getRepositoryHelper().getStringProperty("InformationViewOmas", "name", dataViewEntity.getProperties(), "retrieveDataView"));
        this.addDataViewStructure(dataView, dataViewEntity);
        return dataView;
    }

    private void addDataViewStructure(DataView dataView, EntityDetail dataViewEntity) {
        String dataViewGuid = dataViewEntity.getGUID();
        List<Relationship> relationships = this.getAssetSchemaTypeRelationships(dataViewGuid);
        if (!CollectionUtils.isEmpty(relationships)) {
            EntityProxy assetSchemaType = relationships.get(0).getEntityTwoProxy();
            dataView.setElements(this.getChildrenElements(assetSchemaType.getGUID()));
        }
    }

    @Override
    DataViewElement buildElement(EntityDetail entityDetail) {
        String methodName = "buildElement";
        if (entityDetail.getType().getTypeDefName().equals("SchemaAttribute")) {
            DataViewModel dataViewElement = new DataViewModel();
            dataViewElement.setName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", entityDetail.getProperties(), methodName));
            List<Relationship> schemaType = this.entityDao.getRelationships("SchemaAttributeType", entityDetail.getGUID());
            if (!CollectionUtils.isEmpty(schemaType)) {
                dataViewElement.setElements(this.getChildrenElements(schemaType.get(0).getEntityTwoProxy().getGUID()));
            }
            return dataViewElement;
        }
        DataViewColumn dataViewElement = new DataViewColumn();
        dataViewElement.setName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", entityDetail.getProperties(), methodName));
        dataViewElement.setUsage(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "usage", entityDetail.getProperties(), methodName));
        dataViewElement.setComment(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "comment", entityDetail.getProperties(), methodName));
        dataViewElement.setRegularAggregate(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "aggregatingFunction", entityDetail.getProperties(), methodName));
        dataViewElement.setBusinessTerms(this.getAssignedBusinessTerms(entityDetail.getGUID()));
        dataViewElement.setSources(this.getSources(entityDetail.getGUID()));
        return dataViewElement;
    }

    @Override
    protected List<Source> getSources(String guid) {
        return null;
    }
}

