/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.informationview.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.informationview.events.BusinessTerm;
import org.odpi.openmetadata.accessservices.informationview.events.DatabaseSource;
import org.odpi.openmetadata.accessservices.informationview.events.EndpointSource;
import org.odpi.openmetadata.accessservices.informationview.events.ForeignKey;
import org.odpi.openmetadata.accessservices.informationview.events.TableColumn;
import org.odpi.openmetadata.accessservices.informationview.events.TableContextEvent;
import org.odpi.openmetadata.accessservices.informationview.events.TableSource;
import org.odpi.openmetadata.accessservices.informationview.ffdc.ExceptionHandler;
import org.odpi.openmetadata.accessservices.informationview.ffdc.InformationViewErrorCode;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.ContextLoadException;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.RetrieveEntityException;
import org.odpi.openmetadata.accessservices.informationview.ffdc.exceptions.runtime.RetrieveRelationshipException;
import org.odpi.openmetadata.accessservices.informationview.utils.Constants;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnContextBuilder {
    private static final Logger log = LoggerFactory.getLogger(ColumnContextBuilder.class);
    private OMRSRepositoryConnector enterpriseConnector;
    private OMRSRepositoryHelper omrsRepositoryHelper;
    private static String BUILD_CONTEXT_METHOD_NAME = "buildContexts";

    public ColumnContextBuilder(OMRSRepositoryConnector enterpriseConnector) {
        this.enterpriseConnector = enterpriseConnector;
        this.omrsRepositoryHelper = enterpriseConnector.getRepositoryHelper();
    }

    public List<TableContextEvent> buildContexts(String guidColumn) {
        ArrayList<TableContextEvent> tableContexts = new ArrayList<TableContextEvent>();
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
        try {
            for (Relationship relationship : this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", guidColumn, relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0)) {
                tableContexts.addAll(this.getTableContext(relationship.getEntityOneProxy().getGUID(), 0, Constants.PAGE_SIZE));
            }
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(guidColumn, (OMRSCheckedExceptionBase)e, ColumnContextBuilder.class.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Context events: {}", tableContexts);
        }
        return tableContexts;
    }

    public List<TableContextEvent> getTableContext(String tableTypeGuid, int startFrom, int pageSize) {
        if (log.isDebugEnabled()) {
            log.debug("Load table type details for entity with guid {}", (Object)tableTypeGuid);
        }
        ArrayList<TableContextEvent> tableContexts = new ArrayList<TableContextEvent>();
        EntityDetail tableTypeDetail = null;
        try {
            tableTypeDetail = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", tableTypeGuid);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e2) {
            InformationViewErrorCode code = InformationViewErrorCode.GET_ENTITY_EXCEPTION;
            throw new RetrieveEntityException(code.getHttpErrorCode(), ColumnContextBuilder.class.getName(), code.getFormattedErrorMessage("guid", tableTypeGuid, e2.getMessage()), code.getSystemAction(), code.getUserAction(), e2);
        }
        List<TableColumn> columns = this.getTableColumns(tableTypeGuid, startFrom, pageSize);
        List<Relationship> schemaAttributeTypeRelationships = this.getSchemaTypeRelationships(tableTypeDetail, "SchemaAttributeType", 0, Constants.PAGE_SIZE);
        for (Relationship schemaAttributeTypeRelationship : schemaAttributeTypeRelationships) {
            String tableGuid = schemaAttributeTypeRelationship.getEntityOneProxy().getGUID();
            EntityDetail tableEntity = null;
            try {
                tableEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", tableGuid);
                String tableName = this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", tableEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME);
                String attributeForSchemaTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
                for (Relationship parentSchemaTypeRelationship : this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", tableEntity.getGUID(), attributeForSchemaTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0)) {
                    List<TableContextEvent> events = this.getDatabaseSchemaTypeContext(parentSchemaTypeRelationship.getEntityOneProxy().getGUID());
                    tableContexts.addAll(events.stream().peek(e -> {
                        e.getTableSource().setName(tableName);
                        e.getTableSource().setGuid(tableGuid);
                        e.setTableColumns(columns);
                    }).collect(Collectors.toList()));
                }
            }
            catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e3) {
                InformationViewErrorCode code = InformationViewErrorCode.RETRIEVE_CONTEXT_EXCEPTION;
                throw new ContextLoadException(code.getHttpErrorCode(), ColumnContextBuilder.class.getName(), code.getFormattedErrorMessage(tableGuid, e3.getMessage()), code.getSystemAction(), code.getUserAction(), e3);
            }
        }
        return tableContexts;
    }

    public List<Relationship> getSchemaTypeRelationships(EntityDetail entityDetail, String schemaTypeRelationshipName, int startFrom, int pageSize) {
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", schemaTypeRelationshipName).getGUID();
        try {
            return this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", entityDetail.getGUID(), relationshipTypeGuid, startFrom, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, pageSize);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            InformationViewErrorCode code = InformationViewErrorCode.GET_RELATIONSHIP_EXCEPTION;
            throw new RetrieveRelationshipException(code.getHttpErrorCode(), ColumnContextBuilder.class.getName(), code.getFormattedErrorMessage("AttributeForSchema", entityDetail.getGUID(), e.getMessage()), code.getSystemAction(), code.getUserAction(), e);
        }
    }

    public List<TableColumn> getTableColumns(String tableTypeGuid, int startFrom, int pageSize) {
        List relationshipsToColumns;
        if (log.isDebugEnabled()) {
            log.debug("Load table columns for entity with guid {}", (Object)tableTypeGuid);
        }
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
        ArrayList<TableColumn> allColumns = new ArrayList<TableColumn>();
        try {
            relationshipsToColumns = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", tableTypeGuid, relationshipTypeGuid, startFrom, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, pageSize);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            InformationViewErrorCode code = InformationViewErrorCode.GET_RELATIONSHIP_EXCEPTION;
            throw new RetrieveRelationshipException(code.getHttpErrorCode(), ColumnContextBuilder.class.getName(), code.getFormattedErrorMessage("AttributeForSchema", tableTypeGuid, e.getMessage()), code.getSystemAction(), code.getUserAction(), e);
        }
        if (CollectionUtils.isNotEmpty((Collection)relationshipsToColumns)) {
            allColumns.addAll(relationshipsToColumns.parallelStream().map(this::buildTableColumn).collect(Collectors.toList()));
        }
        return allColumns;
    }

    private TableColumn buildTableColumn(Relationship tableTypeToColumns) {
        try {
            EntityDetail columnEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", tableTypeToColumns.getEntityTwoProxy().getGUID());
            TableColumn tableColumn = new TableColumn();
            tableColumn.setName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", columnEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME));
            tableColumn.setPosition(Integer.valueOf(this.omrsRepositoryHelper.getIntProperty("InformationViewOmas", "position", columnEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME)));
            tableColumn.setGuid(columnEntity.getGUID());
            tableColumn.setBusinessTerms(this.getBusinessTermsAssociated(columnEntity));
            tableColumn.setPrimaryKeyName(this.getPrimaryKeyClassification(columnEntity));
            if (tableColumn.getPrimaryKeyName() != null && !tableColumn.getPrimaryKeyName().isEmpty()) {
                tableColumn.setPrimaryKey(true);
            }
            tableColumn.setNullable(this.omrsRepositoryHelper.getBooleanProperty("InformationViewOmas", "isNullable", columnEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME));
            tableColumn.setUnique(this.omrsRepositoryHelper.getBooleanProperty("InformationViewOmas", "isUnique", columnEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME));
            tableColumn.setReferencedColumn(this.getReferencedColumn(columnEntity));
            EntityDetail columnTypeUniverse = this.getColumnType(columnEntity);
            tableColumn.setType(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "dataType", columnTypeUniverse.getProperties(), BUILD_CONTEXT_METHOD_NAME));
            tableColumn.setQualifiedName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "qualifiedName", columnEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME));
            return tableColumn;
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(tableTypeToColumns.getEntityTwoProxy().getGUID(), (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
    }

    private ForeignKey getReferencedColumn(EntityDetail columnEntity) {
        List<Relationship> columnForeignKeys;
        if (log.isDebugEnabled()) {
            log.debug("Load foreign keys for entity with guid {}", (Object)columnEntity.getGUID());
        }
        if (CollectionUtils.isEmpty(columnForeignKeys = this.getRelationships("ForeignKey", columnEntity.getGUID()))) {
            return null;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        for (Relationship relationship : columnForeignKeys) {
            EntityDetail foreignKeyEntity;
            if (!relationship.getEntityTwoProxy().getGUID().equals(columnEntity.getGUID())) continue;
            try {
                foreignKeyEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", relationship.getEntityOneProxy().getGUID());
            }
            catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
                InformationViewErrorCode code = InformationViewErrorCode.GET_ENTITY_EXCEPTION;
                throw new RetrieveEntityException(code.getHttpErrorCode(), ColumnContextBuilder.class.getName(), code.getFormattedErrorMessage("guid", relationship.getEntityOneProxy().getGUID(), e.getMessage()), code.getSystemAction(), code.getUserAction(), e);
            }
            ForeignKey foreignKey = new ForeignKey();
            foreignKey.setColumnGuid(foreignKeyEntity.getGUID());
            foreignKey.setForeignKeyName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", relationship.getProperties(), BUILD_CONTEXT_METHOD_NAME));
            foreignKey.setColumnName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", foreignKeyEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME));
            List<EntityDetail> tablesForColumn = this.getTablesForColumn(foreignKeyEntity.getGUID());
            foreignKey.setTableName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", tablesForColumn.get(0).getProperties(), BUILD_CONTEXT_METHOD_NAME));
            foreignKeys.add(foreignKey);
        }
        if (foreignKeys.size() == 1) {
            return (ForeignKey)foreignKeys.get(0);
        }
        if (foreignKeys.size() > 1) {
            String allReferencedColumns = foreignKeys.stream().map(ForeignKey::getColumnGuid).collect(Collectors.joining(", "));
            log.error("Column {} is referencing more than one column from another table: {}", (Object)columnEntity.getGUID(), (Object)allReferencedColumns);
        }
        return null;
    }

    private List<Relationship> getRelationships(String relationshipTypeName, String guid) {
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", relationshipTypeName).getGUID();
        try {
            return this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", guid, relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveEntityException("guid", guid, e, this.getClass().getName());
        }
    }

    public List<EntityDetail> getTablesForColumn(String columnEntityGuid) {
        if (log.isDebugEnabled()) {
            log.debug("Load table for column with guid {}", (Object)columnEntityGuid);
        }
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
        try {
            Relationship columnToTableType = (Relationship)this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", columnEntityGuid, relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0).get(0);
            EntityDetail tableTypeEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", columnToTableType.getEntityOneProxy().getGUID());
            relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "SchemaAttributeType").getGUID();
            List relationshipToTable = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", tableTypeEntity.getGUID(), relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0);
            return relationshipToTable.stream().map(r -> {
                try {
                    return this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", r.getEntityOneProxy().getGUID());
                }
                catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
                    throw ExceptionHandler.buildRetrieveEntityException("guid", r.getGUID(), e, this.getClass().getName());
                }
            }).collect(Collectors.toList());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(columnEntityGuid, (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
    }

    public List<TableSource> getTablesForDatabase(String databaseEntityGuid, int startFrom, int pageSize) {
        if (log.isDebugEnabled()) {
            log.debug("Load table for database with guid {}", (Object)databaseEntityGuid);
        }
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "DataContentForDataSet").getGUID();
        try {
            List databaseToDbSchemaRelationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", databaseEntityGuid, relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0);
            return databaseToDbSchemaRelationships.parallelStream().flatMap(r -> this.getTablesForSchema(r.getEntityTwoProxy().getGUID(), startFrom, pageSize).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(databaseEntityGuid, (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
    }

    private List<TableSource> getTablesForSchema(String databaseSchemaGuid, int startFrom, int pageSize) {
        try {
            EntityDetail dbSchemaEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", databaseSchemaGuid);
            String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "AssetSchemaType").getGUID();
            Relationship dbSchemaToSchemaType = (Relationship)this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", dbSchemaEntity.getGUID(), relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0).get(0);
            EntityDetail dbSchemaTypeEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", dbSchemaToSchemaType.getEntityTwoProxy().getGUID());
            String schemaName = this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", dbSchemaEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME);
            relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "AttributeForSchema").getGUID();
            List dbSchemaTypeToTableRelationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", dbSchemaTypeEntity.getGUID(), relationshipTypeGuid, startFrom, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, pageSize);
            return Optional.ofNullable(dbSchemaTypeToTableRelationships).map(Collection::stream).orElseGet(Stream::empty).map(r -> this.buildTableSource(schemaName, (Relationship)r)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveEntityException("guid", databaseSchemaGuid, e, this.getClass().getName());
        }
    }

    private TableSource buildTableSource(String schemaName, Relationship relationship) {
        String tableGuid = relationship.getEntityTwoProxy().getGUID();
        try {
            EntityDetail tableEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", tableGuid);
            String tableName = this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", tableEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME);
            TableSource tableSource = new TableSource();
            tableSource.setName(tableName);
            tableSource.setGuid(tableGuid);
            tableSource.setSchemaName(schemaName);
            return tableSource;
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            log.error(InformationViewErrorCode.GET_ENTITY_EXCEPTION.getFormattedErrorMessage(new String[0]), e);
            return null;
        }
    }

    private String getPrimaryKeyClassification(EntityDetail columnEntity) {
        if (columnEntity.getClassifications() == null || columnEntity.getClassifications().isEmpty()) {
            return null;
        }
        Classification classification = columnEntity.getClassifications().stream().filter(e -> e.getName().equals("PrimaryKey")).findFirst().orElse(null);
        return classification != null ? this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", classification.getProperties(), BUILD_CONTEXT_METHOD_NAME) : null;
    }

    private EntityDetail getColumnType(EntityDetail columnEntity) {
        if (log.isDebugEnabled()) {
            log.debug("Load column type for entity with guid {}", (Object)columnEntity.getGUID());
        }
        List<Relationship> columnToColumnType = this.getSchemaTypeRelationships(columnEntity, "SchemaAttributeType", 0, Constants.PAGE_SIZE);
        try {
            return this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", columnToColumnType.get(0).getEntityOneProxy().getGUID());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveEntityException("guid", columnEntity.getGUID(), e, this.getClass().getName());
        }
    }

    private List<BusinessTerm> getBusinessTermsAssociated(EntityDetail columnEntity) {
        List<Relationship> btRelationships;
        if (log.isDebugEnabled()) {
            log.debug("Load business term associated to column with guid {}", (Object)columnEntity.getGUID());
        }
        if ((btRelationships = this.getRelationships("SemanticAssignment", columnEntity.getGUID())) != null && !btRelationships.isEmpty()) {
            return btRelationships.stream().map(btRelationship -> {
                EntityDetail btDetail;
                String businessTermGuid = btRelationship.getEntityTwoProxy().getGUID();
                try {
                    btDetail = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", businessTermGuid);
                }
                catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
                    throw ExceptionHandler.buildRetrieveEntityException("guid", businessTermGuid, e, this.getClass().getName());
                }
                return this.buildBusinessTerm(btDetail);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<TableContextEvent> getDatabaseSchemaTypeContext(String dbSchemaTypeGuid) {
        List relationships;
        if (log.isDebugEnabled()) {
            log.debug("Load db schema type with guid {}", (Object)dbSchemaTypeGuid);
        }
        ArrayList<TableContextEvent> tableContexts = new ArrayList<TableContextEvent>();
        String assetSchemaTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "AssetSchemaType").getGUID();
        try {
            relationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", dbSchemaTypeGuid, assetSchemaTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            InformationViewErrorCode code = InformationViewErrorCode.GET_RELATIONSHIP_EXCEPTION;
            throw new RetrieveRelationshipException(code.getHttpErrorCode(), ColumnContextBuilder.class.getName(), code.getFormattedErrorMessage("guid", dbSchemaTypeGuid, "AssetSchemaType", e.getMessage()), code.getSystemAction(), code.getUserAction(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Loaded AssetSchemaType relationships for {}", (Object)dbSchemaTypeGuid);
        }
        for (Relationship relationship : relationships) {
            List<TableContextEvent> events = this.getDeployedDatabaseSchemaContext(relationship.getEntityOneProxy().getGUID());
            tableContexts.addAll(events);
        }
        return tableContexts;
    }

    private List<TableContextEvent> getDeployedDatabaseSchemaContext(String deployedDatabaseSchemaGuid) {
        if (log.isDebugEnabled()) {
            log.debug("Load deployed db schema with guid {}", (Object)deployedDatabaseSchemaGuid);
        }
        ArrayList<TableContextEvent> allEvents = new ArrayList<TableContextEvent>();
        try {
            EntityDetail deployedDatabaseSchemaEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", deployedDatabaseSchemaGuid);
            InstanceProperties deployedDatabaseSchemaEntityProperties = deployedDatabaseSchemaEntity.getProperties();
            String schemaName = this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", deployedDatabaseSchemaEntityProperties, BUILD_CONTEXT_METHOD_NAME);
            List<Relationship> dbRelationships = this.getRelationships("DataContentForDataSet", deployedDatabaseSchemaGuid);
            for (Relationship relationship : dbRelationships) {
                List<TableContextEvent> events = this.getDatabaseContext(relationship.getEntityOneProxy().getGUID());
                allEvents.addAll(events.stream().peek(e -> e.getTableSource().setSchemaName(schemaName)).collect(Collectors.toList()));
            }
            return allEvents;
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e2) {
            throw ExceptionHandler.buildRetrieveContextException(deployedDatabaseSchemaGuid, (OMRSCheckedExceptionBase)e2, this.getClass().getName());
        }
    }

    public List<TableContextEvent> getDatabaseContext(String databaseGuid) {
        if (log.isDebugEnabled()) {
            log.debug("Load database details entity with guid {}", (Object)databaseGuid);
        }
        ArrayList<TableContextEvent> allEvents = new ArrayList<TableContextEvent>();
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "ConnectionToAsset").getGUID();
        try {
            InstanceProperties databaseEntityProperties = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", databaseGuid).getProperties();
            List relationships = this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", databaseGuid, relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0);
            if (CollectionUtils.isNotEmpty((Collection)relationships)) {
                TableContextEvent event = this.getConnectionContext(((Relationship)relationships.get(0)).getEntityOneProxy().getGUID());
                String databaseName = this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "name", databaseEntityProperties, BUILD_CONTEXT_METHOD_NAME);
                event.getTableSource().getDatabaseSource().setName(databaseName);
                event.getTableSource().getDatabaseSource().setGuid(databaseGuid);
                allEvents.add(event);
            }
            return allEvents;
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(databaseGuid, (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
    }

    public TableContextEvent getConnectionContext(String connectionEntityGuid) {
        if (log.isDebugEnabled()) {
            log.debug("Load connection details for entity with guid {}", (Object)connectionEntityGuid);
        }
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "ConnectionEndpoint").getGUID();
        Relationship relationshipToEndpoint = null;
        try {
            relationshipToEndpoint = (Relationship)this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", connectionEntityGuid, relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0).get(0);
        }
        catch (EntityNotKnownException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(connectionEntityGuid, (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
        TableContextEvent event = this.getEndpointDetails(relationshipToEndpoint.getEntityOneProxy().getGUID());
        EntityDetail connectorTypeEntity = this.getConnectorTypeProviderName(connectionEntityGuid);
        event.getTableSource().getDatabaseSource().getEndpointSource().setConnectorProviderName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "connectorProviderClassName", connectorTypeEntity.getProperties(), BUILD_CONTEXT_METHOD_NAME));
        return event;
    }

    private EntityDetail getConnectorTypeProviderName(String connectionEntityGuid) {
        String relationshipTypeGuid = this.omrsRepositoryHelper.getTypeDefByName("informationViewOmas", "ConnectionConnectorType").getGUID();
        try {
            Relationship relationshipToConnectorType = (Relationship)this.enterpriseConnector.getMetadataCollection().getRelationshipsForEntity("informationViewOmas", connectionEntityGuid, relationshipTypeGuid, 0, Arrays.asList(InstanceStatus.ACTIVE), null, null, null, 0).get(0);
            return this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", relationshipToConnectorType.getEntityTwoProxy().getGUID());
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | FunctionNotSupportedException | InvalidParameterException | PagingErrorException | PropertyErrorException | RepositoryErrorException | TypeErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(connectionEntityGuid, (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
    }

    private TableContextEvent getEndpointDetails(String endpointGuid) {
        EntityDetail endpointEntity;
        if (log.isDebugEnabled()) {
            log.debug("Load endpoint details for entity with guid {}", (Object)endpointGuid);
        }
        String methodName = "getEndpointDetails";
        try {
            endpointEntity = this.enterpriseConnector.getMetadataCollection().getEntityDetail("informationViewOmas", endpointGuid);
        }
        catch (EntityNotKnownException | EntityProxyOnlyException | InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
            throw ExceptionHandler.buildRetrieveContextException(endpointGuid, (OMRSCheckedExceptionBase)e, this.getClass().getName());
        }
        TableContextEvent tableContextEvent = new TableContextEvent();
        TableSource tableSource = new TableSource();
        tableContextEvent.setTableSource(tableSource);
        String address = this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "networkAddress", endpointEntity.getProperties(), methodName);
        DatabaseSource databaseSource = new DatabaseSource();
        EndpointSource endpointSource = new EndpointSource();
        databaseSource.setEndpointSource(endpointSource);
        tableSource.setDatabaseSource(databaseSource);
        endpointSource.setNetworkAddress(address);
        endpointSource.setProtocol(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "protocol", endpointEntity.getProperties(), methodName));
        return tableContextEvent;
    }

    public List<EntitySummary> getAssignedColumns(String businessTermGuid) {
        ArrayList<EntitySummary> entities = new ArrayList<EntitySummary>();
        List<Relationship> columnsAssigned = null;
        columnsAssigned = this.getRelationships("SemanticAssignment", businessTermGuid);
        if (columnsAssigned != null && !columnsAssigned.isEmpty()) {
            return columnsAssigned.stream().filter(r -> "RelationalColumn".equals(r.getEntityOneProxy().getType().getTypeDefName())).map(Relationship::getEntityOneProxy).collect(Collectors.toList());
        }
        return entities;
    }

    public BusinessTerm buildBusinessTerm(EntityDetail businessTermEntity) {
        BusinessTerm businessTerm = new BusinessTerm();
        businessTerm.setGuid(businessTermEntity.getGUID());
        String methodName = "buildBusinessTerm";
        InstanceProperties properties = businessTermEntity.getProperties();
        businessTerm.setQualifiedName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "qualifiedName", properties, methodName));
        businessTerm.setSummary(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "summary", properties, methodName));
        businessTerm.setName(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "displayName", properties, methodName));
        businessTerm.setExamples(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "examples", properties, methodName));
        businessTerm.setAbbreviation(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "abbreviation", properties, methodName));
        businessTerm.setQuery(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "query", properties, methodName));
        businessTerm.setDescription(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "description", properties, methodName));
        businessTerm.setUsage(this.omrsRepositoryHelper.getStringProperty("InformationViewOmas", "usage", properties, methodName));
        return businessTerm;
    }
}

